/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp.util;

import java.text.NumberFormat;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.Assert;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.datacomp.util.IProgressRefresher;
import kd.isc.iscb.platform.core.meta.SyncProgressRefresher;
import kd.isc.iscb.util.dt.D;

public class DataCompProgressRefresher
implements IProgressRefresher {
    private static Log logger = LogFactory.getLog(SyncProgressRefresher.class);
    protected PageCache pageCache;

    @Override
    public void setCount(int sucCount, int errCount) {
        errCount = D.i((Object)this.pageCache.get("errCount")) + errCount;
        sucCount = D.i((Object)this.pageCache.get("sucCount")) + sucCount;
        this.pageCache.put("errCount", String.valueOf(errCount));
        this.pageCache.put("sucCount", String.valueOf(sucCount));
    }

    public DataCompProgressRefresher(String pageId) {
        Assert.notNull((Object)pageId, (String)ResManager.loadKDString((String)"pageId\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String)"DataCompProgressRefresher_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.pageCache = new PageCache(pageId);
    }

    protected DataCompProgressRefresher() {
    }

    @Override
    public int refresh(int i, int total, int noExist, int noUpdate, int noSame) {
        try {
            if (this.pageCache.get("startprogress") != null) {
                float value = Math.min(100.0f, (float)(i + 1) * 100.0f / (float)(total + 1));
                String progress = DataCompProgressRefresher.getNumberFormatter().format(value);
                this.pageCache.put("progress", progress);
                this.pageCache.put("noSame", String.valueOf(noSame));
                this.pageCache.put("noUpdate", String.valueOf(noUpdate));
                this.pageCache.put("noExist", String.valueOf(noExist));
                this.pageCache.put("srcTotal", String.valueOf(total));
                if (this.isStop()) {
                    return -1;
                }
            }
            return i;
        }
        catch (Throwable e) {
            logger.warn(e);
            return i;
        }
    }

    @Override
    public int refresh(int i, int total) {
        try {
            if (this.pageCache.get("startprogress") != null) {
                i = D.i((Object)this.pageCache.get("var_fresh")) + i;
                float value = Math.min(100.0f, (float)(i + 1) * 100.0f / (float)(total + 1));
                String progress = DataCompProgressRefresher.getNumberFormatter().format(value);
                this.pageCache.put("progress", progress);
                this.pageCache.put("totalCount", String.valueOf(total));
                this.pageCache.put("var_fresh", String.valueOf(i));
                if (this.isStop()) {
                    return -1;
                }
            }
            return i;
        }
        catch (Throwable e) {
            logger.warn(e);
            return i;
        }
    }

    @Override
    public void reset() {
        this.pageCache.put("text", ResManager.loadKDString((String)"\u5bf9\u6bd4\u5b8c\u6210", (String)"DataCompProgressRefresher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.pageCache.put("startprogress", "false");
        this.pageCache.put("progress", "100");
    }

    @Override
    public void notifyCancel() {
        this.pageCache.put("text", ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u64a4\u9500", (String)"DataCompProgressRefresher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.pageCache.put("startprogress", "false");
    }

    @Override
    public void notifyError() {
        this.pageCache.put("text", ResManager.loadKDString((String)"\u5bf9\u6bd4\u51fa\u73b0\u5f02\u5e38", (String)"DataCompProgressRefresher_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.pageCache.put("startprogress", "false");
        this.pageCache.put("state", "F");
    }

    private boolean isStop() {
        String startProgress = this.pageCache.get("startprogress");
        return !StringUtils.isBlank((String)startProgress) && "false".equals(startProgress);
    }

    private static NumberFormat getNumberFormatter() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        return numberFormat;
    }
}

