/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Timestamp;
import java.util.Random;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.DcTriggerApiDispatcher;
import kd.isc.iscb.platform.core.api.IntegrateObjectApiDispatcher;
import kd.isc.iscb.platform.core.api.IntegrateSchemaApiDispatcher;
import kd.isc.iscb.platform.core.apis.ApiInvokeStat;
import kd.isc.iscb.platform.core.connector.ischub.HubEventBindingCache;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.connector.self.IscBizListener;
import kd.isc.iscb.platform.core.consume.IscConsumeInfo;
import kd.isc.iscb.platform.core.dc.DataStreamCleanerTask;
import kd.isc.iscb.platform.core.dc.mq.MessageConsumer;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.c.JobMutexLoader;
import kd.isc.iscb.platform.core.job.c.JobServerCleaner;
import kd.isc.iscb.platform.core.job.c.JobServerMonitor;
import kd.isc.iscb.platform.core.job.c.JobServerState;
import kd.isc.iscb.platform.core.job.pbc.PbcInstCleaner;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.log.CountFailedEventJob;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.dt.D;

public class DataCopyEnv
implements Task {
    private static Log logger = LogFactory.getLog(DataCopyEnv.class);
    private static Random rnd = new Random();
    private String id;

    public static void registerIscServiceApi() {
        QFilter filter = new QFilter("number", "=", (Object)"IscServiceDispatcher");
        DynamicObject svc = BusinessDataServiceHelper.loadSingle((String)"open_apiservice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (svc != null) {
            return;
        }
        svc = BusinessDataServiceHelper.newDynamicObject((String)"open_apiservice");
        svc.set("number", (Object)"IscServiceDispatcher");
        svc.set("name", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u670d\u52a1\u8c03\u7528\u8f6c\u53d1\u5668", (String)"DataCopyEnv_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        svc.set("appid", (Object)"TV3/VDJ86RC");
        svc.set("apiservicetype", (Object)2);
        svc.set("enable", (Object)1);
        svc.set("status", (Object)"C");
        svc.set("urlformat", (Object)"/app/iscb/IscServiceDispatcher");
        svc.set("reqtype", (Object)0);
        svc.set("reptype", (Object)0);
        svc.set("httpmethod", (Object)1);
        svc.set("contenttype", (Object)0);
        svc.set("creator", (Object)RequestContext.get().getUserId());
        svc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        String plugin = "[{\"Type\":0,\"_Type_\":\"Plugin\",\"ClassName\":\"kd.isc.iscb.connector.ierp.IscServiceDispatcher\",\"Enabled\":true,\"rowKey\":null}]";
        svc.set("plugin", (Object)plugin);
        ExecutionData.execute(svc, "save");
    }

    @Override
    public void run() {
        try {
            DataCopyEnv.initEnv();
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private static void initEnv() {
        DataCopyEnv.initBizListener();
        DataCopyEnv.initMessageConsumers();
        DataCopyEnv.initHubBindingCache();
        ScheduleManager.submit((Task)new JobServerState(), rnd.nextInt(100) + 10);
        ScheduleManager.submit((Task)new JobServerMonitor(), rnd.nextInt(100) + 120);
        ScheduleManager.submit((Task)new JobMutexLoader(), rnd.nextInt(100) + 120);
        ScheduleManager.submit((Task)new JobServerCleaner(), rnd.nextInt(500) + 1800);
        JobEngine.notify(System.currentTimeMillis() + (long)rnd.nextInt(60000) + 240000L);
        ScheduleManager.submit(DataCopyEnv.createOtherJob(), rnd.nextInt(500) + 50);
        ApiInvokeStat.initTimerTask();
        IscConsumeInfo.initConsumeRecordJob();
        CountFailedEventJob.createCountEventJob();
        ScheduleManager.submit((Task)new DataStreamCleanerTask(), rnd.nextInt(240) + 3600);
        ScheduleManager.submit((Task)new PbcInstCleaner(), rnd.nextInt(240) + 1800);
    }

    private static void initHubBindingCache() {
        try {
            HubEventBindingCache.resetCache();
        }
        catch (Throwable e) {
            logger.warn("initHubBindingCache failed", e);
        }
    }

    private static void initMessageConsumers() {
        try {
            MessageConsumer.init();
        }
        catch (Throwable e) {
            logger.warn("MessageConsumer.init() failed", e);
        }
    }

    private static void initBizListener() {
        try {
            IscBizListener.init();
        }
        catch (Throwable e) {
            logger.warn("IscBizListener.init() failed", e);
        }
    }

    private static Task createOtherJob() {
        return new Task(){
            private String id = UUID.randomUUID().toString();

            @Override
            public void run() {
                DataCopyEnv.doOtherJob();
            }

            @Override
            public String getId() {
                return this.id;
            }
        };
    }

    private static void doOtherJob() {
        DataCopyEnv.registerIscServiceApi();
        IntegrateSchemaApiDispatcher.registerApiService();
        IntegrateObjectApiDispatcher.registerApiService();
        DcTriggerApiDispatcher.registerApiService();
        LicenseCache.asyncRefreshTenant();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public DataCopyEnv(String accountId) {
        this.id = "INIT_" + accountId;
    }
}

