/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.lang.constant.Constable;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.isc.iscb.platform.core.dc.DataCopyJobFactory;
import kd.isc.iscb.platform.core.dc.DataCopyThread;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class DataCopyJob
implements Job {
    public static final JobFactory FACTORY = new DataCopyJobFactory();
    private boolean isLight;
    private long executionId;
    private boolean first;
    private String number;
    private long jobMutex;

    public DataCopyJob(String number, boolean isLight, long executionId, boolean first, long jobMutex) {
        this.number = number;
        this.executionId = executionId;
        this.isLight = isLight;
        this.first = first;
        this.jobMutex = jobMutex;
    }

    DataCopyJob(String number, Map<String, Object> params) {
        this.number = number;
        this.isLight = D.x((Object)params.get("light"));
        this.first = D.x((Object)params.get("first"));
        this.executionId = D.l((Object)params.get("id"));
        this.jobMutex = D.l((Object)params.get("job_mutex"));
    }

    @Override
    public long getMutex() {
        return this.jobMutex;
    }

    @Override
    public final long getOwnerId() {
        return this.executionId;
    }

    @Override
    public boolean isLightTask() {
        return this.isLight;
    }

    @Override
    public String getParam() {
        LinkedHashMap<String, Constable> params = new LinkedHashMap<String, Constable>(16);
        params.put("id", Long.valueOf(this.executionId));
        params.put("light", Boolean.valueOf(this.isLight));
        params.put("first", Boolean.valueOf(this.first));
        params.put("job_mutex", Long.valueOf(this.jobMutex));
        return Json.toString(params, (boolean)true);
    }

    @Override
    public String getTitle() {
        return this.number;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        new DataCopyThread(this.executionId, this.first).run();
    }
}

