/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyInput;
import kd.isc.iscb.platform.core.dc.e.DataCopyOidLog;
import kd.isc.iscb.platform.core.dc.e.DataCopyOidLookup;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.DataCopyRunner;
import kd.isc.iscb.platform.core.dc.e.ExecutionLogRetry;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.dc.s.CallbackAppendType;
import kd.isc.iscb.platform.core.dc.s.ExtendType;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.params.Callback;
import kd.isc.iscb.platform.core.syndata.MapDataUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.DataTypeEqualsUtil;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleConfig;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ListAsReader;
import kd.isc.iscb.util.io.ListAsWriter;
import kd.isc.iscb.util.io.NullObjectWriter;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.io.ObjectWriter;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCopyOpenApi {
    private static final String DBLINK_ID = "dblink_id";
    private static final String DATA = "data";
    private static final String ENTITY_ISC_VALUE_CONVER_RULE = "isc_value_conver_rule";
    private static final String ENTITY_ISC_DATA_COPY_EXEC_LOG = "isc_data_copy_exec_log";
    private static final String PARAMS = "params";
    private static final String ID = "id";
    private static final String REMARK = "remark";
    private static final String IGNORED_COUNT = "ignored_count";
    private static final String FAILED_COUNT = "failed_count";
    private static final String SUCCESS_COUNT = "success_count";
    private static final String STATE = "state";
    private static final String ENTITY_ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final String ERROR_STACK_TRACE = "errorStackTrace";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String FIELD_DB_LINK = "dblink";
    private static final String ENTITY_ISC_DATA_SOURCE = "isc_data_source";
    private static final String ENTITY_ISC_DATA_COPY = "isc_data_copy";
    private static final String TOTAL_COUNT = "total_count";
    private static final String NUMBER = "number";
    private static final String ENTITY_ISC_DATA_COPY_TRIGGER = "isc_data_copy_trigger";
    private static final String EXECUTION_ID = "execution_id";
    private static final String EXECUTION_STATE = "execution_state";
    private static final String EXECUTION_NUMBER = "execution_number";
    private static final String TRIGGER_NUMBER = "trigger_number";
    private static final String CLOUD_ID = "cloud_id";
    private static final String APP_ID = "app_id";
    private static final String SERVICE_NAME = "service_name";
    private static final String METHOD_NAME = "method_name";
    private static final String[] keys = new String[]{"cloud_id", "app_id", "service_name", "method_name"};
    private static final String SUCCESS_KEY = "success";

    private static String get_MSG_SCHEMA_NUMBER_REQUIRED() {
        return ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataCopyOpenApi_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    public static Map<String, Object> lookupTargetOid(String src_oid, String src_cn_number, String src_table, String target_cn_number, String tar_table) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);){
            String target_oid = DataCopyOpenApi.lookupTargetOid(cn, src_oid, src_cn_number, src_table, target_cn_number, tar_table);
            result.put("target_oid", target_oid);
            result.put(SUCCESS_KEY, Boolean.TRUE);
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    public static String lookupTargetOid(Connection cn, String src_oid, String src_cn_number, String src_table, String target_cn_number, String tar_table) {
        String sql = "select fid from t_isc_database_link where fnumber=?";
        Object src_cn_id = DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(src_cn_number), Collections.singletonList(12));
        Object target_cn_id = DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(target_cn_number), Collections.singletonList(12));
        return DataCopyOidLookup.lookup(src_oid, D.l((Object)src_cn_id), src_table, D.l((Object)target_cn_id), tar_table);
    }

    private static void setError(Map<String, Object> result, Throwable e) {
        result.put(SUCCESS_KEY, Boolean.FALSE);
        String s = StringUtil.toString((Throwable)e);
        result.put("msg", s);
    }

    public static Map<String, Object> doCopy(String trigger_number, Map<String, Object> params, Map<String, Object> callbackMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put(TRIGGER_NUMBER, trigger_number);
            params = params == null ? new HashMap<String, Object>() : params;
            Callback callbackInst = DataCopyOpenApi.getCallback(callbackMap);
            DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
            String execution_number = DataCopyOpenApi.doCopyByTrigger(trigger, params, callbackInst, null);
            result.put(EXECUTION_NUMBER, execution_number);
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put("msg", ResManager.loadKDString((String)"\u63d0\u4ea4\u4efb\u52a1\u6210\u529f\uff01", (String)"DataCopyOpenApi_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    private static Callback getCallback(Map<String, Object> callbackMap) {
        Callback callbackInst = null;
        if (callbackMap != null && callbackMap.size() > 0) {
            for (String key : keys) {
                DataCopyOpenApi.checkNotEmpty(key, (String)callbackMap.get(key));
            }
            String cloud_id = (String)callbackMap.get(CLOUD_ID);
            String app_id = (String)callbackMap.get(APP_ID);
            String service_name = (String)callbackMap.get(SERVICE_NAME);
            String method_name = (String)callbackMap.get(METHOD_NAME);
            callbackInst = new Callback(cloud_id, app_id, service_name, method_name);
            callbackInst.setParam1(D.s((Object)callbackMap.get("param1")));
            callbackInst.setParam2(D.s((Object)callbackMap.get("param2")));
            callbackInst.setParam3(D.s((Object)callbackMap.get("param3")));
        }
        return callbackInst;
    }

    private static void checkNotEmpty(String key, String value) {
        if (StringUtils.isEmpty((String)value)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u56de\u8c03\u4fe1\u606f\u4e2d%1$s\u7684\u503c\u4e3a\u7a7a", (String)"DataCopyOpenApi_52", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
        }
    }

    public static String doCopyById(Object id, Map<String, Object> params, Callback callback, DynamicObject parent_execution) {
        Assert.notNull((Object)id, (String)ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848ID\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"DataCopyOpenApi_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DynamicObject trigger = DataCopyTrigger.get(D.l((Object)id));
        return DataCopyOpenApi.doCopyByTrigger(trigger, params, callback, parent_execution);
    }

    public static String doCopyByTrigger(DynamicObject trigger, Map<String, Object> params, Callback callback, DynamicObject parent_execution) {
        DynamicObject execution = DataCopyOpenApi.execution(trigger, params, callback, parent_execution);
        DataCopyTask.start(execution);
        return execution.getString(NUMBER);
    }

    public static long doCopyByTriggerId(Object id, Map<String, Object> params, Callback callback, DynamicObject parent_execution) {
        DynamicObject trigger = DataCopyTrigger.get(D.l((Object)id));
        DynamicObject execution = DataCopyOpenApi.execution(trigger, params, callback, parent_execution);
        DataCopyTask.start(execution);
        return execution.getLong(ID);
    }

    private static DynamicObject execution(DynamicObject trigger, Map<String, Object> params, Callback callback, DynamicObject parent_execution) {
        Assert.notNull(params, (String)ResManager.loadKDString((String)"\u6267\u884c\u53c2\u6570params\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DataCopyOpenApi_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DataCopyOpenApi.checkParams(trigger, params);
        DynamicObject execution = DataCopyTask.create(trigger, params, callback, parent_execution, DataCopyTask.InitType.API_ASYN);
        if (execution == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672c\u542f\u52a8\u65b9\u6848(%s)\u6b63\u5728\u6267\u884c\uff0c\u5fc5\u987b\u7ed3\u675f\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c\uff01", (String)"DataCopyOpenApi_53", (String)"isc-iscb-platform-core", (Object[])new Object[0]), trigger.getString(NUMBER)));
        }
        return execution;
    }

    public static Long start(long trigger, Map<String, Object> data) {
        if (data.size() == 0) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a", (String)"DataCopyOpenApi_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject execution = DataCopyTask.create(trigger, data);
        DataCopyTask.start(execution);
        return (Long)execution.getPkValue();
    }

    public static Long start(long trigger, List<Map<String, Object>> list) {
        return DataCopyOpenApi.start(trigger, list, null);
    }

    public static Long start(long trigger, List<Map<String, Object>> list, DataCopyTask.InitType initType) {
        if (list.size() == 0) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a", (String)"DataCopyOpenApi_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject execution = DataCopyTask.create(trigger, list, initType);
        DataCopyTask.start(execution);
        return (Long)execution.getPkValue();
    }

    public static Map<String, Object> push(String trigger_number, List<Map<String, Object>> dataSet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
            int totalCount = DataCopyOpenApi.push(trigger, dataSet);
            result.put(TRIGGER_NUMBER, trigger_number);
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put(TOTAL_COUNT, totalCount);
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    public static Object push(String trigger_number, DynamicObject[] objects) {
        return DataCopyOpenApi.push(trigger_number, DataCopyOpenApi.getSrcDataListByTrigger(trigger_number, objects));
    }

    private static List<Map<String, Object>> getSrcDataListByTrigger(String trigger_number, DynamicObject[] objects) {
        DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
        String schema_number = trigger.getString("data_copy.number");
        return DataCopyOpenApi.getSrcDataList(schema_number, objects);
    }

    public static Map<String, Object> submit(String trigger_number, List<Map<String, Object>> dataSet, Map<String, Object> callback) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DynamicObject execution = DataCopyTask.createByNumber(trigger_number, dataSet, DataCopyOpenApi.getCallback(callback));
            DataCopyTask.start(execution);
            result.put(EXECUTION_NUMBER, execution.getString(NUMBER));
            result.put(SUCCESS_KEY, Boolean.TRUE);
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    public static Map<String, Object> submit(String trigger_number, DynamicObject[] objects, Map<String, Object> callback) {
        return DataCopyOpenApi.submit(trigger_number, DataCopyOpenApi.getSrcDataListByTrigger(trigger_number, objects), callback);
    }

    public static Map<String, Object> translate(String trigger_number, List<Map<String, Object>> dataSet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
            List<Map<String, Object>> tars = DataCopyOpenApi.translate(trigger, dataSet);
            result.put(TRIGGER_NUMBER, trigger_number);
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put(DATA, tars);
            result.put(TOTAL_COUNT, tars.size());
        }
        catch (Throwable e) {
            result.put(SUCCESS_KEY, Boolean.FALSE);
            String s = StringUtil.toString((Throwable)e);
            if (s != null && s.length() > 1000) {
                s = s.substring(0, 1000);
            }
            result.put("msg", s);
        }
        return result;
    }

    public static Map<String, Object> translate(String trigger_number, DynamicObject[] objects) {
        return DataCopyOpenApi.translate(trigger_number, DataCopyOpenApi.getSrcDataListByTrigger(trigger_number, objects));
    }

    public static int push(DynamicObject trigger, List<Map<String, Object>> dataSet) {
        ListAsReader reader = new ListAsReader(dataSet);
        DynamicObject execution = DataCopyTask.createSyncExecution(trigger, dataSet);
        return DataCopyTask.execute(execution, (ObjectReader<Map<String, Object>>)reader);
    }

    public static List<Map<String, Object>> translate(DynamicObject trigger, List<Map<String, Object>> dataSet) {
        ListAsReader reader = new ListAsReader(dataSet);
        ListAsWriter writer = new ListAsWriter();
        DataCopyRunner runner = new DataCopyRunner(trigger, (ObjectReader<? extends Map<String, Object>>)reader, (ObjectWriter<Map<String, Object>>)writer, null);
        DataCopyInput input = runner.getInput();
        Map<String, Object> src = input.read();
        while (src != null) {
            Map<String, Object> tar = runner.getMapping().translateAll(src);
            writer.write(tar);
            src = input.read();
        }
        return writer.getList();
    }

    public static DynamicObject getTrigger(String trigger_number) {
        DynamicObject trigger = DataCopyTrigger.getByNumber(trigger_number);
        if (trigger == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u542f\u52a8\u65b9\u6848\u672a\u627e\u5230\u3002", (String)"DataCopyOpenApi_54", (String)"isc-iscb-platform-core", (Object[])new Object[0]), trigger_number));
        }
        return trigger;
    }

    public static Map<String, Object> query(String trigger_number, Map<String, Object> filter_params, boolean needTranslate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
            ListAsWriter writer = new ListAsWriter();
            DataCopyRunner runner = new DataCopyRunner(trigger, null, (ObjectWriter<Map<String, Object>>)writer, filter_params);
            if (!needTranslate) {
                DataCopyOpenApi.onlyReadData(runner);
            } else {
                runner.run();
            }
            result.put(TRIGGER_NUMBER, trigger_number);
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put(DATA, writer.getList());
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    private static void onlyReadData(DataCopyRunner runner) {
        DataCopyInput input = runner.getInput();
        Map<String, Object> src = input.read();
        while (src != null) {
            runner.getOutput().write(src);
            src = input.read();
        }
    }

    public static List<Map<String, Object>> pullBySchema(String schema_number, Map<String, Object> filter, long limit, boolean ignoreError) {
        Assert.notNull((Object)schema_number, (String)DataCopyOpenApi.get_MSG_SCHEMA_NUMBER_REQUIRED());
        Assert.isTrue((limit <= 10000L ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u6700\u5927\u53d6\u6570\u884c\u6570\u4e0d\u8d85\u8fc710000\u884c", (String)"DataCopyOpenApi_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DataCopyParam param = DataCopyOpenApi.createDataCopyParam(schema_number, filter, limit, ignoreError);
        return DataCopyOpenApi.innerPullData(param, ignoreError);
    }

    private static List<Map<String, Object>> innerPullData(DataCopyParam param, boolean ignoreError) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DataCopyRunner runner = new DataCopyRunner(param, DataCopyOpenApi.createTarCollector(param, result, ignoreError), null, (ObjectWriter<Map<String, Object>>)new NullObjectWriter());
        DataCopyOpenApi.runDataCopyRunner(runner);
        return result;
    }

    public static List<Map<String, Object>> pullBySchema(DynamicObject schema, Map<String, Object> filter, long limit, boolean ignoreError) {
        Assert.isTrue((limit <= 10000L ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u6700\u5927\u53d6\u6570\u884c\u6570\u4e0d\u8d85\u8fc710000\u884c", (String)"DataCopyOpenApi_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DataCopyParam param = DataCopyOpenApi.makeDcParamForPull(schema, filter, (int)limit, ignoreError);
        return DataCopyOpenApi.innerPullData(param, ignoreError);
    }

    private static void runDataCopyRunner(DataCopyRunner runner) {
        try {
            runner.run();
        }
        catch (SignalException signalException) {
        }
        finally {
            runner.clearLastRow();
        }
    }

    private static DataCopyParam createDataCopyParam(String schema_number, Map<String, Object> filter, long limit, boolean ignoreError) {
        DynamicObject dc = DataCopySchema.getByNumber(schema_number);
        return DataCopyOpenApi.makeDcParamForPull(dc, filter, (int)limit, ignoreError);
    }

    private static DataCopyParam makeDcParamForPull(DynamicObject dc, Map<String, Object> filter, int limit, boolean ignoreError) {
        DataCopyParam param = new DataCopyParam(dc, filter);
        if (ignoreError) {
            param.setResumeOnError();
        }
        param.setMaxCount(limit);
        return param;
    }

    private static DataCopyRunner.Collector createTarCollector(final DataCopyParam param, final List<Map<String, Object>> result, final boolean ignoreError) {
        return new DataCopyRunner.Collector(){

            @Override
            public void collect(Map<String, Object> src, Map<String, Object> tar, SaveDataType action, Throwable err) {
                tar.remove("$action");
                result.add(tar);
                if (err != null) {
                    String pk = param.getSourcePrimaryKey();
                    String message = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u6570\u636e%2$s[%3$s]\u53d6\u6570\u6216\u8f6c\u6362\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a%4$s", (String)"DataCopyOpenApi_55", (String)"isc-iscb-platform-core", (Object[])new Object[0]), result.size(), pk, src.get(pk), err.getMessage());
                    tar.put(DataCopyOpenApi.ERROR_MESSAGE, message);
                    tar.putIfAbsent(DataCopyOpenApi.ERROR_STACK_TRACE, StringUtil.toString((Throwable)err));
                    if (!ignoreError) {
                        throw new SignalException(message, err);
                    }
                }
            }
        };
    }

    public static List<Map<String, Object>> transferBySchema(String schema_number, List<Map<String, Object>> list) {
        DynamicObject dc = DataCopyOpenApi.getDcSchemaByNumber(schema_number);
        return DataCopyOpenApi.transferBySchema(dc, list);
    }

    public static List<Map<String, Object>> transferBySchema(DynamicObject dc, List<Map<String, Object>> list) {
        DataCopyParam param = new DataCopyParam(dc);
        ListAsWriter writer = new ListAsWriter();
        ListAsReader reader = new ListAsReader(list);
        DataCopyRunner runner = new DataCopyRunner(param, DataCopyOpenApi.createTransformerCollector((ListAsWriter<Map<String, Object>>)writer), (ObjectReader<? extends Map<String, Object>>)reader, (ObjectWriter<Map<String, Object>>)writer);
        DataCopyOpenApi.runDataCopyRunner(runner);
        return writer.getList();
    }

    private static DynamicObject getDcSchemaByNumber(String schema_number) {
        Assert.notNull((Object)schema_number, (String)DataCopyOpenApi.get_MSG_SCHEMA_NUMBER_REQUIRED());
        return DataCopySchema.getByNumber(schema_number);
    }

    public static List<Map<String, Object>> transferBySchema(String schema_number, DynamicObject[] objects) {
        return DataCopyOpenApi.transferBySchema(schema_number, DataCopyOpenApi.getSrcDataList(schema_number, objects));
    }

    public static List<Map<String, Object>> getSrcDataList(String schema_number, DynamicObject[] objects) {
        DynamicObject dc = DataCopyOpenApi.getDcSchemaByNumber(schema_number);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(objects.length);
        Map<String, Object> requires = SQLUtil.prepareRequires(dc);
        for (DynamicObject object : objects) {
            Map<String, Object> map = DynamicObjectUtil.object2Map(object, requires);
            list.add(map);
        }
        return list;
    }

    private static DataCopyRunner.Collector createTransformerCollector(final ListAsWriter<Map<String, Object>> writer) {
        return new DataCopyRunner.Collector(){

            @Override
            public void collect(Map<String, Object> src, Map<String, Object> tar, SaveDataType action, Throwable err) {
                if (err != null) {
                    throw new HandledException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u8f93\u5165\u6570\u636eID[%2$s]\u8f6c\u6362\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38!", (String)"DataCopyOpenApi_56", (String)"isc-iscb-platform-core", (Object[])new Object[0]), writer.size() + 1, src.get(DataCopyOpenApi.ID)), err);
                }
                tar.remove("$action");
            }
        };
    }

    public static List<Map<String, Object>> pushBySchema(String schema_number, List<Map<String, Object>> list, boolean ignoreError) {
        Assert.notNull((Object)schema_number, (String)DataCopyOpenApi.get_MSG_SCHEMA_NUMBER_REQUIRED());
        DataCopyParam param = DataCopyOpenApi.createDataCopyParam(schema_number, ignoreError);
        return DataCopyOpenApi.innerPushData(param, list, ignoreError);
    }

    private static List<Map<String, Object>> innerPushData(DataCopyParam param, List<Map<String, Object>> list, boolean ignoreError) {
        ArrayList<Map<String, Object>> responses = new ArrayList<Map<String, Object>>(list.size());
        DataCopyRunner runner = new DataCopyRunner(param, DataCopyOpenApi.createResponseCollector(param, responses, ignoreError), (ObjectReader<? extends Map<String, Object>>)new ListAsReader(list), null);
        DataCopyOpenApi.runDataCopyRunner(runner);
        return responses;
    }

    public static List<Map<String, Object>> pushBySchema(String schema_number, DynamicObject[] objects, boolean ignoreError) {
        return DataCopyOpenApi.pushBySchema(schema_number, DataCopyOpenApi.getSrcDataList(schema_number, objects), ignoreError);
    }

    private static DataCopyParam createDataCopyParam(String schema_number, boolean ignoreError) {
        DynamicObject dc = DataCopySchema.getByNumber(schema_number);
        return DataCopyOpenApi.makeDcParamForPush(dc, ignoreError);
    }

    private static DataCopyParam makeDcParamForPush(DynamicObject dc, boolean ignoreError) {
        DataCopyParam param = new DataCopyParam(dc);
        if (ignoreError) {
            param.setResumeOnError();
        }
        return param;
    }

    private static DataCopyRunner.Collector createResponseCollector(final DataCopyParam param, final List<Map<String, Object>> responses, final boolean ignoreError) {
        return new DataCopyRunner.Collector(){

            @Override
            public void collect(Map<String, Object> src, Map<String, Object> tar, SaveDataType action, Throwable err) {
                LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
                DataCopyOpenApi.setResponse(param, response, tar, src);
                responses.add(response);
                if (err != null) {
                    String message = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u8f93\u5165\u6570\u636e%2$s[%3$s]\u63a8\u9001\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a%4$s", (String)"DataCopyOpenApi_57", (String)"isc-iscb-platform-core", (Object[])new Object[0]), responses.size(), param.getSourcePrimaryKey(), src.get(param.getSourcePrimaryKey()), err.getMessage());
                    response.put(DataCopyOpenApi.ERROR_MESSAGE, message);
                    response.putIfAbsent(DataCopyOpenApi.ERROR_STACK_TRACE, StringUtil.toString((Throwable)err));
                    if (!ignoreError) {
                        throw new SignalException(message, err);
                    }
                }
            }
        };
    }

    private static void setResponse(DataCopyParam param, Map<String, Object> response, Map<String, Object> tar, Map<String, Object> src) {
        response.put(param.getTargetPrimaryKey(), tar.get(param.getTargetPrimaryKey()));
        response.put("srcId", src.get(param.getSourcePrimaryKey()));
        response.put("tarId", tar.get(param.getTargetPrimaryKey()));
        response.put("type", D.s((Object)tar.get("$action")));
        String message = D.s((Object)tar.get("$error_message"));
        if (message != null) {
            response.put(ERROR_MESSAGE, message);
        }
    }

    public static List<Map<String, Object>> executeBySchema(String schema_number, Map<String, Object> filter, int limit, boolean ignoreError) {
        Assert.notNull((Object)schema_number, (String)DataCopyOpenApi.get_MSG_SCHEMA_NUMBER_REQUIRED());
        Assert.isTrue((limit <= 10000 ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u6700\u5927\u6267\u884c\u884c\u6570\u4e0d\u8d85\u8fc710000\u884c", (String)"DataCopyOpenApi_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DataCopyParam param = DataCopyOpenApi.createDataCopyParam(schema_number, filter, limit, ignoreError);
        DataCopyRunner runner = new DataCopyRunner(param, DataCopyOpenApi.createResponseCollector(param, result, ignoreError));
        DataCopyOpenApi.runDataCopyRunner(runner);
        return result;
    }

    private static void checkParams(DynamicObject trigger, Map<String, Object> params) {
        DynamicObjectCollection c = trigger.getDynamicObjectCollection("params_entryentity");
        for (DynamicObject o : c) {
            String name = o.getString("params_name");
            String dataType = o.getString("params_data_type");
            Object value = params.get(name);
            if (value == null) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e0d\u5b58\u5728\u6216\u8005\u503c\u4e3a\u7a7a\uff01", (String)"DataCopyOpenApi_58", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
            }
            if (value instanceof List || DataTypeEqualsUtil.isMatchType(D.s((Object)value), dataType)) continue;
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53c2\u6570%s\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"DataCopyOpenApi_59", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
        }
    }

    public static Map<String, Object> getExecutionState(String execution_number) {
        DynamicObject exe = BusinessDataServiceHelper.loadSingle((String)ENTITY_ISC_DATA_COPY_EXECUTION, (String)"number,state,total_count,success_count,failed_count,ignored_count", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)execution_number)});
        if (exe != null) {
            return DataCopyOpenApi.getExecutionInfo(exe);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(EXECUTION_NUMBER, execution_number);
        result.put(REMARK, String.format(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u6267\u884c\u7ed3\u679c\u7f16\u7801\u4e3a[%s]\u7684\u8bb0\u5f55\uff01", (String)"DataCopyOpenApi_60", (String)"isc-iscb-platform-core", (Object[])new Object[0]), execution_number));
        return result;
    }

    public static Map<String, Object> getExecutionState(long executionId) {
        DynamicObject exe = BusinessDataServiceHelper.loadSingle((Object)executionId, (String)ENTITY_ISC_DATA_COPY_EXECUTION, (String)"number,state,total_count,success_count,failed_count,ignored_count");
        return DataCopyOpenApi.getExecutionInfo(exe);
    }

    private static Map<String, Object> getExecutionInfo(DynamicObject exe) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        try {
            map.put(ID, exe.getPkValue());
            map.put(EXECUTION_NUMBER, exe.get(NUMBER));
            map.put(STATE, exe.getString(STATE));
            map.put(TOTAL_COUNT, exe.getString(TOTAL_COUNT));
            map.put(SUCCESS_COUNT, exe.getString(SUCCESS_COUNT));
            map.put(FAILED_COUNT, exe.getString(FAILED_COUNT));
            map.put(IGNORED_COUNT, exe.getString(IGNORED_COUNT));
            map.put(REMARK, null);
        }
        catch (Throwable e) {
            String s = StringUtil.toString((Throwable)e);
            if (s != null && s.length() > 1000) {
                s = s.substring(0, 1000);
            }
            map.put(REMARK, s);
        }
        return map;
    }

    private static Object getPKByNumber(String entity, String number) {
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject object = QueryServiceHelper.queryOne((String)entity, (String)ID, (QFilter[])new QFilter[]{qFilter});
        if (object == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[%1$s]\u6839\u636e\u7f16\u7801%2$s\u672a\u627e\u5230\u8bb0\u5f55\uff01", (String)"DataCopyOpenApi_61", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, number));
        }
        return object.get(ID);
    }

    public static List<Map<String, Object>> doCopyBatch(List<Map<String, Object>> triggers) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(triggers.size());
        int i = 0;
        for (Map<String, Object> trigger : triggers) {
            Map<String, Object> result = new HashMap<String, Object>();
            if (trigger.get(TRIGGER_NUMBER) == null || !trigger.containsKey(PARAMS)) {
                result.put(SUCCESS_KEY, Boolean.FALSE);
                result.put("msg", String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u65b9\u6848\u672a\u63d0\u4f9b\u542f\u52a8\u65b9\u6848\u7f16\u7801\u6216\u53c2\u6570\u5b57\u6bb5\uff0c\u6216\u65b9\u6848\u7f16\u7801\u5b57\u6bb5\u503c\u4e3anull", (String)"DataCopyOpenApi_62", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ++i));
            } else {
                result = DataCopyOpenApi.doCopy(trigger.get(TRIGGER_NUMBER).toString(), (Map)trigger.get(PARAMS), (Map)trigger.get("callback"));
            }
            resultList.add(result);
        }
        return resultList;
    }

    public static Map<String, Object> doCopyBatchCallBackOnce(List<Map<String, Object>> triggers, Map<String, Object> callbackMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            int i = 0;
            HashMap<String, Object> number_params_map = new HashMap<String, Object>(triggers.size());
            for (Map<String, Object> trigger : triggers) {
                if (trigger.get(TRIGGER_NUMBER) == null || !trigger.containsKey(PARAMS)) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u65b9\u6848\u672a\u63d0\u4f9b\u542f\u52a8\u65b9\u6848\u7f16\u7801\u6216\u53c2\u6570\u5b57\u6bb5\uff0c\u6216\u65b9\u6848\u7f16\u7801\u5b57\u6bb5\u503c\u4e3anull", (String)"DataCopyOpenApi_62", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ++i));
                }
                number_params_map.put(trigger.get(TRIGGER_NUMBER).toString(), trigger.get(PARAMS));
            }
            Callback callbackInst = DataCopyOpenApi.getCallback(callbackMap);
            String execution_number = DataCopyOpenApi.generateParentExecutionAndCopy(number_params_map, callbackInst);
            result.put("parent_execution_number", execution_number);
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put("msg", ResManager.loadKDString((String)"\u63d0\u4ea4\u4efb\u52a1\u6210\u529f\uff01", (String)"DataCopyOpenApi_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    private static String generateParentExecutionAndCopy(Map<String, Object> number_params_map, Callback callbackInst) {
        ArrayList<String> numberList = new ArrayList<String>(number_params_map.keySet());
        QFilter numberFilter = new QFilter(NUMBER, "in", numberList);
        DynamicObjectCollection triggerCollection = QueryServiceHelper.query((String)ENTITY_ISC_DATA_COPY_TRIGGER, (String)"id,number", (QFilter[])new QFilter[]{numberFilter});
        if (numberList.size() != triggerCollection.size()) {
            for (DynamicObject trigger : triggerCollection) {
                String number = trigger.getString(NUMBER);
                numberList.remove(number);
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%s\u5bf9\u5e94\u7684\u65b9\u6848", (String)"DataCopyOpenApi_63", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s(numberList)));
        }
        DynamicObject parentExecution = DataCopyTask.createParentExecution();
        for (DynamicObject trigger : triggerCollection) {
            String number = trigger.getString(NUMBER);
            DataCopyOpenApi.doCopyByTrigger(DataCopyTrigger.getByNumber(number), (Map)number_params_map.get(number), callbackInst, parentExecution);
        }
        return parentExecution.getString(NUMBER);
    }

    public static Map<String, Object> queryExecutionLogs(String executionId, int limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        QFilter filter = new QFilter("data_copy_execution", "=", (Object)D.l((Object)executionId));
        try {
            Assert.notNull((Object)executionId, (String)ResManager.loadKDString((String)"\u6267\u884cid\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DataCopyOpenApi_32", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            List pks = QueryServiceHelper.queryPrimaryKeys((String)ENTITY_ISC_DATA_COPY_EXEC_LOG, (QFilter[])new QFilter[]{filter}, (String)"modify_time desc", (int)(limit <= 0 ? 1 : Math.min(limit, 100)));
            if (pks.isEmpty()) {
                result.put(SUCCESS_KEY, Boolean.TRUE);
                result.put(DATA, Collections.emptyList());
                return result;
            }
            DynamicObject[] logs = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_ISC_DATA_COPY_EXEC_LOG));
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(logs.length);
            for (DynamicObject log : logs) {
                list.add(DynamicObjectUtil.object2Map(log));
            }
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put(DATA, list);
        }
        catch (Exception e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    public static Map<String, Object> retryLog(String logId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Assert.notNull((Object)logId, (String)ResManager.loadKDString((String)"\u65e5\u5fd7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DataCopyOpenApi_33", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            ExecutionLogRetry.execute(logId);
            DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)logId, (String)ENTITY_ISC_DATA_COPY_EXEC_LOG);
            result.put(DATA, DynamicObjectUtil.object2Map(log));
            result.put(SUCCESS_KEY, Boolean.TRUE);
            return result;
        }
        catch (Exception e) {
            DataCopyOpenApi.setError(result, e);
            return result;
        }
    }

    public static Map<String, Object> findLastLog(String cn_number, String table_name, String oid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);){
            String sql = "select fid from t_isc_database_link where fnumber=?";
            Object system = DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(cn_number), Collections.singletonList(12));
            String vid = DataCopyOidLog.generateVirtualOID(D.l((Object)system), table_name, oid);
            sql = "SELECT TOP 1 fid,flog_id,ftask,ftrigger,fschema,fstatus FROM t_iscb_bill_log_relation WHERE fvid=? and ftable_name=? and fsystem=? and foid = ? ORDER BY ftime desc";
            List<Object> params = Arrays.asList(vid, table_name.toUpperCase(), system, oid);
            List<Integer> types = Arrays.asList(12, 12, -5, 12);
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, params, types);
            result.put("vid", vid);
            result.put("system", system);
            result.put("table_name", table_name.toUpperCase());
            result.put("oid", oid);
            if (row != null) {
                result.put("oid_log_id", row.get((Object)"fid"));
                result.put("data_log_id", row.get((Object)"flog_id"));
                result.put("task_id", D.l((Object)row.get((Object)"ftask")));
                result.put("trigger", D.l((Object)row.get((Object)"ftrigger")));
                result.put("schema", row.get((Object)"fschema"));
                result.put("status", D.i((Object)row.get((Object)"fstatus")));
            }
            result.put(SUCCESS_KEY, Boolean.TRUE);
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> findMappingValue(String ruleNumber, String value, int extendType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConnectionManager.pushResLicense(true);
        try {
            DynamicObject cfg = ValueConversionRuleConfig.getByNumber(ruleNumber);
            Object o = MapDataUtil.findMappingValue(value, cfg);
            if (o != null && extendType > 0) {
                DataCopyOpenApi.loadExtendInfo(extendType, result, cfg);
            }
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put(DATA, o);
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        finally {
            ConnectionManager.popResLicense();
        }
        return result;
    }

    private static void loadExtendInfo(int extendType, Map<String, Object> result, DynamicObject cfg) {
        for (ExtendType type : ExtendType.values()) {
            if ((type.getValue() & extendType) == 0) continue;
            result.put(type.name(), type.getDynamicObj(cfg));
        }
    }

    public static Object innerFindMappingValue(String ruleNumber, String value) {
        Object id = DataCopyOpenApi.getPKByNumber(ENTITY_ISC_VALUE_CONVER_RULE, ruleNumber);
        return MapDataUtil.findMappingValue((Long)id, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> callExtendService(Map<String, Object> response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject execution = DataCopyOpenApi.getExecution(response);
        Callback callback = DataCopyTask.getCallback(execution);
        assert (callback != null);
        if (callback.getParam1() != null) {
            Map<String, Object> invokeReq = DataCopyOpenApi.initInvokeReq(response, execution, callback);
            DynamicObject dataSource = DataCopyOpenApi.getDBLink(execution, callback.getParam3());
            ConnectionWrapper connection = null;
            try {
                connection = ConnectionManager.getConnection(dataSource.getLong(DBLINK_ID));
                connection.getFactory().invokeCallbackHandler(connection, callback.getParam1(), invokeReq);
            }
            catch (Throwable throwable) {
                ConnectorUtil.close(connection);
                throw throwable;
            }
            ConnectorUtil.close(connection);
        }
        result.put(SUCCESS_KEY, Boolean.TRUE);
        return result;
    }

    private static DynamicObject getExecution(Map<String, Object> response) {
        Object data = response.get(DATA);
        if (data == null) {
            throw new IscBizException(ResManager.loadKDString((String)"response\u4e2d\u7684data\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCopyOpenApi_34", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!(data instanceof DynamicObject)) {
            throw new IscBizException(ResManager.loadKDString((String)"response\u4e2d\u7684data\u53c2\u6570\u683c\u5f0f\u6709\u8bef,\u5e94\u4e3a\u6267\u884c\u7ed3\u679cDynamicObject", (String)"DataCopyOpenApi_35", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject execution = (DynamicObject)data;
        if (!ENTITY_ISC_DATA_COPY_EXECUTION.equals(execution.getDataEntityType().toString())) {
            throw new IscBizException(ResManager.loadKDString((String)"response\u4e2d\u7684data\u53c2\u6570\u7684DynamicObject\u7c7b\u578b\u6709\u8bef,\u5e94\u4e3aisc_data_copy_execution", (String)"DataCopyOpenApi_36", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return execution;
    }

    private static Map<String, Object> initInvokeReq(Map<String, Object> response, DynamicObject execution, Callback callback) {
        HashMap<String, Object> invokeReq = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        invokeReq.put(SUCCESS_KEY, response.get(SUCCESS_KEY));
        invokeReq.put("msg", response.get("msg"));
        invokeReq.put(DATA, data);
        data.put(TRIGGER_NUMBER, execution.getDynamicObject("data_copy_trigger").getString(NUMBER));
        data.put(EXECUTION_NUMBER, execution.getString(NUMBER));
        data.put("data_copy_number", execution.getDynamicObject("data_copy_schama").getString(NUMBER));
        DataCopyOpenApi.handleParam2(execution, callback, data);
        return invokeReq;
    }

    private static void handleParam2(DynamicObject execution, Callback callback, Map<String, Object> data) {
        String param2 = callback.getParam2();
        if (StringUtils.isNumeric((String)param2)) {
            int appendType = D.i((Object)param2);
            for (CallbackAppendType type : CallbackAppendType.values()) {
                if ((type.getValue() & appendType) == 0) continue;
                data.put(type.name(), type.initAppendInfo(execution));
            }
        } else {
            data.put("param2", param2);
        }
    }

    private static DynamicObject getDBLink(DynamicObject execution, String connName) {
        long dataCopySchemaId = execution.getLong("data_copy_schama_id");
        if ("$src".equals(connName)) {
            DynamicObject dataCopySchema = DataCopySchema.get(dataCopySchemaId);
            return DataSource.get(dataCopySchema.getLong("data_source_id")).getConfig();
        }
        DynamicObject dataCopySchema = DataCopySchema.get(dataCopySchemaId);
        return DataSource.get(dataCopySchema.getLong("data_target_id")).getConfig();
    }

    public static Map<String, Object> syncExecute(String trigger_number, Map<String, Object> filter_params) {
        return DataCopyOpenApi.syncExecuteX(trigger_number, filter_params, null, null);
    }

    public static Map<String, Object> syncExecuteX(String trigger_number, Map<String, Object> filter_params, String realDataSourceNumber, String realDataTargetNumber) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
            DynamicObject execution = DataCopyTask.createSyncExecutionX(trigger, null, filter_params, realDataSourceNumber, realDataTargetNumber);
            int count = DataCopyTask.execute(execution, null, filter_params);
            DataCopyOpenApi.getSynExeResult(trigger_number, result, execution, count);
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    private static void getSynExeResult(String trigger_number, Map<String, Object> result, DynamicObject execution, int count) {
        result.put(TRIGGER_NUMBER, trigger_number);
        result.put(EXECUTION_ID, execution.get(ID));
        result.put(EXECUTION_NUMBER, execution.get(NUMBER));
        result.put(EXECUTION_STATE, execution.get(STATE));
        result.put(SUCCESS_KEY, Boolean.TRUE);
        result.put(TOTAL_COUNT, count);
    }

    public static Map<String, Object> syncExecuteByPushData(String trigger_number, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
            DynamicObject execution = DataCopyTask.createSyncExecution(trigger, data, null);
            int count = DataCopyTask.execute(execution, null, null);
            DataCopyOpenApi.getSynExeResult(trigger_number, result, execution, count);
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    public static DynamicObject getConnInfoByTriggerNumber(String trigger_number, boolean isSrc) {
        DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
        long dataCopyId = trigger.getLong("data_copy_id");
        DynamicObject dataCopySchema = DataCopySchema.get(dataCopyId);
        DynamicObject dataSource = isSrc ? DataSource.get(dataCopySchema.getLong("data_source_id")).getConfig() : DataSource.get(dataCopySchema.getLong("data_target_id")).getConfig();
        return ConnectionConfig.getConfig(dataSource.getLong(DBLINK_ID));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object callService(String cn_number, String service, Map<String, Object> params, String proxy_user) {
        DynamicObject database_link = ConnectionConfig.getByNumber(cn_number);
        if (database_link == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u7f16\u7801[%s]\u4e0d\u5b58\u5728", (String)"DataCopyOpenApi_64", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cn_number));
        }
        try (ConnectionWrapper cn = ConnectionManager.getConnection(database_link.getLong(ID));){
            Object object = cn.getFactory().callService(cn, service, params, proxy_user);
            return object;
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    public static Map<String, Object> testConnection(String number) {
        try {
            if (StringUtil.isEmpty((String)D.s((Object)number))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u5bf9\u8c61\u7f16\u7801number\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCopyOpenApi_39", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            DynamicObject dbLink = DataCopyOpenApi.getDatabaseLinkByNum(number);
            ConnectionManager.test(D.l((Object)dbLink.get(ID)));
        }
        catch (Exception e) {
            return DataCopyOpenApi.failResult(e);
        }
        return DataCopyOpenApi.successResult(Boolean.TRUE);
    }

    private static Map<String, Object> successResult(Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(SUCCESS_KEY, Boolean.TRUE);
        result.put("errorCode", SUCCESS_KEY);
        result.put(DATA, data);
        return result;
    }

    private static Map<String, Object> failResult(Throwable e) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(SUCCESS_KEY, Boolean.FALSE);
        result.put("errorCode", "fail");
        result.put("message", StringUtil.toString((Throwable)e));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> deployConnection(Map<String, Object> request) {
        try {
            String number = D.s((Object)request.get(NUMBER));
            Assert.hasText((String)number, (String)ResManager.loadKDString((String)"\u8fde\u63a5\u5bf9\u8c61\u7f16\u7801: number\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCopyOpenApi_40", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            String ierpUrl = D.s((Object)request.get("ierpUrl"));
            Assert.hasText((String)ierpUrl, (String)ResManager.loadKDString((String)"\u672c\u7cfb\u7edfURL: ierpUrl\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCopyOpenApi_41", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            String pWord = D.s((Object)request.get("password"));
            Assert.hasText((String)pWord, (String)ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5bc6\u7801: password\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCopyOpenApi_42", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            String permissionMode = D.s((Object)request.get("permissionMode"));
            Assert.hasText((String)permissionMode, (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6388\u6743\u6a21\u5f0f: permissionMode\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCopyOpenApi_43", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            PermissionMode mode = PermissionMode.getType((String)permissionMode);
            Assert.notNull((Object)mode, (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6388\u6743\u6a21\u5f0f\u4e0d\u5b58\u5728", (String)"DataCopyOpenApi_44", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            DynamicObject dbLink = DataCopyOpenApi.getDatabaseLinkByNum(number);
            ConnectionManager.pushResLicense(true);
            try (ConnectionWrapper cn = ConnectionManager.getConnection(D.l((Object)dbLink.get(ID)));){
                if (!cn.getFactory().supportsRemoteDeploy()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8fdc\u7a0b\u90e8\u7f72\uff01", (String)"DataCopyOpenApi_45", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                }
                cn.getFactory().deploy(cn, ierpUrl, pWord, mode);
            }
            finally {
                ConnectionManager.popResLicense();
            }
        }
        catch (Exception e) {
            return DataCopyOpenApi.failResult(e);
        }
        return DataCopyOpenApi.successResult(Boolean.TRUE);
    }

    public static Map<String, Object> redoExecution(long id) {
        try {
            DynamicObject execution = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_DATA_COPY_EXECUTION);
            Assert.notNull((Object)execution, (String)ResManager.loadKDString((String)"\u8981\u91cd\u505a\u7684\u6570\u636e\u4e0d\u5b58\u5728", (String)"DataCopyOpenApi_46", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            Assert.isTrue((!DataCopyOpenApi.isTriggerRunning(execution.getLong("data_copy_trigger_id")) ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6709\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5.", (String)"DataCopyOpenApi_47", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            execution.set(STATE, (Object)"C");
            execution.set(TOTAL_COUNT, (Object)-1);
            execution.set(SUCCESS_COUNT, (Object)-1);
            execution.set(FAILED_COUNT, (Object)-1);
            execution.set("execute_count", (Object)(execution.getLong("execute_count") + 1L));
            OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_ISC_DATA_COPY_EXECUTION, (DynamicObject[])new DynamicObject[]{execution}, (OperateOption)OperateOption.create());
            DataCopyTask.start(execution, false);
        }
        catch (Exception e) {
            return DataCopyOpenApi.failResult(e);
        }
        return DataCopyOpenApi.successResult(Boolean.TRUE);
    }

    public static Map<String, Object> cancelExecution(long id) {
        try {
            SignalManager.sendCancelSignal(String.valueOf(id));
        }
        catch (Exception e) {
            return DataCopyOpenApi.failResult(e);
        }
        return DataCopyOpenApi.successResult(Boolean.TRUE);
    }

    private static boolean isTriggerRunning(long triggerId) {
        QFilter qFilter = new QFilter("data_copy_trigger_id", "=", (Object)triggerId).and(STATE, "in", (Object)new String[]{"C", "R"});
        DynamicObject[] executions = BusinessDataServiceHelper.load((String)ENTITY_ISC_DATA_COPY_EXECUTION, (String)"state, source_data", (QFilter[])new QFilter[]{qFilter});
        int count = 0;
        for (DynamicObject e : executions) {
            if (D.s((Object)e.get("source_data")) != null) continue;
            ++count;
        }
        return count > 0;
    }

    private static DynamicObject getDatabaseLinkByNum(String dbLinkNumber) {
        DynamicObject dbLink = ConnectionConfig.getByNumber(dbLinkNumber);
        if (dbLink == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"DataCopyOpenApi_48", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return dbLink;
    }

    /*
     * Loose catch block
     */
    public static Object executeQuerySQL(String cn_number, String sql, List<Object> values, List<Integer> types, long limit) {
        Assert.isTrue((limit > 0L && limit <= 1000L ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u884c\u6570\u5fc5\u987b\u5927\u4e8e0\u4e14\u4e0d\u8d85\u8fc71000", (String)"DataCopyOpenApi_49", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Assert.isTrue((sql != null && (sql.startsWith("select") || sql.startsWith("SELECT")) ? 1 : 0) != 0, (String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684SQL:%s", (String)"DataCopyOpenApi_65", (String)"isc-iscb-platform-core", (Object[])new Object[0]), sql));
        DynamicObject database = QueryServiceHelper.queryOne((String)"isc_database_link", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)cn_number)});
        ObjectReader<DataRow> reader = null;
        try {
            try (ConnectionWrapper cn = ConnectionManager.getConnection(database.getLong(ID));){
                reader = cn.executeQuery(sql, values == null ? Collections.emptyList() : values, types == null ? Collections.emptyList() : types);
                ArrayList<Map> list = new ArrayList<Map>();
                DataRow item = (DataRow)reader.read();
                while (item != null && (long)list.size() < limit) {
                    list.add(item.toMap());
                    item = (DataRow)reader.read();
                }
                ArrayList<Map> arrayList = list;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            DbUtil.close(reader);
        }
    }

    public static Object syncMetaData(String dsNumber, String metaType, String fullName) {
        Assert.isTrue((dsNumber != null && metaType != null && fullName != null ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u5b58\u5728\u8c03\u7528\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (String)"DataCopyOpenApi_51", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        DynamicObject ds = DataSource.get(dsNumber).getConfig();
        Object id = null;
        HashMap<String, MetaType> metas = new HashMap<String, MetaType>(2);
        metas.put(fullName, MetaType.valueOf((String)metaType));
        for (Map.Entry<String, MetaType> entry : metas.entrySet()) {
            id = MetaSchemaUtil.syncMetaBasic(ds, entry);
        }
        MetaSchemaUtil.syncMetaSchema(id);
        return id;
    }

    public static Map<String, Object> executeX(String trigger_number, Map<String, Object> params, List<Map<String, Object>> data, String realDataSource, String realDataTarget) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            params = params == null ? new HashMap<String, Object>() : params;
            DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
            DynamicObject execution = DataCopyTask.create(trigger, params, null, null, data, DataCopyTask.InitType.API_ASYN, realDataSource, realDataTarget);
            DataCopyTask.start(execution);
            result.put(TRIGGER_NUMBER, trigger_number);
            result.put(EXECUTION_NUMBER, execution.getString(NUMBER));
            result.put(SUCCESS_KEY, Boolean.TRUE);
            result.put("msg", ResManager.loadKDString((String)"\u63d0\u4ea4\u4efb\u52a1\u6210\u529f\uff01", (String)"DataCopyOpenApi_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            DataCopyOpenApi.setError(result, e);
        }
        return result;
    }

    public static Object pushBySchema(DynamicObject schema, List<Map<String, Object>> list, boolean ignoreError) {
        DataCopyParam dataCopyParam = DataCopyOpenApi.makeDcParamForPush(schema, ignoreError);
        return DataCopyOpenApi.innerPushData(dataCopyParam, list, ignoreError);
    }

    private static class SignalException
    extends HandledException {
        private static final long serialVersionUID = -7787272655897070441L;

        public SignalException(String message, Throwable e) {
            super(message, e);
        }
    }
}

