/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.connector.ischub.job.EventLogCleaner;
import kd.isc.iscb.platform.core.dc.DataBaseLinkStateMonitor;
import kd.isc.iscb.platform.core.dc.DataCopyEnv;
import kd.isc.iscb.platform.core.dc.DataCopyJob;
import kd.isc.iscb.platform.core.dc.DataCopyOpenApi;
import kd.isc.iscb.platform.core.dc.DataCopyTaskMonitor;
import kd.isc.iscb.platform.core.dc.DataCopyTaskStage;
import kd.isc.iscb.platform.core.dc.DataCopyTaskState;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.dc.ServiceFlowProcessInstMonitor;
import kd.isc.iscb.platform.core.dc.e.BizBatchException;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyEvent;
import kd.isc.iscb.platform.core.dc.e.DataCopyMapping;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.DataCopyRunner;
import kd.isc.iscb.platform.core.dc.e.v.Evaluator;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.platform.core.dc.e.v.PropertyAssembler;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.job.CheckIfSystemIsBusy;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobNotifier;
import kd.isc.iscb.platform.core.params.Callback;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.task.TimerTask;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.platform.core.util.MessageSender;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceManager;
import kd.isc.iscb.util.trace.TraceTask;

public class DataCopyTask
extends AbstractTask {
    private static final String TARGET_ACTION = "$action";
    private static final String ENTITY_ISC_DATA_COPY_EXEC_LOG = "isc_data_copy_exec_log";
    private static final String TARGET_DATA_TAG = "target_data_tag";
    private static final String SOURCE_DATA_TAG = "source_data_tag";
    private static final String TARGET_DATA = "target_data";
    private static final String SOURCE_DATA = "source_data";
    private static final String MODIFY_TIME = "modify_time";
    private static final String SERVER_ID = "server_id";
    private static final String MESSAGE_TAG = "message_tag";
    private static final String MESSAGE = "message";
    private static final String STATE = "state";
    private static final String ACTION = "$action";
    private static final int MAX_LENGTH = 290;
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final String DATA_COPY_TRIGGER_ID = "data_copy_trigger_id";
    private static Log logger = LogFactory.getLog(DataCopyTask.class);
    private static SecureRandom rnd = new SecureRandom();

    public void execute(final RequestContext ctx, Map<String, Object> params) throws KDException {
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        final DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)params.get("trigger"), (String)"isc_data_copy_trigger");
        TraceStack.trace(Caller.Timer, new TraceTask(){

            public void run() {
                DynamicObject execution = DataCopyTask.this.createByLock(ctx, trigger);
                if (execution != null) {
                    DataCopyTask.start(execution);
                } else {
                    DynamicObject ignoredExe = DataCopyTask.this.saveOmitExecution(trigger);
                    DataCopyTask.saveOmitLog(trigger, ignoredExe);
                }
            }
        });
    }

    private DynamicObject saveOmitExecution(DynamicObject trigger) {
        DynamicObject exe = BusinessDataServiceHelper.newDynamicObject((String)ISC_DATA_COPY_EXECUTION);
        long id = IDService.get().genLongId();
        String number = DataCopyTask.generateExecutionNumber(trigger);
        exe.set("id", (Object)id);
        exe.set("number", (Object)number);
        String name = "[" + (Object)((Object)InitType.TIMER) + "]" + D.s((Object)trigger.get("name"));
        if (name.length() > 50) {
            name = name.substring(0, 48) + "..";
        }
        exe.set("name", (Object)name);
        exe.set("data_copy_trigger", (Object)trigger);
        exe.set("data_copy_schama", trigger.get("data_copy"));
        exe.set("status", (Object)"C");
        exe.set("host", (Object)TaskManager.getInstanceId());
        exe.set(STATE, (Object)"I");
        exe.set("execute_count", (Object)0);
        exe.set("enable", (Object)"1");
        exe.set("total_count", (Object)-1);
        exe.set("success_count", (Object)-1);
        exe.set("failed_count", (Object)-1);
        exe.set("ignored_count", (Object)-1);
        exe.set("creator", (Object)RequestContext.get().getUserId());
        exe.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        exe.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        exe.set("params_entryentity", (Object)DataCopyTask.initParams(trigger, exe));
        String callback_info = D.s((Object)trigger.get("callback_info"));
        exe.set("callback_info", (Object)callback_info);
        exe.set("type", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exe});
        return exe;
    }

    private static DynamicObjectCollection initParams(DynamicObject trigger, DynamicObject exe) {
        DynamicObjectCollection exeParamsEntries = exe.getDynamicObjectCollection("params_entryentity");
        DynamicObjectCollection triggerParamsEntries = trigger.getDynamicObjectCollection("params_entryentity");
        exeParamsEntries.clear();
        DataCopyParam param = new DataCopyParam(exe);
        for (DynamicObject t : triggerParamsEntries) {
            DynamicObject rowObj = exeParamsEntries.addNew();
            String name = t.getString("params_name");
            rowObj.set("params_name", (Object)name);
            rowObj.set("params_label", (Object)t.getString("params_label"));
            rowObj.set("params_data_type", (Object)t.getString("params_data_type"));
            rowObj.set("params_value", ExprEvaluator.calc(t.get("params_value"), param, null, null));
        }
        return exeParamsEntries;
    }

    private DynamicObject createByLock(RequestContext ctx, DynamicObject trigger) {
        DynamicObject execution = null;
        String key = "/isc/iscb/data_copy/" + ctx.getAccountId() + "/" + trigger.getPkValue();
        try (DLock lock = DLock.create((String)key).fastMode();){
            lock.lock();
            execution = DataCopyTask.create(trigger, null, InitType.TIMER);
        }
        return execution;
    }

    private static void saveOmitLog(DynamicObject trigger, DynamicObject ignoredExe) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_DATA_COPY_EXEC_LOG);
        log.set("data_copy_trigger", trigger.getPkValue());
        log.set("data_copy_schema", trigger.get("data_copy"));
        log.set("data_copy_execution", ignoredExe.getPkValue());
        log.set(SERVER_ID, (Object)NetUtil.getServerId());
        log.set("created_time", (Object)new Date());
        log.set(STATE, (Object)"N");
        log.set(MESSAGE, (Object)ResManager.loadKDString((String)"\u7531\u4e8e\u5f53\u524d\u542f\u52a8\u65b9\u6848\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u6267\u884c\u7ed3\u679c\uff0c\u672c\u6b21\u6267\u884c\u8ba1\u5212\u5df2\u5ffd\u7565\u3002", (String)"DataCopyTask_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static DynamicObject saveErrorLog(DataCopyParam param, Throwable error, Map<String, Object> src, Map<String, Object> tar) {
        String action;
        String string = action = tar == null ? null : D.s((Object)tar.get("$action"));
        if (error instanceof BizBatchException) {
            return null;
        }
        if (error instanceof HandledException) {
            return null;
        }
        if (error == null && tar != null && action == null) {
            return null;
        }
        if (param.getExecution() == null) {
            if (error != null) {
                String s = StringUtil.toString((Throwable)error);
                LinkedHashMap<Object, Object> des = new LinkedHashMap<Object, Object>();
                Pair<String, String> p = param.getTaskNumber();
                des.put(p.getKey(), p.getValue());
                des.put("server", NetUtil.getServerId());
                des.put("stacktrace", s);
                logger.warn(Json.toString(des));
            }
            return null;
        }
        String s = null;
        try {
            s = tar != null && error == null ? (tar.containsKey("$error_message") ? D.s((Object)tar.remove("$error_message")) : (tar.get("$reason") != null ? action + "\uff1a" + DataCopyTask.getIdentity(param, src, tar, true) + " -> " + tar.get("$reason") : action + "\uff1a" + DataCopyTask.getIdentity(param, src, tar, true) + " -> " + DataCopyTask.getIdentity(param, src, tar, false))) : StringUtil.toString((Throwable)error);
            String judgeFieldsValue = DataCopyTask.getJudgeFieldsValue1(param, src, tar, true);
            String state = DataCopyTask.getLogState(error, action);
            return DataCopyTask.saveErrorLog(param, src, tar, s, judgeFieldsValue, state);
        }
        catch (Throwable e) {
            logger.warn("DataCopyTask.saveErrorLog", e);
            LinkedHashMap<String, Object> des = new LinkedHashMap<String, Object>();
            des.put("id", param.getExecution().getPkValue());
            des.put("number", param.getExecution().get("number"));
            des.put("server", NetUtil.getServerId());
            des.put("stacktrace", s);
            logger.warn(Json.toString(des));
            return null;
        }
    }

    private static String getLogState(Throwable error, String action) {
        String state = error != null || SaveDataType.FAILED.name().equals(action) ? "F" : (SaveDataType.NOP.name().equals(action) ? "N" : "S");
        return state;
    }

    public static DynamicObject saveErrorLog(DataCopyParam param, Object src, Object tar, String message, String judgeFieldsValue, String state) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_DATA_COPY_EXEC_LOG);
        log.set("id", (Object)IDService.get().genLongId());
        log.set("data_copy_execution", (Object)param.getExecution());
        log.set("data_copy_trigger", param.getExecution().get("data_copy_trigger"));
        log.set("data_copy_schema", param.getExecution().get("data_copy_schama"));
        log.set(SERVER_ID, (Object)NetUtil.getServerId());
        log.set("judgefields", (Object)DataCopyTask.trim(judgeFieldsValue));
        Timestamp now = new Timestamp(System.currentTimeMillis());
        log.set("created_time", (Object)now);
        log.set(MODIFY_TIME, (Object)now);
        log.set(MESSAGE, (Object)DataCopyTask.trim(message));
        log.set(MESSAGE_TAG, message != null && message.length() > 290 ? message : null);
        log.set(STATE, (Object)state);
        DataCopyTask.writeDataToLog(src, log, SOURCE_DATA, SOURCE_DATA_TAG);
        DataCopyTask.writeDataToLog(tar, log, TARGET_DATA, TARGET_DATA_TAG);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        return log;
    }

    private static Object getIdentity(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar, boolean isSrc) {
        Object id = null;
        if (isSrc) {
            id = src.get(param.getSourcePrimaryKey());
            if (id == null) {
                id = src.get("$id");
            }
        } else {
            id = tar.get(param.getTargetPrimaryKey());
            if (id == null) {
                id = tar.get("$id");
            }
        }
        return id != null ? id : DataCopyTask.getJudgeFieldsValue1(param, src, tar, isSrc);
    }

    private static String getJudgeFieldsValue1(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar, boolean isSrc) {
        try {
            Map<String, Object> data;
            StringBuilder sb = new StringBuilder();
            List<String> judgeFields = isSrc ? param.getSourceJudgeFields() : param.getTargetJudgeFields().get("$");
            Map<String, Object> map = data = isSrc ? src : tar;
            if (data != null && judgeFields != null) {
                if (!isSrc) {
                    return DataCopyTask.getSrcJudgeFieldsValue(data, judgeFields);
                }
                StringBuilder value = DataCopyTask.evalJudgeValues(param, src);
                sb.append((CharSequence)value);
                if (sb.length() > 255) {
                    return sb.substring(0, 255);
                }
            }
            return D.s((Object)sb);
        }
        catch (Throwable e) {
            return StringUtil.getCascadeMessage((Throwable)e);
        }
    }

    private static StringBuilder evalJudgeValues(DataCopyParam param, Map<String, Object> src) {
        StringBuilder sb = new StringBuilder();
        try {
            DataCopyTask.innerEvalJudgeValues(param, src, sb);
        }
        catch (Exception e) {
            logger.warn("\u6e90\u5355\u53d6\u503c\u5931\u8d25\uff0c\u96c6\u6210\u65b9\u6848\uff1a" + param.getSchemaNumber(), (Throwable)e);
        }
        return sb;
    }

    private static void innerEvalJudgeValues(DataCopyParam param, Map<String, Object> src, StringBuilder sb) {
        DataCopyMapping mapping = new DataCopyMapping(param);
        List<Pair<PropertyAssembler, Evaluator>> evaluators = mapping.getJudgeFieldsEvaluators();
        for (int i = 0; i < evaluators.size(); ++i) {
            if (i > 0) {
                sb.append('|');
            }
            Pair<PropertyAssembler, Evaluator> p = evaluators.get(i);
            PropertyAssembler a = (PropertyAssembler)p.getA();
            try {
                Evaluator e = (Evaluator)p.getB();
                Object value = e.eval(param, src, a);
                if (value instanceof Object[]) {
                    sb.append(DataCopyTask.trimArray((Object[])value));
                    continue;
                }
                sb.append(value);
                continue;
            }
            catch (Exception e) {
                logger.warn("\u6e90\u5355\u53d6\u503c\u5931\u8d25\uff0c\u96c6\u6210\u65b9\u6848\uff1a" + param.getSchemaNumber() + "\uff0c\u5b57\u6bb5\uff1a" + a.getProperty(), (Throwable)e);
            }
        }
    }

    private static String trimArray(Object[] values) {
        if (values.length > 10) {
            Object[] items = new Object[10];
            System.arraycopy(values, 0, items, 0, 10);
            return Arrays.toString(items);
        }
        return Arrays.toString(values);
    }

    private static String getSrcJudgeFieldsValue(Map<String, Object> src, List<String> judgeFields) {
        StringBuilder sb = new StringBuilder();
        if (src != null && judgeFields != null) {
            for (int i = 0; i < judgeFields.size(); ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(src.get(judgeFields.get(i)));
            }
            if (sb.length() > 255) {
                return sb.substring(0, 255);
            }
        }
        return D.s((Object)sb);
    }

    public static void omitLog(DynamicObject log) {
        log.set(MESSAGE, (Object)DataCopyTask.trim(String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u5ffd\u7565\uff1a%s", (String)"DataCopyTask_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), log.get(MESSAGE))));
        log.set(MODIFY_TIME, (Object)new Date());
        log.set(STATE, (Object)"N");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void updateLog(DynamicObject log, Throwable e) {
        String s = StringUtil.toString((Throwable)e);
        log.set(MESSAGE, (Object)DataCopyTask.trim(String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u5931\u8d25\uff1a%s", (String)"DataCopyTask_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s)));
        log.set(MESSAGE_TAG, s != null && s.length() > 290 ? s : null);
        log.set(STATE, (Object)"F");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void updateLog(DynamicObject log, DataCopyRunner runner, Throwable e) {
        Map<String, Object> tar = runner.getLastTar();
        Map<String, Object> src = runner.getLastSrc();
        if (e != null) {
            String s = StringUtil.toString((Throwable)e);
            log.set(MESSAGE, (Object)DataCopyTask.trim(String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u5931\u8d25\uff1a%s", (String)"DataCopyTask_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s)));
            log.set(MESSAGE_TAG, s != null && s.length() > 290 ? s : null);
            log.set(STATE, (Object)"F");
        } else {
            DataCopyParam param = runner.getParam();
            if (tar != null && SaveDataType.FAILED.equals(tar.get("$action"))) {
                log.set(MESSAGE, (Object)ResManager.loadKDString((String)"\u91cd\u8bd5\u5931\u8d25", (String)"DataCopyTask_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                log.set(MESSAGE_TAG, (Object)String.format(ResManager.loadKDString((String)"\u6682\u65e0\u5806\u6808\u4fe1\u606f\uff0c\u5982\u679c\u65b9\u6848\u914d\u7f6e\u4e86\u9519\u8bef\u65f6\u5ffd\u7565\uff0c\u8bf7\u5173\u6ce8\u65b0\u751f\u6210\u7684\u65e5\u5fd7\u8bb0\u5f55\uff0c\u5019\u9009\u952e\uff1a%s", (String)"DataCopyTask_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), DataCopyTask.getJudgeFieldsValue1(param, src, tar, true)));
                log.set(STATE, (Object)"F");
            } else {
                String message = src == null || tar == null ? ResManager.loadKDString((String)"\u91cd\u8bd5\u6210\u529f\uff01", (String)"DataCopyTask_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u6210\u529f\uff1a%1$s\uff1a %2$s-> %3$s", (String)"DataCopyTask_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tar.get("$action"), DataCopyTask.getIdentity(param, src, tar, true), DataCopyTask.getIdentity(param, src, tar, false));
                log.set(MESSAGE, (Object)DataCopyTask.trim(message));
                log.set(MESSAGE_TAG, null);
                if (tar != null && SaveDataType.NOP.equals(tar.get("$action"))) {
                    log.set(STATE, (Object)"N");
                } else {
                    log.set(STATE, (Object)"S");
                }
            }
        }
        log.set(SERVER_ID, (Object)NetUtil.getServerId());
        log.set(MODIFY_TIME, (Object)new Date());
        DataCopyTask.writeDataToLog(src, log, SOURCE_DATA, SOURCE_DATA_TAG);
        DataCopyTask.writeDataToLog(tar, log, TARGET_DATA, TARGET_DATA_TAG);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private static void writeDataToLog(Object data, DynamicObject log, String field, String field_tag) {
        if (data == null) {
            log.set(field, null);
            log.set(field_tag, null);
        } else {
            log.set(field, (Object)DataCopyTask.trim(JSON.toJSONString((Object)data)));
            String json = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            if (data instanceof List) {
                log.set(field_tag, (Object)StringUtil.trim((String)json, (int)800000));
            } else {
                log.set(field_tag, (Object)json);
            }
        }
    }

    public static String trim(String s) {
        return StringUtil.trim((String)s, (int)150);
    }

    public static Callback getCallback(DynamicObject execution) {
        String callback_info = execution.getString("callback_info");
        Callback callback = null;
        if (!StringUtils.isEmpty((String)callback_info)) {
            try {
                callback = (Callback)JSON.parseObject((String)callback_info, Callback.class);
            }
            catch (Exception e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"json\u89e3\u6790callback_info:[%s]\u51fa\u9519\u3002", (String)"DataCopyTask_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), callback_info), (Throwable)e);
            }
        }
        return callback;
    }

    public static void start(DynamicObject execution) {
        DataCopyTask.start(execution, true);
    }

    public static void start(DynamicObject e, boolean first) {
        long id = D.l((Object)e.getPkValue());
        if (D.s((Object)e.get(SOURCE_DATA)) == null) {
            JobEngine.submit(new DataCopyJob(e.getString("number"), false, id, first, e.getLong("job_mutex_id")));
        } else {
            JobEngine.submit(new DataCopyJob(e.getString("number"), true, id, first, e.getLong("job_mutex_id")));
        }
    }

    static void reschedule(DynamicObject e, Timestamp scheduleTime) {
        long id = D.l((Object)e.getPkValue());
        String number = "[R] " + e.getString("number");
        if (D.s((Object)e.get(SOURCE_DATA)) == null) {
            JobEngine.submit(new DataCopyJob(number, false, id, false, e.getLong("job_mutex_id")), scheduleTime);
        } else {
            JobEngine.submit(new DataCopyJob(number, true, id, false, e.getLong("job_mutex_id")), scheduleTime);
        }
    }

    public static int execute(DynamicObject execution) {
        return DataCopyTask.execute(execution, null);
    }

    public static int execute(DynamicObject execution, ObjectReader<Map<String, Object>> reader) {
        return DataCopyTask.execute(execution, reader, null);
    }

    public static int execute(DynamicObject execution, ObjectReader<Map<String, Object>> reader, Map<String, Object> filterParams) {
        DataCopyRunner runner = new DataCopyRunner(execution, reader, null, filterParams);
        ScheduleManager.submit((Task)new DataCopyTaskState(runner), 5);
        try {
            runner.run();
            DataCopyTask.setSuccess(runner.getParam(), null);
            return runner.getParam().getCounter().getTotalCount();
        }
        catch (Throwable error) {
            DataCopyTask.saveErrorLog(runner.getParam(), error, null, null);
            DataCopyTask.setFailed(runner.getParam(), error, null, true);
            throw error;
        }
    }

    private static void notifyBiz(DataCopyParam param, Callback callback, Throwable e) {
        try {
            if (callback != null) {
                Map<String, Object> response;
                if (DataCopyTask.ischildTask(param.getExecution())) {
                    response = DataCopyTask.getBatchInvokeResponseMap(param.getExecution());
                    if (response == null || !DataCopyTask.updateParentState(param.getExecution())) {
                        return;
                    }
                } else {
                    response = DataCopyTask.getResponseMap(param.getExecution(), e);
                }
                DataCopyTask.addExtendInfo(callback, response);
                DispatchServiceHelper.invokeBizService((String)callback.getCloudId(), (String)callback.getAppId(), (String)callback.getServiceName(), (String)callback.getMethodName(), (Object[])new Object[]{response});
            }
        }
        catch (Throwable bizError) {
            DataCopyTask.saveErrorLog(param, bizError, null, null);
        }
    }

    private static void addExtendInfo(Callback callback, Map<String, Object> response) {
        if (!StringUtil.isEmpty((String)callback.getParam1())) {
            response.put("param1", callback.getParam1());
        }
        if (!StringUtil.isEmpty((String)callback.getParam2())) {
            response.put("param2", callback.getParam2());
        }
        if (!StringUtil.isEmpty((String)callback.getParam3())) {
            response.put("param3", callback.getParam3());
        }
    }

    private static Map<String, Object> getBatchInvokeResponseMap(DynamicObject execution) {
        QFilter parent_filter = new QFilter("parent_execution", "=", (Object)execution.getLong("parent_execution_id"));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ISC_DATA_COPY_EXECUTION, (String)"id,number,state", (QFilter[])new QFilter[]{parent_filter});
        HashMap<String, Object> response = new HashMap<String, Object>();
        for (DynamicObject a : collection) {
            String state = a.getString(STATE);
            if (!"C".equals(state) && !"R".equals(state)) continue;
            return null;
        }
        for (DynamicObject a : collection) {
            DataCopyTask.makeBatchInvokeResponse(response, a, a.getString(STATE));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateParentState(DynamicObject execution) {
        boolean bl;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            preparedStatement = connection.prepareStatement("update T_ISC_DATA_COPY_EXECUTION set FSTATE = ? where FID = ? and FSTATE = ?");
            preparedStatement.setString(1, "S");
            preparedStatement.setLong(2, execution.getLong("parent_execution_id"));
            preparedStatement.setString(3, "C");
            int i = preparedStatement.executeUpdate();
            bl = i == 1;
        }
        catch (Throwable e) {
            boolean bl2;
            try {
                logger.warn("DataCopyTask.updateParentState", e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                DbUtil.close(connection, preparedStatement);
                throw throwable;
            }
            DbUtil.close((Connection)connection, (Statement)preparedStatement);
            return bl2;
        }
        DbUtil.close((Connection)connection, (Statement)preparedStatement);
        return bl;
    }

    private static void makeBatchInvokeResponse(Map<String, Object> response, DynamicObject a, String state) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        response.put(a.getString("number"), result);
        if ("S".equals(state)) {
            result.put("success", Boolean.TRUE);
        } else {
            result.put("success", Boolean.FALSE);
            QFilter log_filter = new QFilter("data_copy_execution", "=", (Object)a.getLong("id"));
            DynamicObject log = QueryServiceHelper.queryOne((String)ENTITY_ISC_DATA_COPY_EXEC_LOG, (String)MESSAGE, (QFilter[])new QFilter[]{log_filter});
            result.put("msg", log.getString(MESSAGE));
        }
        result.put("data", BusinessDataServiceHelper.loadSingle((Object)a.getLong("id"), (String)ISC_DATA_COPY_EXECUTION));
    }

    private static boolean ischildTask(DynamicObject execution) {
        long parent_execution_id = execution.getLong("parent_execution_id");
        return parent_execution_id != 0L;
    }

    private static Map<String, Object> getResponseMap(DynamicObject execution, Throwable e) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (e != null) {
            response.put("success", Boolean.FALSE);
            String s = StringUtil.toString((Throwable)e);
            response.put("msg", s);
        } else {
            response.put("success", Boolean.TRUE);
        }
        response.put("data", execution);
        return response;
    }

    public static String setSuccess(DataCopyParam param, Callback callback) {
        DynamicObject execution = param.getExecution();
        if (execution == null) {
            Long id = D.l((Object)param.getExecutionId());
            execution = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_EXECUTION);
        }
        execution.set("end_time", (Object)new Date());
        DataCopyTask.setStateWhenSuccess(param, execution);
        DataCopyTask.refreshCounter(param, execution);
        DataCopyTaskUtil.updateDataCopyExecution(execution);
        DataCopyTask.notifyBiz(param, callback, null);
        DataCopyTask.invokeNextTriggers(param);
        DynamicObject innerExecution = BusinessDataServiceHelper.loadSingle((Object)execution.getPkValue(), (String)ISC_DATA_COPY_EXECUTION);
        MessageSender.executeSend(innerExecution);
        DataCopyEvent.Type.OnTaskSuccess.raiseEvent(param, null, null, null);
        return execution.getString(STATE);
    }

    private static void setStateWhenSuccess(DataCopyParam param, DynamicObject execution) {
        Counter counter = param.getCounter();
        int totalCount = counter.getTotalCount();
        int failedCount = counter.getFailedCount();
        if (failedCount == 0) {
            execution.set(STATE, (Object)Character.valueOf('S'));
        } else if (failedCount < totalCount) {
            execution.set(STATE, (Object)Character.valueOf('P'));
        } else {
            execution.set(STATE, (Object)Character.valueOf('F'));
        }
    }

    private static void invokeNextTriggers(DataCopyParam param) {
        DynamicObjectCollection entries = param.getTrigger().getDynamicObjectCollection("next_tasks");
        for (DynamicObject entry : entries) {
            DynamicObject next_task = entry.getDynamicObject("next_task");
            if (next_task == null) continue;
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)next_task.get("id"), (String)"isc_data_copy_trigger");
            if (!trigger.getBoolean("enable")) {
                logger.info("\u540e\u7f6e\u65b9\u6848[" + trigger.getString("name") + "]\u72b6\u6001\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5fc5\u987b\u542f\u7528\u540e\u624d\u80fd\u6267\u884c");
                continue;
            }
            DynamicObject execution = DataCopyTask.create(trigger, null, InitType.POST);
            if (execution == null) {
                logger.info("\u540e\u7f6e\u65b9\u6848[" + trigger.getString("name") + "]\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u5fc5\u987b\u5b8c\u6210\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c");
                continue;
            }
            DataCopyTask.start(execution);
        }
    }

    public static void setFailed(DataCopyParam param, Throwable error, Callback callback, boolean lastTry) {
        Long id = D.l((Object)param.getExecutionId());
        DynamicObject execution = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_EXECUTION);
        execution.set("end_time", (Object)new Date());
        execution.set(STATE, (Object)(error instanceof TaskCancelException ? "X" : "F"));
        DataCopyTask.refreshCounter(param, execution);
        Util.save(execution);
        if (lastTry) {
            DataCopyTask.notifyBiz(param, callback, error);
            MessageSender.executeSend(execution);
            DataCopyEvent.Type.OnTaskFailed.raiseEvent(param, null, null, error);
        }
    }

    private static void refreshCounter(DataCopyParam param, DynamicObject execution) {
        Counter counter = param.getCounter();
        execution.set("total_count", (Object)counter.getTotalCount());
        execution.set("success_count", (Object)counter.getSuccessCount());
        execution.set("failed_count", (Object)counter.getFailedCount());
        execution.set("ignored_count", (Object)counter.getIgnoredCount());
        execution.set("prepare_time", (Object)(execution.getLong("prepare_time") + counter.getPrepareTime()));
        execution.set("read_time", (Object)(execution.getLong("read_time") + counter.getReadTime()));
        execution.set("convert_time", (Object)(execution.getLong("convert_time") + counter.getConvertTime()));
        execution.set("load_time", (Object)(execution.getLong("load_time") + counter.getLoadTime()));
        execution.set("read_bytes", (Object)(execution.getLong("read_bytes") + counter.getReadBytes()));
        execution.set("load_bytes", (Object)(execution.getLong("load_bytes") + counter.getLoadBytes()));
        execution.set("thread_count", (Object)counter.getThreadCount());
        execution.set("batch_size", (Object)counter.getBatchSize());
        execution.set("exec_time", (Object)0);
        String state = execution.getString(STATE);
        if ("S".equals(state) || "F".equals(state) || "P".equals(state)) {
            long startTime = counter.getStartTime();
            long endTime = D.l((Object)execution.getDate("end_time"));
            if (endTime > 0L && startTime > 0L) {
                execution.set("exec_time", (Object)(endTime - startTime));
            }
        }
    }

    private static void updateTrigger(DynamicObject execution) {
        Object triggerId = execution.get(DATA_COPY_TRIGGER_ID);
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
        trigger.set("total_count", (Object)(trigger.getLong("total_count") + 1L));
        trigger.set("start_time", (Object)new Date());
        OperationServiceHelper.executeOperate((String)"save", (String)"isc_data_copy_trigger", (DynamicObject[])new DynamicObject[]{trigger}, (OperateOption)OperateOption.create());
    }

    public static DynamicObject create(DynamicObject trigger, Map<String, Object> params, InitType type) {
        return DataCopyTask.create(trigger, params, null, null, type);
    }

    public static DynamicObject create(long triggerId, Object data) {
        return DataCopyTask.create(triggerId, data, InitType.PUSH);
    }

    public static DynamicObject create(long triggerId, Object data, InitType type) {
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
        InitType initType = type != null ? type : InitType.PUSH;
        return DataCopyTask.create(trigger, null, null, null, data, initType);
    }

    public static DynamicObject create(long triggerId, Object data, Callback callback) {
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
        return DataCopyTask.create(trigger, null, callback, null, data, InitType.API_ASYN);
    }

    public static DynamicObject createByNumber(String trigger_number, Object data, Callback callback) {
        DynamicObject trigger = DataCopyOpenApi.getTrigger(trigger_number);
        return DataCopyTask.create(trigger, null, callback, null, data, InitType.API_ASYN);
    }

    public static DynamicObject create(DynamicObject trigger, Map<String, Object> params, Callback callback, DynamicObject parent_execution, InitType type) {
        return DataCopyTask.create(trigger, params, callback, parent_execution, null, type);
    }

    public static DynamicObject create(DynamicObject trigger, Map<String, Object> params, Callback callback, DynamicObject parent_execution, Object data, InitType type) {
        if (params != null && data != null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0e\u6570\u636e\u4e0d\u53ef\u540c\u65f6\u63d0\u4f9b\uff01", (String)"DataCopyTask_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (params == null && data == null && DataCopyTask.findRunningExecutions(trigger) != null) {
            logger.info("trigger is running. number=" + trigger.get("number"));
            return null;
        }
        DynamicObject exe = DataCopyTask.createDataCopyExecution(trigger, params, callback, parent_execution, data, type, null, null);
        DataCopyTask.refreshTriggerInfo(trigger);
        String message = "execution is created. number=" + exe.get("number") + ", id=" + exe.getPkValue() + ", trigger=" + trigger.get("number");
        logger.info(message);
        return exe;
    }

    public static DynamicObject createSyncExecution(DynamicObject trigger, Object data) {
        return DataCopyTask.createSyncExecution(trigger, data, null);
    }

    public static DynamicObject createSyncExecution(DynamicObject trigger, Object data, Map<String, Object> params) {
        return DataCopyTask.createSyncExecutionX(trigger, data, params, null, null);
    }

    public static DynamicObject createSyncExecutionX(DynamicObject trigger, Object data, Map<String, Object> params, String realDataSourceNumber, String realDataTargetNumber) {
        DynamicObject exe = DataCopyTask.createDataCopyExecution(trigger, params, null, null, data, InitType.API_SYNC, realDataSourceNumber, realDataTargetNumber);
        DataCopyTask.refreshTriggerInfo(trigger);
        String message = "create Sync Execution . number=" + exe.get("number") + ", id=" + exe.getPkValue() + ", trigger=" + trigger.get("number");
        logger.info(message);
        return exe;
    }

    public static void refreshTriggerInfo(DynamicObject trigger) {
        String sql = "UPDATE t_isc_data_copy_trigger SET ftrigged_time=?, ftotal_count = ftotal_count+1 WHERE fid=?";
        Connection cn = TX.__getAloneConnection((String)"ISCB", (boolean)false, (String)"t_isc_data_copy_trigger", (String[])new String[0]);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(new Timestamp(System.currentTimeMillis()), trigger.getLong("id")), Arrays.asList(93, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static DynamicObject createParentExecution() {
        DynamicObject exe = BusinessDataServiceHelper.newDynamicObject((String)ISC_DATA_COPY_EXECUTION);
        String number = Long.toHexString(Hash.mur64((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8))).toUpperCase() + "Parent";
        if (number.length() > 30) {
            number = number.substring(0, 30);
        }
        long id = IDService.get().genLongId(RequestContext.get().getTenantId(), ISC_DATA_COPY_EXECUTION);
        exe.set("id", (Object)id);
        exe.set("number", (Object)number);
        exe.set("name", (Object)number);
        exe.set("status", (Object)"C");
        exe.set(STATE, (Object)"C");
        exe.set("enable", (Object)"1");
        exe.set("type", (Object)"2");
        exe.set("execute_count", (Object)0);
        exe.set("creator", (Object)RequestContext.get().getUserId());
        exe.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        CommonUtil.check(OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATA_COPY_EXECUTION, (DynamicObject[])new DynamicObject[]{exe}, (OperateOption)OperateOption.create()));
        return exe;
    }

    public static long getRealSourceSystem(DynamicObject trigger, String realDataSourceNumber) {
        if (StringUtil.isEmpty((String)realDataSourceNumber)) {
            if (trigger.getLong("new_source_system_id") != 0L) {
                return trigger.getLong("new_source_system_id");
            }
            DynamicObject dataCopySchema = DataCopySchema.get(trigger.getLong("data_copy_id"));
            return dataCopySchema.getLong("data_source_id");
        }
        return DataCopyTask.getDataSourceIdByNumber(realDataSourceNumber);
    }

    public static long getRealTargetSystem(DynamicObject trigger, String realDataTargetNumber) {
        if (StringUtil.isEmpty((String)realDataTargetNumber)) {
            if (trigger.getLong("new_target_system_id") != 0L) {
                return trigger.getLong("new_target_system_id");
            }
            DynamicObject dataCopySchema = DataCopySchema.get(trigger.getLong("data_copy_id"));
            return dataCopySchema.getLong("data_target_id");
        }
        return DataCopyTask.getDataSourceIdByNumber(realDataTargetNumber);
    }

    private static long getDataSourceIdByNumber(String realDataTargetNumber) {
        DataSource dataSource = DataSource.get(realDataTargetNumber);
        if (dataSource != null) {
            return dataSource.getId();
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\u6e90", (String)"DataCopyTask_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]), realDataTargetNumber));
    }

    private static DynamicObject createDataCopyExecution(DynamicObject trigger, Map<String, Object> params, Callback callback, DynamicObject parent_execution, Object data, InitType type, String realDataSourceNumber, String realDataTargetNumber) {
        if (DataCopyTask.isSyncInvokeAndConfigMutex(trigger, type)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\uff08%s\uff09\u8bbe\u7f6e\u4e86\u4e92\u65a5\u6807\u5fd7\uff0c\u7981\u6b62\u540c\u6b65\u8c03\u7528\u3002", (String)"DataCopyTask_26", (String)"isc-iscb-platform-core", (Object[])new Object[0]), trigger.get("number")));
        }
        if (!D.x((Object)trigger.get("enable")) && AppParameterServiceHelper.isEnableControl()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\uff08%s\uff09\u672a\u542f\u7528\uff0c\u7981\u6b62\u6267\u884c\u3002", (String)"DataCopyTask_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]), trigger.get("number")));
        }
        final DynamicObject exe = BusinessDataServiceHelper.newDynamicObject((String)ISC_DATA_COPY_EXECUTION);
        long id = IDService.get().genLongId();
        String number = DataCopyTask.generateExecutionNumber(trigger);
        exe.set("id", (Object)id);
        exe.set("number", (Object)number);
        exe.set("name", (Object)DataCopyTask.generateExecutionName(trigger, data, type));
        exe.set("data_copy_trigger", (Object)trigger);
        exe.set("data_copy_schama", trigger.get("data_copy"));
        exe.set("status", (Object)"C");
        exe.set("host", (Object)TaskManager.getInstanceId());
        if (InitType.API_SYNC == type || InitType.SF_SYNC == type || InitType.SCRIPT_SYNC == type) {
            exe.set("start_time", (Object)new Timestamp(System.currentTimeMillis()));
            exe.set(STATE, (Object)"R");
            exe.set("execute_count", (Object)1);
        } else {
            exe.set(STATE, (Object)"C");
            exe.set("execute_count", (Object)0);
        }
        exe.set("enable", (Object)"1");
        exe.set("total_count", (Object)-1);
        exe.set("success_count", (Object)-1);
        exe.set("failed_count", (Object)-1);
        exe.set("ignored_count", (Object)-1);
        exe.set("creator", (Object)RequestContext.get().getUserId());
        exe.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        exe.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        exe.set("params_entryentity", (Object)DataCopyTask.createParams(trigger, exe, params));
        String callback_info = callback != null ? JSON.toJSONString((Object)callback) : D.s((Object)trigger.get("callback_info"));
        exe.set("callback_info", (Object)callback_info);
        DataCopyTask.handlePushData(trigger, data, type, exe);
        if (parent_execution != null) {
            exe.set("parent_execution", (Object)parent_execution);
            exe.set("type", (Object)"1");
        } else {
            exe.set("type", (Object)"0");
        }
        exe.set("real_source_system", (Object)DataCopyTask.getRealSourceSystem(trigger, realDataSourceNumber));
        exe.set("real_target_system", (Object)DataCopyTask.getRealTargetSystem(trigger, realDataTargetNumber));
        exe.set("job_mutex", trigger.get("job_mutex"));
        TraceStack.run(TraceType.NEW_DCE, number, id, new TraceTask(){

            public void run() {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exe});
            }
        });
        return exe;
    }

    public static long getRealSourceSystem(DynamicObject trigger) {
        return DataCopyTask.getRealSourceSystem(trigger, null);
    }

    public static long getRealTargetSystem(DynamicObject trigger) {
        return DataCopyTask.getRealTargetSystem(trigger, null);
    }

    private static void handlePushData(DynamicObject trigger, Object data, InitType type, DynamicObject exe) {
        if (data != null) {
            String str = Json.toString((Object)data, (boolean)true);
            if (str.contains("$is_filter") && DataCopyTaskStage.getBatchId() != null) {
                exe.set(SOURCE_DATA, (Object)ResManager.loadKDString((String)"{\u4efb\u52a1\u5206\u6279\u6570\u636e}", (String)"DataCopyTask_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                exe.set("taskstage", DataCopyTaskStage.getBatchId());
                exe.set(STATE, (Object)"B");
            } else if (InitType.REDO_BY_ES == type) {
                exe.set(SOURCE_DATA, (Object)ResManager.loadKDString((String)"{ES\u65e5\u5fd7\u6784\u9020\u7684\u6e90\u6570\u636e}", (String)"DataCopyTask_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            } else if (InitType.ISC_HUB_EVT == type) {
                exe.set(SOURCE_DATA, (Object)ResManager.loadKDString((String)"{HUB\u4e8b\u4ef6\u63a8\u9001\u7684\u6e90\u6570\u636e}", (String)"DataCopyTask_31", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            } else if (str.contains("filter_column") && "event".equals(trigger.get("trigger_type"))) {
                exe.set(SOURCE_DATA, (Object)ResManager.loadKDString((String)"{\u4e8b\u4ef6\u76d1\u542c\u8865\u507f}", (String)"DataCopyTask_32", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            } else {
                exe.set(SOURCE_DATA, (Object)ResManager.loadKDString((String)"{\u63a8\u9001\u7684\u6e90\u6570\u636e}", (String)"DataCopyTask_33", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            exe.set(SOURCE_DATA_TAG, (Object)str);
        }
    }

    private static boolean isSyncInvokeAndConfigMutex(DynamicObject trigger, InitType type) {
        return (type == InitType.API_SYNC || type == InitType.SF_SYNC) && D.s((Object)trigger.get("mutex_name")) != null;
    }

    public static String generateExecutionName(DynamicObject trigger, Object data, InitType type) {
        String name;
        String str;
        boolean scriptCompensate;
        boolean bl = scriptCompensate = InitType.SCRIPT_SYNC.equals((Object)type) || InitType.SCRIPT_ASYN.equals((Object)type);
        if (!scriptCompensate && data != null && (str = Json.toString((Object)data, (boolean)true)).contains("filter_column") && "event".equals(trigger.get("trigger_type"))) {
            type = InitType.MANUAL_COM;
        }
        String flag = "";
        if (TraceManager.contains((String)TraceType.TIMER.name()) && !TraceManager.contains((String)TraceType.EXE_JOB.name())) {
            flag = "*";
        }
        if ((name = "[" + (Object)((Object)type) + flag + "]" + D.s((Object)trigger.get("name"))).length() > 50) {
            name = name.substring(0, 48) + "..";
        }
        return name;
    }

    public static String generateExecutionNumber(DynamicObject trigger) {
        long id = IDService.get().genLongId();
        String number = Hash.longToDigital32((long)id) + "-" + trigger.get("number");
        if (number.length() > 30) {
            number = number.substring(0, 30);
        }
        return DataCopyDebugger.decorateNumber(number);
    }

    public static DynamicObjectCollection createParams(DynamicObject trigger, DynamicObject exe, Map<String, Object> params) {
        DynamicObjectCollection exeParamsEntries = exe.getDynamicObjectCollection("params_entryentity");
        DynamicObjectCollection triggerParamsEntries = trigger.getDynamicObjectCollection("params_entryentity");
        exeParamsEntries.clear();
        for (DynamicObject t : triggerParamsEntries) {
            DynamicObject rowObj = exeParamsEntries.addNew();
            String name = t.getString("params_name");
            rowObj.set("params_name", (Object)name);
            rowObj.set("params_label", (Object)t.getString("params_label"));
            rowObj.set("params_data_type", (Object)t.getString("params_data_type"));
            rowObj.set("params_value", DataCopyTask.getParams_value(params, t, name));
        }
        return exeParamsEntries;
    }

    private static Object getParams_value(Map<String, Object> params, DynamicObject t, String name) {
        Object o = null;
        if (params != null) {
            o = params.get(name);
        }
        if (o != null) {
            if (o instanceof List) {
                String s = JSON.toJSONString((Object)o);
                if (s.length() > 2000) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5217\u8868\u53c2\u6570\uff1a%1$s\u7684\u53c2\u6570\u503c\u592a\u957f\uff0c\u603b\u957f\u5ea6\uff1a%2$s,\u524d\u4e00\u767e\u4e2a\u5b57\u7b26\u4e3a\uff1a%3$s", (String)"DataCopyTask_34", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, s.length(), s.substring(0, 100)));
                }
                return s;
            }
            return o;
        }
        return t.get("params_value");
    }

    private static DynamicObject findRunningExecutions(DynamicObject trigger) {
        Timestamp deadline = new Timestamp(System.currentTimeMillis() - 30000L);
        QFilter filter = new QFilter("data_copy_trigger", "=", trigger.getPkValue()).and(new QFilter(STATE, "=", (Object)"R")).and(new QFilter("modifytime", ">", (Object)deadline));
        DynamicObject exe = BusinessDataServiceHelper.loadSingle((String)ISC_DATA_COPY_EXECUTION, (String)"id", (QFilter[])new QFilter[]{filter});
        return exe;
    }

    public static DynamicObject create(DynamicObject trigger, Map<String, Object> params, Callback callback, DynamicObject parent_execution, Object data, InitType type, String realDataSourceNumber, String realDataTargetNumber) {
        DynamicObject exe = DataCopyTask.createDataCopyExecution(trigger, params, callback, parent_execution, data, type, realDataSourceNumber, realDataTargetNumber);
        DataCopyTask.refreshTriggerInfo(trigger);
        String message = "execution is created. number=" + exe.get("number") + ", id=" + exe.getPkValue() + ", trigger=" + trigger.get("number");
        logger.info(message);
        return exe;
    }

    private static void init() {
        try {
            int delay = 0;
            RequestContext ctx = null;
            for (Account c : AccountUtils.getAllAccountsOfCurrentEnv()) {
                ctx = ContextUtil.createRequestContext(c.getAccountId(), c.getTenantId());
                logger.info("\u73af\u5883\u521d\u59cb\u5316\u4efb\u52a1\u5f00\u59cb\u521b\u5efa\uff0c\u8d26\u5957\uff1a" + c.getAccountId() + "@" + c.getTenantId() + "; \u5b9e\u9645\uff1a" + ctx.getAccountId() + "@" + ctx.getTenantId());
                ScheduleManager.submit((Task)new DataCopyEnv(c.getAccountId()), ctx, delay++ * 5 + rnd.nextInt(20));
                ScheduleManager.submit((Task)new DataCopyTaskMonitor(c.getAccountId()), ctx, ++delay + rnd.nextInt(120) + 25);
                ScheduleManager.submit((Task)new EventLogCleaner(c.getAccountId()), ctx, ++delay * 5 + rnd.nextInt(180) + 60);
                ScheduleManager.submit((Task)new ServiceFlowProcessInstMonitor(c.getAccountId()), ctx, ++delay + rnd.nextInt(240) + 200);
                ScheduleManager.submit((Task)new DataBaseLinkStateMonitor(c.getAccountId()), ctx, ++delay + rnd.nextInt(300) + 200);
                logger.info("\u73af\u5883\u521d\u59cb\u5316\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff0c\u8d26\u5957\uff1a" + c.getAccountId() + "@" + c.getTenantId() + "; \u5b9e\u9645\uff1a" + ctx.getAccountId() + "@" + ctx.getTenantId());
            }
            if (ctx != null) {
                ScheduleManager.submit((Task)new TimerTask(), ctx, 1);
                ScheduleManager.submit((Task)new JobNotifier(), ctx, 60);
                ScheduleManager.submit((Task)new CheckIfSystemIsBusy(), ctx, 60);
            }
        }
        catch (Throwable e) {
            logger.warn("isc-init-failed", e);
        }
    }

    static {
        try {
            Functions.init();
            DataCopyTask.init();
        }
        finally {
            try {
                logger.info("find-isc-starter", (Object)new Exception("\u8fd9\u4e0d\u662f\u5f02\u5e38\uff0c\u4ec5\u7528\u4e8e\u8ffd\u6eaf\u662f\u54ea\u4e2a\u8c03\u7528\u8005\u9996\u6b21\u8c03\u7528\u4e86\u672c\u7c7b"));
            }
            catch (Throwable e) {
                logger.warn("find-isc-starter2", e);
            }
        }
    }

    public static enum InitType {
        API_ASYN(new MultiLangEnumBridge("API_\u5f02\u6b65", "DataCopyTask_0", "isc-iscb-platform-core")),
        API_SYNC(new MultiLangEnumBridge("API_\u540c\u6b65", "DataCopyTask_1", "isc-iscb-platform-core")),
        PUSH(new MultiLangEnumBridge("\u63a8\u9001", "DataCopyTask_2", "isc-iscb-platform-core")),
        TIMER(new MultiLangEnumBridge("\u5b9a\u65f6", "DataCopyTask_3", "isc-iscb-platform-core")),
        MANUAL(new MultiLangEnumBridge("\u4eba\u5de5", "DataCopyTask_4", "isc-iscb-platform-core")),
        MANUAL_COM(new MultiLangEnumBridge("\u4eba\u5de5\u8865\u507f", "DataCopyTask_5", "isc-iscb-platform-core")),
        AUTO_COM(new MultiLangEnumBridge("\u81ea\u52a8\u8865\u507f", "DataCopyTask_6", "isc-iscb-platform-core")),
        POST(new MultiLangEnumBridge("\u540e\u7f6e", "DataCopyTask_7", "isc-iscb-platform-core")),
        SF_ASYN(new MultiLangEnumBridge("\u670d\u52a1\u7f16\u6392_\u5f02\u6b65", "DataCopyTask_8", "isc-iscb-platform-core")),
        SF_SYNC(new MultiLangEnumBridge("\u670d\u52a1\u7f16\u6392_\u540c\u6b65", "DataCopyTask_9", "isc-iscb-platform-core")),
        REDO_BY_ES(new MultiLangEnumBridge("ES\u65e5\u5fd7\u91cd\u505a", "DataCopyTask_10", "isc-iscb-platform-core")),
        ISC_HUB_EVT(new MultiLangEnumBridge("hub\u4e8b\u4ef6\u63a8\u9001", "DataCopyTask_11", "isc-iscb-platform-core")),
        SCRIPT_SYNC(new MultiLangEnumBridge("\u811a\u672c\u8865\u507f_\u540c\u6b65", "DataCopyTask_12", "isc-iscb-platform-core")),
        SCRIPT_ASYN(new MultiLangEnumBridge("\u811a\u672c\u8865\u507f_\u5f02\u6b65", "DataCopyTask_13", "isc-iscb-platform-core"));

        private MultiLangEnumBridge description;

        private InitType(MultiLangEnumBridge description) {
            this.description = description;
        }

        public String toString() {
            return this.description.loadKDString();
        }
    }
}

