/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyRunner;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.io.Counter;

public final class DataCopyTaskState
implements DaemonTask {
    protected static final int INTERVAL = 5;
    private DataCopyRunner runner;
    private String id = UUID.randomUUID().toString();
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    @Override
    public String getId() {
        return this.id;
    }

    public DataCopyTaskState(DataCopyRunner runner) {
        this.runner = runner;
    }

    @Override
    public void run() {
        if (this.runner.isRunning()) {
            this.refreshModifiedTime();
            ScheduleManager.submit((Task)this, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshModifiedTime() {
        boolean bl;
        Counter c = this.runner.getParam().getCounter();
        if (c == null) {
            return false;
        }
        Connection cn = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Timestamp endTime = DataCopyTaskState.forcastEndTime(c);
            String sql = "UPDATE T_ISC_DATA_COPY_EXECUTION SET fmodifytime=?, fend_time=?, ftotal_count=?, fsuccess_count=?, ffailed_count=?, fignored_count=?, fprepare_time=?, fread_time=?, fconvert_time=?, fload_time=?, fread_bytes=" + c.getReadBytes() + ",fload_bytes=" + c.getLoadBytes() + ", fthread_count=?, fbatch_size=?, fhost=? WHERE fstate='R' and fid=" + this.runner.getParam().getExecutionId();
            List<Object> values = Arrays.asList(now, endTime, c.getTotalCount(), c.getSuccessCount(), c.getFailedCount(), c.getIgnoredCount(), c.getPrepareTime(), c.getReadTime(), c.getConvertTime(), c.getLoadTime(), c.getThreadCount(), c.getBatchSize(), TaskManager.getInstanceId());
            List<Integer> types = Arrays.asList(93, 93, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 12);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
        }
        catch (Throwable e) {
            try {
                logger.warn("failed to update dc state.", e);
                boolean bl2 = true;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DbUtil.close(cn, (boolean)true);
            }
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return bl;
    }

    public static boolean setStarting(long executionId, String state, boolean first) {
        if ("R".equals(state)) {
            return true;
        }
        if ("S".equals(state) || "X".equals(state) || "P".equals(state)) {
            return false;
        }
        boolean updated = DataCopyTaskState.updateExecution(executionId, state);
        if (updated && !first) {
            DataCopyTaskState.updateExecLog(executionId);
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateExecLog(long executionId) {
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            String sql = "UPDATE t_isc_data_copy_exec_log SET fstate='G' WHERE fdata_copy_execution=? AND fstate='F'";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(executionId), Collections.singletonList(-5));
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateExecution(long executionId, String state) {
        boolean bl;
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = "UPDATE T_ISC_DATA_COPY_EXECUTION SET fmodifytime=?, fstart_time=?, fhost=?, fend_time=null, fstate='R', ftotal_count=-1, fsuccess_count=0, ffailed_count=0,  fignored_count=0,fthread_count=0, fexecute_count = fexecute_count + 1 WHERE fid= ? and fstate = ? ";
            List<Object> values = Arrays.asList(now, now, TaskManager.getInstanceId(), executionId, state);
            List<Integer> types = Arrays.asList(93, 93, 12, -5, 12);
            bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setWaiting(long executionId, String state) {
        boolean bl;
        Connection cn = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = "UPDATE T_ISC_DATA_COPY_EXECUTION SET fmodifytime=?, fhost=?, fend_time=null, fstate='W', ftotal_count=-1, fsuccess_count=0, ffailed_count=0, fignored_count=0,fthread_count=0 WHERE fstate = ? and fid= ?";
            List<Object> values = Arrays.asList(now, TaskManager.getInstanceId(), state, executionId);
            List<Integer> types = Arrays.asList(93, 12, 12, -5);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setFailed(long executionId) {
        Connection cn = null;
        try {
            String sql = "UPDATE T_ISC_DATA_COPY_EXECUTION SET fmodifytime=? ,fstate='F' WHERE fid=" + executionId;
            List<Timestamp> values = Collections.singletonList(new Timestamp(System.currentTimeMillis()));
            List<Integer> types = Collections.singletonList(93);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            boolean bl = true;
            DbUtil.close((Connection)cn, (boolean)true);
            return bl;
        }
        catch (Exception e) {
            logger.warn("\u4fdd\u5b58\u5931\u8d25\u72b6\u6001\u5931\u8d25\uff1a", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtil.close(cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean restoreState(long executionId) {
        boolean bl;
        Connection cn = null;
        try {
            String sql = "UPDATE T_ISC_DATA_COPY_EXECUTION SET fmodifytime=?,fstart_time=null, fhost=' ', fend_time=null, fstate='C', ftotal_count=-1, fsuccess_count=-1, ffailed_count=-1, fthread_count=0 WHERE fstate = 'R' and fid=" + executionId;
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            List<Timestamp> values = Collections.singletonList(now);
            List<Integer> types = Collections.singletonList(93);
            bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return bl;
    }

    public static Timestamp forcastEndTime(Counter counter) {
        long start = counter.getStartTime();
        long elapsed = System.currentTimeMillis() - counter.getStartTime();
        long total = counter.getTotalCount();
        long count = (long)counter.getFailedCount() + (long)counter.getSuccessCount();
        if (elapsed > 10000L && count > 0L) {
            long fifty_days = 4320000000L;
            long ts = start + Math.min(elapsed * total / count, 4320000000L);
            return new Timestamp(ts);
        }
        return null;
    }
}

