/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import com.alibaba.fastjson.JSON;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.startjob.CronJobUtil;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.DataTypeEqualsUtil;
import kd.isc.iscb.platform.core.util.TimerJobUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;
import org.quartz.CronExpression;

public class DataCopyTaskUtil {
    private static final String TXTDESC = "txtdesc";
    private static final String CYCLENUM = "cyclenum";
    private static final String REPEATMODE = "repeatmode";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";
    private static final String STATUS = "status";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String TRIGGER = "trigger";
    private static final String ID = "id";
    private static final String ENTITY_SCH_TASKDEFINE = "sch_taskdefine";
    private static final String ISC_DATA_COPY_TASK = "ISC_DATA_COPY_TASK";
    private static final String NUMBER = "number";

    public static String createDataCopyTaskDefine() {
        QFilter filter = new QFilter(NUMBER, "=", (Object)ISC_DATA_COPY_TASK);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_TASKDEFINE, (String)ID, (QFilter[])new QFilter[]{filter});
        if (obj != null) {
            return (String)obj.getPkValue();
        }
        return DataCopyTaskUtil.innerCreateDataCopyTaskDefine(ISC_DATA_COPY_TASK);
    }

    private static String innerCreateDataCopyTaskDefine(String number) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_SCH_TASKDEFINE);
        obj.set(ID, (Object)Hash.mur2base64((Object[])new Object[]{UUID.randomUUID()}));
        obj.set(NUMBER, (Object)number);
        obj.set("name", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u6570\u636e\u590d\u5236\u4efb\u52a1", (String)"DataCopyTaskUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        obj.set("classname", (Object)DataCopyTask.class.getName());
        obj.set("appid", (Object)"iscb");
        DynamicObjectCollection params = obj.getDynamicObjectCollection("paramentry");
        DynamicObject param = new DynamicObject(params.getDynamicObjectType());
        param.set("paramname", (Object)TRIGGER);
        param.set("paramtype", (Object)"1");
        params.add((Object)param);
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return (String)obj.getPkValue();
    }

    public static DynamicObject getExistedObject(String entityName, Object id) {
        if (QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)String.valueOf(id))})) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        obj.set(ID, id);
        return obj;
    }

    private static DynamicObject createJob(DynamicObject trigger) {
        String id = D.s((Object)trigger.get("job_define_id"));
        if (id == null) {
            id = String.valueOf(Hash.md5i64((byte[])trigger.getPkValue().toString().getBytes(StandardCharsets.UTF_8)));
        }
        DynamicObject obj = DataCopyTaskUtil.getExistedObject(ENTITY_SCH_JOB, id);
        String number = "iscb-" + trigger.getString(NUMBER);
        obj.set(NUMBER, (Object)number);
        obj.set("jobtype", (Object)"BIZ");
        obj.set("taskclassname", (Object)DataCopyTaskUtil.createDataCopyTaskDefine());
        obj.set("classname", (Object)DataCopyTask.class.getName());
        TimerJobUtil.setRunJobUser(trigger.getString("exe_job_user"), obj);
        obj.set(STATUS, (Object)"1");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TRIGGER, trigger.getPkValue());
        obj.set("params", (Object)JSON.toJSONString(params));
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObject param = new DynamicObject(entries.getDynamicObjectType());
        param.set("paramname", (Object)TRIGGER);
        param.set("paramvalue", (Object)trigger.getPkValue().toString());
        entries.add((Object)param);
        obj.set("name", trigger.get("name"));
        obj.set("runbylang", (Object)RequestContext.get().getLang());
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return obj;
    }

    private static DynamicObject disableJob(DynamicObject trigger) {
        DynamicObject job = trigger.getDynamicObject("job_define");
        if (job == null) {
            return null;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)job.getPkValue(), (String)ENTITY_SCH_JOB);
        obj.set(STATUS, (Object)"0");
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob((String)job.getPkValue());
        return obj;
    }

    public static void createJobSchedule(DynamicObject trigger) {
        DataCopyTaskUtil.disableJobSchedule(trigger);
        if (CronJobUtil.isIscScheduleEnable()) {
            DataCopyTaskUtil.createScheduleJobByIsc(trigger);
        } else {
            DynamicObject job = DataCopyTaskUtil.createJob(trigger);
            DynamicObject schedule = DataCopyTaskUtil.createSchedule(trigger, job);
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableJob((String)job.getPkValue());
            scheduleManager.enableSchedule((String)schedule.getPkValue());
            trigger.set("job_define", job.getPkValue());
            trigger.set("job_schedule", schedule.getPkValue());
            CommonUtil.check(OperationServiceHelper.executeOperate((String)"save", (String)"isc_data_copy_trigger", (DynamicObject[])new DynamicObject[]{trigger}, (OperateOption)OperateOption.create()));
        }
    }

    private static void createScheduleJobByIsc(DynamicObject trigger) {
        String cron = trigger.getString("schedule");
        if (StringUtil.isEmpty((String)cron)) {
            cron = DataCopyTaskUtil.buildCronByInterval(trigger);
        } else {
            DataCopyTaskUtil.checkCron(cron);
        }
        String job_user = trigger.getString("exe_job_user");
        long creator = D.l((Object)TimerJobUtil.getUserIdByNumber(job_user));
        if (creator > 0L) {
            CronJobUtil.enable("isc_data_copy_trigger", cron, D.t((Object)trigger.get("validated_time")), D.t((Object)trigger.get("expired_time")), trigger.getLong(ID), trigger.getString("name"), creator);
        } else {
            CronJobUtil.enable("isc_data_copy_trigger", cron, D.t((Object)trigger.get("validated_time")), D.t((Object)trigger.get("expired_time")), trigger.getLong(ID), trigger.getString("name"), D.l((Object)RequestContext.get().getUserId()));
        }
    }

    private static String buildCronByInterval(DynamicObject trigger) {
        long startTime = ((Timestamp)DataCopyTaskUtil.getStartTime(trigger)).getTime();
        TimeSpan timeSpan = DataCopyTaskUtil.getTimeSpan(startTime);
        String interval = D.s((Object)trigger.get("interval"));
        return DataCopyTaskUtil.buildCron(interval, timeSpan);
    }

    public static void disableJobSchedule(DynamicObject trigger) {
        if ("auto".equals(trigger.get("trigger_type"))) {
            DataCopyTaskUtil.disableSchedule(trigger);
            DataCopyTaskUtil.disableJob(trigger);
            CronJobUtil.disable(trigger.getLong(ID));
        }
    }

    private static DynamicObject createSchedule(DynamicObject trigger, DynamicObject job) {
        String id = D.s((Object)trigger.get("job_schedule_id"));
        if (id == null) {
            id = String.valueOf(Hash.md5i64((byte[])trigger.getPkValue().toString().getBytes(StandardCharsets.UTF_8)));
        }
        DynamicObject obj = DataCopyTaskUtil.getExistedObject(ENTITY_SCH_SCHEDULE, id);
        String number = "iscb-" + trigger.getString(NUMBER);
        obj.set(NUMBER, (Object)number);
        obj.set("job", job.getPkValue());
        obj.set("starttime", DataCopyTaskUtil.getStartTime(trigger));
        obj.set("endtime", DataCopyTaskUtil.getEndTime(trigger));
        String interval = trigger.getString("interval");
        if ("0".equals(interval)) {
            DataCopyTaskUtil.handleCron(trigger, obj);
        } else {
            long startTime = ((Timestamp)DataCopyTaskUtil.getStartTime(trigger)).getTime();
            TimeSpan timeSpan = DataCopyTaskUtil.getTimeSpan(startTime);
            obj.set("plan", (Object)DataCopyTaskUtil.buildCron(interval, timeSpan));
            DataCopyTaskUtil.setScheduleDetail(obj, interval);
        }
        obj.set("combdorw", (Object)"d");
        obj.set(STATUS, (Object)"1");
        obj.set("name", trigger.get("name"));
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return obj;
    }

    private static void handleCron(DynamicObject trigger, DynamicObject obj) {
        String cron = trigger.getString("schedule");
        DataCopyTaskUtil.checkCron(cron);
        obj.set("plan", (Object)cron);
        obj.set(REPEATMODE, (Object)"def");
        obj.set(TXTDESC, (Object)ResManager.loadKDString((String)"\u6b64\u8c03\u5ea6\u8ba1\u5212\u7531\u96c6\u6210\u4e91\u542f\u52a8\u65b9\u6848\u81ea\u52a8\u751f\u6210", (String)"DataCopyTaskUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public static String buildCron(String interval, TimeSpan timeSpan) {
        if (DataTypeEqualsUtil.isMatchType(interval, "integer")) {
            int minutes = DataCopyTaskUtil.getMinutes(interval);
            if (minutes == 60) {
                return "0 0 * * * ?";
            }
            return "0 0/" + minutes + " * * * ?";
        }
        if (!StringUtil.isEmpty((String)interval)) {
            return DataCopyTaskUtil.constructCron(interval, timeSpan);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u4efb\u52a1\u8c03\u5ea6\u7684\u5faa\u73af\u7c7b\u578b:%s", (String)"DataCopyTaskUtil_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), interval));
    }

    public static void setScheduleDetail(DynamicObject obj, String interval) {
        if (DataTypeEqualsUtil.isMatchType(interval, "integer")) {
            int minutes = DataCopyTaskUtil.getMinutes(interval);
            if (minutes == 60) {
                obj.set(REPEATMODE, (Object)"h");
                obj.set(CYCLENUM, (Object)1);
                obj.set(TXTDESC, (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e\u6bcf1\u5c0f\u65f6\u91cd\u590d", (String)"DataCopyTaskUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            } else {
                obj.set(REPEATMODE, (Object)"mi");
                obj.set(CYCLENUM, (Object)minutes);
                obj.set(TXTDESC, (Object)String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e\u6bcf%s\u5206\u949f\u91cd\u590d", (String)"DataCopyTaskUtil_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), minutes));
            }
        } else if (!StringUtil.isEmpty((String)interval)) {
            if ("d1".equals(interval)) {
                obj.set(REPEATMODE, (Object)"def");
            } else {
                obj.set(REPEATMODE, (Object)interval);
            }
            obj.set(CYCLENUM, (Object)1);
            obj.set(TXTDESC, (Object)String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e%s\u91cd\u590d", (String)"DataCopyTaskUtil_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), DataCopyTaskUtil.getTxtdesc(obj, interval)));
        }
    }

    public static TimeSpan getTimeSpan(long startTime) {
        Date date = new Date(startTime);
        int startSeconds = D.i((Object)new SimpleDateFormat("ss").format(date));
        int startMinutes = D.i((Object)new SimpleDateFormat("mm").format(date));
        int startHours = D.i((Object)new SimpleDateFormat("HH").format(date));
        return new TimeSpan(startHours, startMinutes, startSeconds, 0);
    }

    public static String constructCron(String interval, TimeSpan timeSpan) {
        if (interval.equals("d")) {
            return "0 0 " + timeSpan.getHours() + " ? * *";
        }
        if (interval.equals("w")) {
            return "0 0 " + timeSpan.getHours() + " ? * MON";
        }
        if (interval.equals("m")) {
            return "0 0 " + timeSpan.getHours() + " 1 * ?";
        }
        if (interval.equals("d1")) {
            return "0 0 1 ? * *";
        }
        throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u9891\u7387\u8bbe\u7f6e\u6709\u8bef!", (String)"DataCopyTaskUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public static String getTxtdesc(DynamicObject schedule, String repeatMode) {
        ComboProp comboProp = (ComboProp)schedule.getDynamicObjectType().getProperty(REPEATMODE);
        List comboItems = comboProp.getComboItems();
        for (ValueMapItem item : comboItems) {
            if (!item.getValue().equalsIgnoreCase(repeatMode)) continue;
            return item.getName().toString();
        }
        return null;
    }

    private static DynamicObject disableSchedule(DynamicObject trigger) {
        DynamicObject schedule = trigger.getDynamicObject("job_schedule");
        if (schedule == null) {
            return null;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)schedule.getPkValue(), (String)ENTITY_SCH_SCHEDULE);
        obj.set(STATUS, (Object)"0");
        obj.set("name", (Object)ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u7531\u96c6\u6210\u4e91\u540e\u53f0\u521b\u5efa\uff0c\u6b64\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u4e25\u7981\u542f\u7528\uff0c\u8bf7\u4eba\u5de5\u5220\u9664\u3002", (String)"DataCopyTaskUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableSchedule((String)schedule.getPkValue());
        return obj;
    }

    private static int getMinutes(String interval) {
        if (interval.equals("0")) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49", (String)"DataCopyTaskUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        int minutes = 60 / D.i((Object)interval);
        return minutes;
    }

    private static Object getEndTime(DynamicObject trigger) {
        Object end = trigger.get("expired_time");
        if (end == null) {
            end = new Timestamp(System.currentTimeMillis() + 315360000000L);
        }
        return end;
    }

    private static Object getStartTime(DynamicObject trigger) {
        Object start = trigger.get("validated_time");
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachEvents(DynamicObject trigger) {
        DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("data_copy_id"), (String)"isc_data_copy");
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)schema.getLong("source_schema_id"), (String)"isc_metadata_schema");
        String entity = meta.getString("full_name");
        long triggerId = trigger.getLong(ID);
        long dataSourceId = schema.getLong("data_source_id");
        long redirect = trigger.getLong("new_source_system_id");
        if (redirect != 0L) {
            dataSourceId = redirect;
        }
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(schema));
        try (ConnectionWrapper cn = ConnectionManager.getConnection((Long)dataSource.get("dblink_id"));){
            String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
            cn.getFactory().detachEvents(cn, iscHub, EventBindingUtil.TriggerType.DataCopyTrigger, triggerId, entity);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachEvents(DynamicObject trigger) {
        String s = D.s((Object)trigger.get("events"));
        String[] events = s == null ? new String[]{} : s.split(",");
        DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("data_copy_id"), (String)"isc_data_copy");
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)schema.getLong("source_schema_id"), (String)"isc_metadata_schema");
        String entity = meta.getString("full_name");
        DynamicObjectCollection triggerFilterEntries = trigger.getDynamicObjectCollection("filter_entries");
        long triggerId = trigger.getLong(ID);
        Map<String, Object> requires = SQLUtil.prepareRequires(schema);
        SQLUtil.appendRequires(requires, triggerFilterEntries, "filter_column");
        long dataSourceId = schema.getLong("data_source_id");
        long redirect = trigger.getLong("new_source_system_id");
        if (redirect != 0L) {
            dataSourceId = redirect;
        }
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(schema));
        try (ConnectionWrapper cn = ConnectionManager.getConnection((Long)dataSource.get("dblink_id"));){
            String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
            cn.getFactory().attachEvents(cn, iscHub, EventBindingUtil.TriggerType.DataCopyTrigger, triggerId, entity, events, requires);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public static void updateDataCopyExecution(DynamicObject exe) {
        String sql = "UPDATE t_isc_data_copy_execution SET fend_time=?,fstate=?,ftotal_count=?,fsuccess_count=?,ffailed_count=?,fignored_count=?,fprepare_time=?,fread_time=?,fconvert_time=?,fload_time=?,fread_bytes=?,fload_bytes=?,fthread_count=?,fbatch_size=?,fexec_time=? WHERE fid = ?";
        List<Object> params = Arrays.asList(exe.get("end_time"), exe.get("state"), exe.get("total_count"), exe.get("success_count"), exe.get("failed_count"), exe.get("ignored_count"), exe.get("prepare_time"), exe.get("read_time"), exe.get("convert_time"), exe.get("load_time"), exe.get("read_bytes"), exe.get("load_bytes"), exe.get("thread_count"), exe.get("batch_size"), exe.get("exec_time"), exe.get(ID));
        List<Integer> types = Arrays.asList(93, 12, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 4, 4, -5);
        try {
            DataCopyTaskUtil.executeUpdate(sql, params, types);
        }
        catch (Exception e) {
            DataCopyTaskUtil.executeUpdate(sql, params, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeUpdate(String sql, List<Object> params, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static void checkCron(String cron) {
        if (StringUtils.isEmpty((String)cron)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DataCopyTaskUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try {
            new CronExpression(cron);
            DataCopyTaskUtil.getParser().parse(cron);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212(cron\u8868\u8fbe\u5f0f:%s)\u4e0d\u5408\u6cd5,\u8bf7\u68c0\u67e5\u662f\u5426\u7f16\u5199\u6b63\u786e\u3002", (String)"DataCopyTaskUtil_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cron), (Throwable)e);
        }
    }

    private static CronParser getParser() {
        return new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    }
}

