/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.dc.DataCopyJob;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.DataCopyTaskState;
import kd.isc.iscb.platform.core.dc.e.DataCopyRunner;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.params.Callback;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

class DataCopyThread
implements Task {
    private Callback callback;
    private DynamicObject execution;
    private long executionId;
    private DataCopyRunner runner;
    private String state = "C";
    private String number = "";
    private boolean first;
    private static final Random rnd = new Random();
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    @Override
    public String getId() {
        return String.valueOf(this.executionId);
    }

    public long getExecutionId() {
        return this.executionId;
    }

    DataCopyThread(long executionId, boolean first) {
        this.executionId = executionId;
        this.first = first;
    }

    @Override
    public void run() {
        try (DLock lock = DLock.create((String)("/isc/iscb/data_copy/" + this.executionId)).fastMode();){
            if (lock.tryLock()) {
                this.doDataCopy();
            } else {
                this.delay();
            }
        }
    }

    private void delay() {
        try {
            if (this.setWaiting()) {
                this.reschedule();
            }
        }
        catch (Throwable e) {
            this.handleUnexpectedError(e);
        }
    }

    private void doDataCopy() {
        try {
            this.init();
            if (this.runner.getParam().getMutex() == null) {
                this.doJob();
            } else {
                this.doMutexJob();
            }
        }
        catch (Throwable e) {
            if (e instanceof TaskCancelException) {
                throw e;
            }
            this.handleUnexpectedError(e);
        }
        finally {
            this.runner = null;
        }
    }

    private void doMutexJob() {
        String mutex = this.runner.getParam().getMutex();
        try (DLock lock = DLock.create((String)("/isc/iscb/data_copy/" + mutex)).fastMode();){
            if (lock.tryLock()) {
                this.doJob();
            } else if (this.setWaiting()) {
                this.reschedule();
            }
        }
    }

    private void reschedule() {
        Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + 15000L + (long)rnd.nextInt(10000));
        DynamicObject execution = this.getExecution();
        DataCopyJob job = new DataCopyJob(execution.getString("number"), false, this.executionId, this.first, execution.getLong("job_mutex_id"));
        JobEngine.submit(job, scheduledTime);
    }

    private boolean setWaiting() {
        if (DataCopyTaskState.setWaiting(this.executionId, this.state)) {
            this.state = "W";
            return true;
        }
        return false;
    }

    private void doJob() {
        if (DataCopyTaskState.setStarting(this.executionId, this.state, this.first)) {
            this.first = false;
            this.execute();
        }
    }

    private void handleUnexpectedError(Throwable e) {
        logger.warn("data_copy_exection_unexpected_failure. id=" + this.executionId + ", number=" + this.number, e);
        if (!DataCopyTaskState.setFailed(this.executionId)) {
            DataCopyThread.asyncTrySetFailed(this.executionId, this.execution, e);
        } else {
            DataCopyThread.saveError(e, this.executionId, this.execution);
        }
    }

    private static void asyncTrySetFailed(final long executionId, final DynamicObject execution, final Throwable error) {
        ScheduleManager.submit((Task)new LightTask(){
            private String id = UUID.randomUUID().toString();

            @Override
            public void run() {
                DataCopyTaskState.setFailed(executionId);
                DataCopyThread.saveError(error, executionId, execution);
            }

            @Override
            public String getId() {
                return this.id;
            }
        }, 3);
    }

    private static void saveError(Throwable e, long executionId, DynamicObject execution) {
        try {
            String s = StringUtil.toString((Throwable)e);
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy_exec_log");
            log.set("data_copy_execution", (Object)executionId);
            log.set("data_copy_trigger", execution == null ? null : execution.get("data_copy_trigger"));
            log.set("data_copy_schema", execution == null ? null : execution.get("data_copy_schama"));
            log.set("server_id", (Object)NetUtil.getServerId());
            log.set("created_time", (Object)new Date());
            log.set("message", (Object)DataCopyTask.trim(s));
            log.set("message_tag", s != null && s.length() > 290 ? s : null);
            log.set("state", (Object)(s == null ? "S" : "F"));
            OperationServiceHelper.executeOperate((String)"save", (String)"isc_data_copy_exec_log", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)OperateOption.create());
        }
        catch (Throwable err) {
            logger.warn("\u4fdd\u5b58\u9519\u8bef\u65e5\u5fd7\u51fa\u9519:", err);
        }
    }

    public boolean isRunning() {
        DataCopyRunner runner = this.runner;
        return runner == null ? false : runner.isRunning();
    }

    public DynamicObject getExecution() {
        if (this.execution == null) {
            this.execution = BusinessDataServiceHelper.loadSingle((Object)this.executionId, (String)"isc_data_copy_execution");
        }
        return this.execution;
    }

    public Counter getCounter() {
        DataCopyRunner runner = this.runner;
        return runner == null ? null : runner.getParam().getCounter();
    }

    private void execute() {
        block2: {
            ScheduleManager.submit((Task)new DataCopyTaskState(this.runner), 5);
            try {
                this.runner.run();
                DataCopyTask.setSuccess(this.runner.getParam(), this.callback);
            }
            catch (Throwable error) {
                this.errorHandle(this.execution, this.callback, this.runner, error);
                if (!(error instanceof TaskCancelException)) break block2;
                throw error;
            }
        }
    }

    private void init() {
        if (this.runner == null) {
            this.execution = BusinessDataServiceHelper.loadSingle((Object)this.executionId, (String)"isc_data_copy_execution");
            this.state = this.execution.getString("state");
            this.number = this.execution.getString("number");
            this.callback = DataCopyTask.getCallback(this.execution);
            this.runner = new DataCopyRunner(this.execution);
            this.first = D.i((Object)this.execution.get("execute_count")) <= 0;
        }
    }

    private void errorHandle(DynamicObject execution, Callback callback, DataCopyRunner runner, Throwable error) {
        DataCopyTask.saveErrorLog(runner.getParam(), error, null, null);
        int count = D.i((Object)execution.get("execute_count"));
        if (count + 1 > runner.getParam().getRetryCount() || error instanceof TaskCancelException || D.isError((Throwable)error)) {
            DataCopyTask.setFailed(runner.getParam(), error, callback, true);
        } else {
            DataCopyTask.setFailed(runner.getParam(), error, null, false);
            this.state = "F";
            long offset = Math.max(this.getRetryInterval(), 30000L);
            Timestamp scheduleTime = new Timestamp(System.currentTimeMillis() + offset);
            DataCopyTask.reschedule(execution, scheduleTime);
        }
    }

    private long getRetryInterval() {
        int[] retryIntervals = this.runner.getParam().getRetryIntervals();
        int length = retryIntervals.length;
        int count = Math.max(0, D.i((Object)this.execution.get("execute_count")));
        if (count >= length) {
            return (long)(retryIntervals[length - 1] * 60) * 1000L + (long)rnd.nextInt(30) - 15L;
        }
        return (long)(retryIntervals[count] * 60) * 1000L + (long)rnd.nextInt(30) - 15L;
    }

    public String toString() {
        return D.s((Object)(this.execution == null ? Long.valueOf(this.executionId) : this.execution.get("number")));
    }
}

