/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.io.ObjectReader;

public class DataStreamCleanerTask
implements Task {
    private String id = "DF_CLEAN:" + RequestContext.get().getAccountId();
    private static final int offset = 14400000;
    private static final int DELETE_BATCH_SIZE = 100;
    private static Log logger = LogFactory.getLog(DataStreamCleanerTask.class);

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isNotReady()) {
            return;
        }
        if (!JobEngine.isMaster()) {
            ScheduleManager.submit((Task)this, 60);
            return;
        }
        boolean exit = false;
        try {
            this.doCleanTask();
        }
        catch (Throwable e) {
            logger.warn("\u6570\u636e\u6d41\u6e05\u7406\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38", e);
            String message = e.getMessage();
            if (message != null) {
                exit = message.contains("doesn't exist") || message.contains("unknown");
            }
        }
        finally {
            if (!exit) {
                ScheduleManager.submit((Task)this, 14400000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanTask() {
        int keepDays;
        try {
            keepDays = D.i((Object)ContextUtil.getTenantProperty("ISCX_DF_LOGS_KEEP_DAYS"));
        }
        catch (Exception e) {
            keepDays = 7;
            logger.warn("\u6570\u636e\u6d41\u6e05\u7406\u65e5\u671f\u914d\u7f6e\u51fa\u9519\uff1a" + ContextUtil.getTenantProperty("ISCX_DF_LOGS_KEEP_DAYS"));
        }
        if (keepDays == 0) {
            keepDays = 7;
        }
        long now = System.currentTimeMillis();
        Timestamp value = new Timestamp(now - (long)keepDays * 86400000L);
        List<Object> values = Collections.singletonList(value);
        List<Integer> types = Collections.singletonList(93);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            int traces = this.deleteLogs(cn, "t_iscx_data_stream_trace", "ftime", values, types);
            int logs = this.deleteLogs(cn, "t_iscx_data_stream_log", "ftime", values, types);
            int streams = this.deleteLogs(cn, "t_iscx_datax_stream", "fmodifytime", values, types);
            logger.warn("\u6570\u636e\u6d41\u65e5\u5fd7\u5df2\u6210\u529f\u6e05\u7406\uff0c\u5176\u4e2d\u660e\u7ec6\u65e5\u5fd7" + traces + "\u6761,\u9519\u8bef\u65e5\u5fd7" + logs + "\u6761\uff0c\u6d41\u7a0b\u5b9e\u4f8b" + streams + "\u6761");
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private int deleteLogs(Connection cn, String tableName, String indexField, List<Object> values, List<Integer> types) {
        int deleted;
        int sum = 0;
        do {
            String sql = "SELECT top 100 fid FROM " + tableName + " WHERE " + indexField + " < ? ";
            deleted = this.deleteTop(cn, tableName, sql, values, types);
            sum += deleted;
        } while (deleted >= 100);
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteTop(Connection cn, String tableName, String sql, List<Object> values, List<Integer> types) {
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, values, types);
        try {
            ArrayList<Object> ids = new ArrayList<Object>(100);
            ArrayList<Integer> idTypes = new ArrayList<Integer>(100);
            StringBuilder whereSql = this.generateWhereSql(idTypes, (ObjectReader<DataRow>)reader, ids);
            if (ids.isEmpty()) {
                int n = 0;
                return n;
            }
            String removeSql = "DELETE FROM " + tableName + whereSql;
            int count = DbUtil.executeUpdate((Connection)cn, (String)removeSql, ids, idTypes);
            this.commit(cn);
            int n = count;
            return n;
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    private void commit(Connection cn) {
        try {
            if (cn != null && !cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            throw DatabaseError.TRANS_COMMIT_FAILURE.wrap((Throwable)e);
        }
    }

    private StringBuilder generateWhereSql(List<Integer> types, ObjectReader<DataRow> reader, List<Object> ids) {
        StringBuilder where = new StringBuilder(" WHERE fid in(");
        DataRow row = (DataRow)reader.read();
        while (row != null) {
            if (!ids.isEmpty()) {
                where.append(',');
            }
            ids.add(row.get((Object)"fid"));
            where.append('?');
            types.add(-5);
            row = (DataRow)reader.read();
        }
        where.append(')');
        return where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotReady() {
        boolean bl;
        Connection cn = null;
        try {
            String sql = "select count(*) as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_ISCX_DATAX_STREAM'";
            cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            bl = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql)) == 0;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)false);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)false);
        return bl;
    }
}

