/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.util.io.ObjectWriter;

public abstract class AbstractWriter
implements ObjectWriter<Map<String, Object>> {
    protected DataCopyConsumer param;
    private TC tc;

    public AbstractWriter(DataCopyConsumer param) {
        this.param = param;
        this.tc = new TC();
    }

    public final void close() {
        try {
            this.innerClose();
        }
        finally {
            this.tc.close();
        }
    }

    protected void innerClose() {
    }

    public boolean rollback(Throwable error) {
        return this.tc.rollback(error);
    }

    protected final void prepare() {
        this.tc.begin();
    }

    protected final void commitTransaction() {
        this.tc.commit();
    }

    private class TC {
        private boolean originalTrans;
        private boolean hasTrans = false;
        protected ConnectionWrapper cn;

        private TC() {
        }

        private void begin() {
            if (this.cn != null) {
                return;
            }
            this.cn = AbstractWriter.this.param.getTargetConnection();
            if (AbstractWriter.this.param.isRollbackOnError() && this.cn.supportsTransaction() && AbstractWriter.this.param.targetIsTable()) {
                this.originalTrans = this.cn.getAutoCommit();
                this.cn.setAutoCommit(false);
                this.hasTrans = true;
            }
        }

        private boolean rollback(Throwable error) {
            if (this.hasTrans) {
                this.cn.rollback();
            }
            return this.hasTrans;
        }

        private void commit() {
            if (this.hasTrans) {
                this.cn.commit();
            }
        }

        private void close() {
            if (this.hasTrans) {
                this.cn.setAutoCommit(this.originalTrans);
            }
        }
    }
}

