/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.InvokeAPI;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.self.BotpServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker2;
import kd.isc.iscb.platform.core.dc.BatchActionInvoker;
import kd.isc.iscb.platform.core.dc.e.AbstractWriter;
import kd.isc.iscb.platform.core.dc.e.ActionInvoker;
import kd.isc.iscb.platform.core.dc.e.ActionInvokerWithParams;
import kd.isc.iscb.platform.core.dc.e.DataBatchWriter;
import kd.isc.iscb.platform.core.dc.e.FlatObjectToMapOrList;
import kd.isc.iscb.platform.core.dc.e.ServiceInvoker;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.platform.core.fn.openapi.OpenAPIToolKit;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.s.ExecuteBatch;
import kd.isc.iscb.util.connector.s.ExecuteCall;
import kd.isc.iscb.util.connector.s.ExecuteUpdate;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.Script;

public class DataBatchScriptWriter
extends AbstractWriter {
    private static final ThreadLocal<List<Map<String, Object>>> batch = new ThreadLocal();
    private int batchSize;
    private Script targetScript;

    public DataBatchScriptWriter(DataCopyConsumer param) {
        super(param);
        int batchSize = param.getBatchSize();
        this.batchSize = Math.min(1000, batchSize <= 0 ? 50 : batchSize);
        param.getCounter().setBatchSize(this.batchSize);
        this.targetScript = param.getTargetDataScript();
    }

    public void write(Map<String, Object> data) {
        List<Map<String, Object>> batch = this.getBatch();
        batch.add(data);
        if (batch.size() >= this.batchSize) {
            this.flush();
        }
    }

    public void commit() {
        this.flush();
    }

    @Override
    protected void innerClose() {
        List<Map<String, Object>> batch = this.getBatch();
        if (batch.size() > 0) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5173\u95ed\u524d\u5fc5\u987b\u8c03\u7528 commit \u6216 rollback\u3002", (String)"DataBatchScriptWriter_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean rollback(Throwable error) {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> tar : batch) {
            this.param.saveTargetErrorLog(error, tar);
        }
        batch.clear();
        return false;
    }

    private List<Map<String, Object>> getBatch() {
        List<Map<String, Object>> list = batch.get();
        if (list == null) {
            list = new ArrayList<Map<String, Object>>();
            batch.set(list);
        }
        return list;
    }

    private void presetFailed() {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> data : batch) {
            data.put("$action", SaveDataType.FAILED);
        }
    }

    private void flush() {
        List<Map<String, Object>> batch = this.getBatch();
        if (batch.size() == 0) {
            return;
        }
        try {
            this.presetFailed();
            this.executeScript(batch);
        }
        catch (Throwable e) {
            DataBatchWriter.setFailed(batch, e);
            throw e;
        }
        finally {
            batch.clear();
        }
    }

    private void executeScript(List<Map<String, Object>> batch) {
        Map<String, Object> ctx = this.prepareContext(batch);
        this.targetScript.eval(ctx);
        String targetPrimaryKey = this.param.getTargetPrimaryKey();
        for (Map<String, Object> data : batch) {
            data.put("$id", this.getPkValue(data.get("id"), data.get(targetPrimaryKey)));
            String type = D.s((Object)data.get("type"));
            if (type != null) {
                data.put("$action", SaveDataType.valueOf((String)type));
                continue;
            }
            data.put("$action", SaveDataType.UNKNOWN);
        }
    }

    private Object getPkValue(Object id, Object pkVal) {
        Object val = pkVal != null ? pkVal : (id != null ? id : "");
        return val;
    }

    private Map<String, Object> prepareContext(List<Map<String, Object>> batch) {
        ConnectionWrapper cn = this.param.getTargetConnection();
        Map<String, Object> params = this.param.getFilterParams();
        String proxy_user = this.getProxyUser();
        return DataBatchScriptWriter.prepareContext(cn, batch, params, proxy_user);
    }

    public static Map<String, Object> prepareContext(ConnectionWrapper cn, List<Map<String, Object>> batch, Map<String, Object> params, String proxy_user) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(16);
        ctx.put("_tars", batch);
        ctx.put("$tar", cn);
        ctx.put("params", params);
        ctx.put("$service", new ServiceInvoker(cn, proxy_user));
        ctx.put("$action", new ActionInvoker(cn, proxy_user));
        ctx.put("$action2", new ActionInvokerWithParams(cn, proxy_user));
        ctx.put("$batch_action", new BatchActionInvoker(cn, proxy_user));
        ctx.put("invokeMicroService", new MicroServiceInvoker());
        ctx.put("IERP_BOTP", new BotpServiceInvoker());
        ctx.put("invokeMicroService2", new MicroServiceInvoker2());
        ctx.put("execute_update", new ExecuteUpdate(true));
        ctx.put("execute_call", new ExecuteCall());
        ctx.put("execute_batch", new ExecuteBatch());
        ctx.put("flatObjectToMapOrList", new FlatObjectToMapOrList());
        ctx.put("invoke_api", new InvokeAPI());
        OpenAPIToolKit openAPIToolKit = new OpenAPIToolKit();
        ctx.put(openAPIToolKit.name(), (Object)openAPIToolKit);
        return ctx;
    }

    private String getProxyUser() {
        List<Map<String, Object>> batch = this.getBatch();
        String proxy_user = null;
        for (Map<String, Object> data : batch) {
            String user = this.param.getProxyUser(data);
            if (proxy_user == null) {
                proxy_user = user;
                continue;
            }
            if (proxy_user.equals(user)) continue;
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5355\u6279\u6570\u636e\u53ea\u5141\u8bb8\u4f7f\u7528\u540c\u4e00\u4e2a\u4ee3\u7406\u7528\u6237\uff0c\u5f53\u524d\u4f7f\u7528\u4e86\u591a\u4e2a\u4ee3\u7406\u7528\u6237\uff08%1$s, %2$s\uff09", (String)"DataBatchScriptWriter_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), proxy_user, user));
        }
        return proxy_user;
    }
}

