/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.AbstractWriter;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class DataBatchWriter
extends AbstractWriter {
    private static final String ACTION = "$action";
    private static final ThreadLocal<List<Map<String, Object>>> batch = new ThreadLocal();
    private int batchSize;

    public DataBatchWriter(DataCopyConsumer param) {
        super(param);
        int batchSize = param.getBatchSize();
        this.batchSize = Math.min(3000, batchSize <= 0 ? 500 : batchSize);
        param.getCounter().setBatchSize(this.batchSize);
    }

    public void write(Map<String, Object> o) {
        List<Map<String, Object>> batch = this.getBatch();
        batch.add(o);
        if (batch.size() >= this.batchSize) {
            this.flush();
        }
    }

    private List<Map<String, Object>> getBatch() {
        List<Map<String, Object>> list = batch.get();
        if (list == null) {
            list = new ArrayList<Map<String, Object>>();
            batch.set(list);
        }
        return list;
    }

    private void flush() {
        List<Map<String, Object>> batch = this.getBatch();
        if (batch.size() == 0) {
            return;
        }
        try {
            this.presetFailed();
            this.prepare();
            if (this.isBatchUpsert()) {
                this.doBatchUpsert();
            } else {
                ArrayList<Map<String, Object>> for_insert = new ArrayList<Map<String, Object>>();
                ArrayList<Map<String, Object>> for_update = new ArrayList<Map<String, Object>>();
                this.classifyTargets(for_insert, for_update);
                this.doBatchAction(for_insert, for_update);
            }
        }
        catch (Throwable e) {
            DataBatchWriter.setFailed(batch, e);
            throw e;
        }
        finally {
            batch.clear();
        }
    }

    private void doBatchUpsert() {
        Table table = this.param.getTargetTable();
        List primaryKeys = table.getPrimaryKeys();
        if (primaryKeys.isEmpty()) {
            String msg = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u8868[%1$s]\u4e0d\u5b58\u5728\u4e3b\u952e\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u6279\u91cfupsert\u64cd\u4f5c\uff0c\u8bf7\u8c03\u6574\u8868\u7ed3\u6784\u521b\u5efa\u597d\u4e3b\u952e\u540e\u518d\u91cd\u65b0\u5c1d\u8bd5\u3002", (String)"DataBatchWriter_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), table.getName());
            throw new IllegalArgumentException(msg);
        }
        List<String> judgeFields = this.param.getJudgeFields();
        List<Map<String, Object>> batch = this.getBatch();
        List<Column> fields = DataBatchWriter.findParams(table, batch.get(0));
        ConnectionWrapper cn = this.param.getTargetConnection();
        cn.getFactory().doBatchUpsert(cn, table, fields, judgeFields, batch);
        for (Map<String, Object> data : batch) {
            data.put(ACTION, SaveDataType.SAVE);
        }
    }

    public static List<Column> findParams(Table table, Map<String, Object> row) {
        ArrayList<Column> fields = new ArrayList<Column>(row.size());
        for (String name : row.keySet()) {
            if (!table.hasField(name)) continue;
            fields.add(table.getField(name));
        }
        return fields;
    }

    private boolean isBatchUpsert() {
        List<String> actions = this.param.getTargetActions();
        if (actions != null && actions.size() == 1) {
            String actionName = actions.get(0);
            return TableAction._UPSERT.name().equals(actionName);
        }
        return false;
    }

    private void doBatchAction(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        List<String> actions = this.param.getTargetActions();
        String action = actions.isEmpty() ? "_SAVE" : actions.get(0);
        TableAction tableAction = TableAction.valueOf((String)action);
        switch (tableAction) {
            case _SAVE: {
                this.batchInsert(for_insert);
                this.batchUpdate(for_update);
                break;
            }
            case _INSERT: {
                this.batchInsert(for_insert);
                this.batchIgnore(for_update);
                break;
            }
            case _UPDATE: {
                this.batchUpdate(for_update);
                this.batchIgnore(for_insert);
                break;
            }
            case _DELETE: {
                throw new IscBizException("TODO\uff1a" + tableAction);
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a%s", (String)"DataBatchWriter_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tableAction));
            }
        }
    }

    private void batchIgnore(List<Map<String, Object>> ignoreDataList) {
        if (!ignoreDataList.isEmpty()) {
            for (Map<String, Object> data : ignoreDataList) {
                data.put(ACTION, SaveDataType.NOP);
            }
        }
    }

    static void setFailed(List<Map<String, Object>> batch, Throwable e) {
        String error = ResManager.loadKDString((String)"\u6279\u5904\u7406\u5931\u8d25", (String)"DataBatchWriter_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        for (Map<String, Object> item : batch) {
            item.put("$error_message", error);
        }
    }

    private void presetFailed() {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> data : batch) {
            data.put(ACTION, SaveDataType.FAILED);
        }
    }

    private void batchUpdate(List<Map<String, Object>> for_update) {
        if (for_update.size() == 0) {
            return;
        }
        HashSet<String> columns = new HashSet<String>();
        Table table = this.param.getTargetTable();
        for (String string : this.param.getTargetFields("")) {
            if (!table.hasField(string)) continue;
            columns.add(string);
        }
        columns.removeAll(this.param.getJudgeFields());
        this.removePrimaryKeys(columns);
        if (columns.size() == 0) {
            for (Map map : for_update) {
                map.put(ACTION, SaveDataType.NOP);
            }
            return;
        }
        String[] fields = columns.toArray(new String[columns.size()]);
        ConnectionWrapper connectionWrapper = this.param.getTargetConnection();
        Table tar_table = this.param.getTargetTable();
        List<Column> judgeFields = this.getJudgeFields(tar_table);
        Column judgeField = tar_table.findField(this.param.getJudgeField());
        DataBatchWriter.batchUpdate(connectionWrapper, tar_table, for_update, fields, judgeFields, judgeField);
        for (Map<String, Object> data : for_update) {
            data.put(ACTION, SaveDataType.UPDATE);
        }
    }

    public static void batchUpdate(ConnectionWrapper cn, Table tar_table, Collection<? extends Map<String, Object>> for_update, String[] fields, List<Column> judgeFields, Column judgeField) {
        if (for_update.isEmpty()) {
            return;
        }
        String sql = DataBatchWriter.prepareUpdateSQL(tar_table, judgeFields, judgeField, fields);
        List<Column> params = DataBatchWriter.prepareParamFields(tar_table, judgeFields, judgeField, fields);
        List<List<Object>> batch = DataBatchWriter.prepareBatchForUpdate(for_update, params);
        List<Integer> types = DataBatchWriter.prepareParamTypes(params);
        cn.executeBatch(sql, batch, types);
    }

    private static List<Integer> prepareParamTypes(List<Column> params) {
        ArrayList<Integer> types = new ArrayList<Integer>(params.size());
        for (Column f : params) {
            types.add(f.getSqlType());
        }
        return types;
    }

    private static List<List<Object>> prepareBatchForUpdate(Collection<? extends Map<String, Object>> for_update, List<Column> params) {
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>(for_update.size());
        for (Map<String, Object> map : for_update) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            for (Column f : params) {
                Object value = TableUtil.getValue(map, (Column)f);
                row.add(value);
            }
            batch.add(row);
        }
        return batch;
    }

    private static List<Column> prepareParamFields(Table tar_table, List<Column> judgeFields, Column judgeField, String[] fields) {
        int i;
        ArrayList<Column> params = new ArrayList<Column>(fields.length + judgeFields.size());
        for (i = 0; i < fields.length; ++i) {
            Column f = tar_table.getField(fields[i]);
            params.add(f);
        }
        if (judgeField != null) {
            params.add(judgeField);
        } else {
            for (i = 0; i < judgeFields.size(); ++i) {
                Column c = judgeFields.get(i);
                params.add(c);
            }
        }
        return params;
    }

    private static String prepareUpdateSQL(Table tar_table, List<Column> judgeFields, Column judgeField, String[] fields) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tar_table.getQuotedName()).append(" SET ");
        for (i = 0; i < fields.length; ++i) {
            String name = fields[i];
            Column c = tar_table.getField(name);
            if (i > 0) {
                sql.append(',');
            }
            sql.append(c.getBinding()).append("=?");
        }
        sql.append(" WHERE ");
        if (judgeField != null) {
            sql.append(judgeField.getBinding()).append("=?");
        } else {
            for (i = 0; i < judgeFields.size(); ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(judgeFields.get(i).getBinding()).append("=?");
            }
        }
        return sql.toString();
    }

    private void removePrimaryKeys(Set<String> columns) {
        Table table = this.param.getTargetTable();
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Column c = table.getField(i);
            if (!c.isPrimaryKey()) continue;
            columns.remove(c.getName());
        }
    }

    private void batchInsert(List<Map<String, Object>> for_insert) {
        if (for_insert.size() == 0) {
            return;
        }
        Table tar_table = this.param.getTargetTable();
        ConnectionWrapper cn = this.param.getTargetConnection();
        DataBatchWriter.batchInsert(cn, tar_table, for_insert);
        for (Map<String, Object> data : for_insert) {
            data.put(ACTION, SaveDataType.INSERT);
        }
    }

    public static void batchInsert(ConnectionWrapper cn, Table tar_table, List<? extends Map<String, Object>> for_insert) {
        if (for_insert.isEmpty()) {
            return;
        }
        Map<String, Object> firstRow = for_insert.get(0);
        if (TableUtil.useStrict(firstRow)) {
            List fields = TableUtil.selectFields((Table)tar_table, firstRow);
            DataBatchWriter.insertWithFields(cn, tar_table, for_insert, fields);
        } else {
            DataBatchWriter.insertWithAllFields(cn, tar_table, for_insert);
        }
    }

    private static void insertWithAllFields(ConnectionWrapper cn, Table tar_table, List<? extends Map<String, Object>> for_insert) {
        String sql = TableUtil.prepareInsertSQL((Table)tar_table);
        ArrayList<Column> params = new ArrayList<Column>(tar_table.getFieldCount());
        ArrayList<Integer> types = new ArrayList<Integer>(tar_table.getFieldCount());
        for (int i = 0; i < tar_table.getFieldCount(); ++i) {
            Column f = tar_table.getField(i);
            params.add(f);
            types.add(f.getSqlType());
        }
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>(for_insert.size());
        for (Map<String, Object> map : for_insert) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            for (Column f : params) {
                Object value = TableUtil.getValue(map, (Column)f);
                row.add(value);
            }
            batch.add(row);
        }
        cn.executeBatch(sql, batch, types);
    }

    private static void insertWithFields(ConnectionWrapper cn, Table tar_table, List<? extends Map<String, Object>> for_insert, List<String> fields) {
        String sql = TableUtil.prepareInsertSQL((Table)tar_table, fields);
        ArrayList<Column> params = new ArrayList<Column>(tar_table.getFieldCount());
        ArrayList<Integer> types = new ArrayList<Integer>(tar_table.getFieldCount());
        for (String name : fields) {
            Column column = tar_table.getField(name);
            params.add(column);
            types.add(column.getSqlType());
        }
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>(for_insert.size());
        for (Map<String, Object> map : for_insert) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            for (Column f : params) {
                Object value = TableUtil.getValue(map, (Column)f);
                row.add(value);
            }
            batch.add(row);
        }
        cn.executeBatch(sql, batch, types);
    }

    private void classifyTargets(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        if (this.param.getJudgeField() != null) {
            this.handleOneKey(for_insert, for_update);
        } else {
            this.handleMultiKey(for_insert, for_update);
        }
    }

    private void handleMultiKey(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        Table table = this.param.getTargetTable();
        List<Column> fields = this.getJudgeFields(table);
        List<Map<String, Object>> batch = this.getBatch();
        ConnectionWrapper cn = this.param.getTargetConnection();
        cn.classify(table, batch, fields, for_insert, for_update);
    }

    private List<Column> getJudgeFields(Table table) {
        ArrayList<Column> fields = new ArrayList<Column>();
        for (String name : this.param.getJudgeFields()) {
            Column field = table.getField(name);
            if (field != null) {
                fields.add(field);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5\uff08%1$s\uff09\u5728\u6570\u636e\u8868\uff08%2$s\uff09\u4e2d\u4e0d\u5b58\u5728\uff01", (String)"DataBatchWriter_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, table));
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOneKey(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        Table tar_table = this.param.getTargetTable();
        String key_field = this.param.getJudgeField();
        Column key_column = tar_table.getField(key_field);
        Map<Object, Map<String, Object>> id_mapping = this.constructKeyMapping(key_field, key_column);
        try (ObjectReader<DataRow> reader = this.queryExistsKeys(id_mapping, tar_table, key_column);){
            DataRow item = (DataRow)reader.read();
            while (item != null) {
                Map<String, Object> data = id_mapping.remove(item.getValue(0));
                if (data != null) {
                    for_update.add(data);
                }
                item = (DataRow)reader.read();
            }
            for_insert.addAll(id_mapping.values());
        }
    }

    private ObjectReader<DataRow> queryExistsKeys(Map<Object, Map<String, Object>> id_mapping, Table tar_table, Column key_column) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>(id_mapping.keySet());
        String sql = this.generateJudgeSQL(tar_table, key_column, id_mapping, types);
        ObjectReader<DataRow> reader = this.param.getTargetConnection().executeQuery(sql, values, types);
        return reader;
    }

    private Map<Object, Map<String, Object>> constructKeyMapping(String key_field, Column key_column) {
        List<Map<String, Object>> batch = this.getBatch();
        HashMap<Object, Map<String, Object>> id_mapping = new HashMap<Object, Map<String, Object>>(batch.size());
        for (Map<String, Object> data : batch) {
            Object value = data.get(key_field);
            Map<String, Object> dup = id_mapping.put(key_column.narrow(value), data);
            if (dup == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b57\u6bb5\uff08%s\uff09\u5bf9\u76ee\u6807\u6570\u636e\u8fdb\u884c\u552f\u4e00\u6027\u68c0\u67e5\uff0c\u53d1\u73b0\u5176\u4e2d\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u4e2d\u9009\u62e9\u7684\u5019\u9009\u952e\u5b57\u6bb5\u3002", (String)"DataBatchWriter_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key_field));
        }
        return id_mapping;
    }

    private String generateJudgeSQL(Table tar_table, Column key_column, Map<Object, Map<String, Object>> id_mapping, List<Integer> types) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(key_column.getBinding());
        sb.append(" from ");
        sb.append(tar_table.getQuotedName());
        sb.append(" where ");
        sb.append(key_column.getBinding());
        sb.append(" in ( ");
        for (int i = 0; i < id_mapping.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            types.add(key_column.getSqlType());
            sb.append(" ? ");
        }
        sb.append(')');
        String sql = sb.toString();
        return sql;
    }

    @Override
    protected void innerClose() {
        List<Map<String, Object>> batch = this.getBatch();
        if (batch.size() > 0) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5173\u95ed\u524d\u5fc5\u987b\u8c03\u7528 commit \u6216 rollback\u3002", (String)"DataBatchWriter_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    public void commit() {
        this.flush();
        this.commitTransaction();
    }

    @Override
    public boolean rollback(Throwable error) {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> tar : batch) {
            this.param.saveTargetErrorLog(error, tar);
        }
        batch.clear();
        return super.rollback(error);
    }
}

