/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.AttachUtil;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyAttachLog;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.TempByteArrayInputStream;
import kd.isc.iscb.platform.core.dc.e.TempFileInputStream;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.io.AbstractInputStream;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCopyAttachment {
    private static Log logger = LogFactory.getLog(DataCopyAttachment.class);
    private static final String TAR_ATTACH = "tar_attach";
    private static final String SRC_ATTACH = "src_attach";
    private static final String STATE = "state";
    private static final String PROGRESS = "progress";
    private static final String UPDATED_TIME = "updated_time";
    private static final String MD5 = "MD5";
    private static final String ISC_ATTACHMENT_STR = "isc_attachment";
    private static final String SRC_OID_STR = "src_oid";
    private static final String END_TIME_STR = "end_time";
    private static final String CHECKFILEID = "checkFileId";
    private static final int MAX_LEN = 20;
    private static final long TIME_WAIT = 5000L;

    private DataCopyAttachment() {
    }

    public static void registerLine(DataCopyParam param) {
        if (param.supportsFileCopy()) {
            DataCopyDebugger.registerLine(param, "file_handle", ResManager.loadKDString((String)"\u9644\u4ef6\u4f20\u8f93\u5904\u7406", (String)"DataCopyAttachment_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    public static void handleAttachmentFile(DataCopyParam param, Map<String, Object> src) {
        if (!DataCopyAttachment.hasAttachFile(param, src)) {
            return;
        }
        DataCopyDebugger.trap(param, "file_handle", src, null);
        List fileList = (List)src.get("$file_list");
        for (Map fileInfo : fileList) {
            DataCopyAttachment.appendExtendInfo(param, fileInfo);
            DataCopyAttachment.handleEachAttachFile(param, src, fileInfo);
        }
    }

    private static void appendExtendInfo(DataCopyParam param, Map<String, Object> fileInfo) {
        if (param.useSrcAttachCreateTime()) {
            fileInfo.put("attachCreateTime", fileInfo.get("srcAttachCreateTime"));
        }
        String srcAttachCreatorId = D.s((Object)fileInfo.get("srcAttachCreator"));
        fileInfo.put("attachCreator", param.evalTargetAttachCreator(srcAttachCreatorId));
    }

    private static void handleEachAttachFile(DataCopyParam param, Map<String, Object> src, Map<String, Object> fileInfo) {
        DynamicObject attachInfo = DataCopyAttachment.saveAttachInfo(param, src, fileInfo);
        DynamicObject attachLog = DataCopyAttachLog.saveAttachLog(param, attachInfo);
        try {
            DataCopyAttachment.innerHandleFile(param, fileInfo, attachInfo, attachLog);
        }
        catch (Throwable e) {
            DataCopyAttachment.setLogError(attachLog, e);
            throw e;
        }
    }

    private static void setLogError(DynamicObject attachLog, Throwable e) {
        String s = StringUtil.toString((Throwable)e);
        attachLog.set("error", (Object)(s.substring(0, 20) + "..."));
        attachLog.set("error_tag", (Object)s);
        attachLog.set(STATE, (Object)Character.valueOf('F'));
        attachLog.set(END_TIME_STR, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachLog});
    }

    private static void setLogRunning(DynamicObject attachLog) {
        DataCopyAttachment.setLogState(attachLog, 'R', "start_time");
    }

    private static void innerHandleFile(DataCopyParam param, Map<String, Object> fileInfo, DynamicObject attachInfo, DynamicObject attachLog) {
        DataCopyAttachment.setLogRunning(attachLog);
        boolean isFileChanged = DataCopyAttachment.isFileChanged(param, fileInfo, attachInfo);
        if (isFileChanged) {
            DataCopyAttachment.handleChangedFile(param, fileInfo, attachInfo, attachLog);
        } else {
            DataCopyAttachment.setLogIgnored(attachLog);
        }
    }

    private static void setLogIgnored(DynamicObject attachLog) {
        DataCopyAttachment.setLogState(attachLog, 'I', END_TIME_STR);
    }

    private static void handleChangedFile(DataCopyParam param, Map<String, Object> fileInfo, DynamicObject attachInfo, DynamicObject attachLog) {
        ConnectionWrapper sourceConnection = param.getSourceConnection();
        ConnectionWrapper targetConnection = param.getTargetConnection();
        AbstractInputStream inputStream = null;
        AbstractOutputStream outputStream = null;
        MessageDigest md5 = DataCopyAttachment.getMd5Instance();
        String totalBytes = D.s((Object)fileInfo.get("bytes"));
        try {
            int len;
            inputStream = DataCopyAttachment.getInputStream(fileInfo, sourceConnection);
            outputStream = targetConnection.getFactory().getAttachmentWriter(targetConnection, fileInfo);
            int bytes = 0;
            byte[] data = new byte[524288];
            long start = System.currentTimeMillis();
            while ((len = inputStream.read(data)) > -1) {
                SignalManager.checkCancelSignal();
                bytes += len;
                outputStream.write(data, 0, len);
                md5.update(data, 0, len);
                long now = System.currentTimeMillis();
                if (now - start < 5000L) continue;
                start = now;
                DataCopyAttachment.refreshProgress(attachLog, bytes, totalBytes);
            }
        }
        catch (Throwable e) {
            try {
                DataCopyAttachment.markStreamError(inputStream, outputStream);
                throw D.e((Throwable)e);
            }
            catch (Throwable throwable) {
                DataCopyAttachment.closeStream(inputStream, outputStream);
                throw throwable;
            }
        }
        DataCopyAttachment.closeStream(inputStream, outputStream);
        DataCopyAttachment.updateMd5AndTargetAttachId(attachInfo, Hex.encode((byte[])md5.digest()), outputStream.getAttachmentId());
        fileInfo.put("tarAttachId", outputStream.getAttachmentId());
        DataCopyAttachment.setLogSuccess(attachLog, totalBytes);
    }

    private static AbstractInputStream getInputStream(Map<String, Object> fileInfo, ConnectionWrapper cn) throws Throwable {
        try (AbstractInputStream in = cn.getFactory().getAttachmentReader(cn, fileInfo);){
            int size = D.i((Object)fileInfo.get("bytes"));
            if (size > AttachUtil.getTempFileSize()) {
                String type = D.s((Object)fileInfo.get("type"));
                TempFileInputStream tempFileInputStream = new TempFileInputStream(in, type);
                return tempFileInputStream;
            }
            TempByteArrayInputStream tempByteArrayInputStream = new TempByteArrayInputStream(in, size);
            return tempByteArrayInputStream;
        }
    }

    private static MessageDigest getMd5Instance() {
        try {
            return MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create((Throwable)e, new String[]{MD5});
        }
    }

    private static void markStreamError(AbstractInputStream inputStream, AbstractOutputStream outputStream) {
        if (inputStream != null) {
            inputStream.markError();
        }
        if (outputStream != null) {
            outputStream.markError();
        }
    }

    private static void setLogSuccess(DynamicObject attachLog, String totalBytes) {
        attachLog.set(PROGRESS, (Object)(totalBytes + "/" + totalBytes));
        DataCopyAttachment.setLogState(attachLog, 'S', END_TIME_STR);
    }

    private static void refreshProgress(DynamicObject attachLog, int bytes, String totalBytes) {
        attachLog.set(PROGRESS, (Object)(bytes + "/" + totalBytes));
        attachLog.set(UPDATED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachLog});
    }

    private static void setLogState(DynamicObject attachLog, char state, String timeField) {
        attachLog.set(STATE, (Object)Character.valueOf(state));
        attachLog.set(timeField, (Object)new Timestamp(System.currentTimeMillis()));
        attachLog.set(UPDATED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachLog});
    }

    private static void closeStream(AbstractInputStream inputStream, AbstractOutputStream outputStream) {
        Throwable inputEx = DataCopyAttachment.closeInputStream(inputStream);
        Throwable outputEx = DataCopyAttachment.closeOutputStream(outputStream);
        if (inputEx != null || outputEx != null) {
            if (inputEx != null && outputEx != null) {
                inputEx.addSuppressed(outputEx);
                throw D.e((Throwable)inputEx);
            }
            if (inputEx != null) {
                throw D.e((Throwable)inputEx);
            }
            throw D.e((Throwable)outputEx);
        }
    }

    private static Throwable closeOutputStream(AbstractOutputStream outputStream) {
        Throwable outputEx = null;
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Throwable e) {
                logger.error("\u5173\u95ed\u9644\u4ef6\u8f93\u51fa\u6d41\u5931\u8d25\uff1a", e);
                outputEx = e;
            }
        }
        return outputEx;
    }

    private static Throwable closeInputStream(AbstractInputStream inputStream) {
        Throwable inputEx = null;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable e) {
                logger.error("\u5173\u95ed\u9644\u4ef6\u8f93\u5165\u6d41\u5931\u8d25\uff1a", e);
                inputEx = e;
            }
        }
        return inputEx;
    }

    private static boolean isFileChanged(DataCopyParam param, Map<String, Object> fileInfo, DynamicObject attachInfo) {
        boolean isFileChanged;
        String md5Code = attachInfo.getString("md5_code");
        String srcAttach = attachInfo.getString(SRC_ATTACH);
        String tarAttach = attachInfo.getString(TAR_ATTACH);
        if (StringUtil.isEmpty((String)md5Code) || StringUtil.isEmpty((String)srcAttach) || StringUtil.isEmpty((String)tarAttach)) {
            isFileChanged = true;
        } else {
            fileInfo.put(CHECKFILEID, srcAttach);
            ConnectionWrapper sourceConnection = param.getSourceConnection();
            isFileChanged = sourceConnection.getFactory().isAttachmentChanged(sourceConnection, fileInfo, md5Code);
            if (!isFileChanged) {
                ConnectionWrapper targetConnection = param.getTargetConnection();
                fileInfo.put(CHECKFILEID, tarAttach);
                isFileChanged = targetConnection.getFactory().isAttachmentChanged(targetConnection, fileInfo, md5Code);
            }
            fileInfo.remove(CHECKFILEID);
        }
        return isFileChanged;
    }

    private static void updateMd5AndTargetAttachId(DynamicObject attachInfo, String md5Str, String targetAttachId) {
        attachInfo.set("md5_code", (Object)md5Str);
        attachInfo.set(TAR_ATTACH, (Object)targetAttachId);
        attachInfo.set(UPDATED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.update((DynamicObject)attachInfo);
    }

    private static boolean hasAttachFile(DataCopyParam param, Map<String, Object> src) {
        String srcOid = D.s((Object)src.get(param.getSourcePrimaryKey()));
        List fileList = (List)src.get("$file_list");
        return srcOid != null && !CollectionUtils.isEmpty(fileList);
    }

    private static DynamicObject saveAttachInfo(DataCopyParam param, Map<String, Object> src, Map<String, Object> fileInfo) {
        String srcOid = D.s((Object)src.get(param.getSourcePrimaryKey()));
        QFilter qfilter = new QFilter(SRC_OID_STR, "=", (Object)srcOid);
        qfilter.and(SRC_ATTACH, "=", (Object)D.s((Object)fileInfo.get("srcAttachId")));
        qfilter.and("src_cn", "=", param.getSourceConnection().getConfig().get("id"));
        qfilter.and("tar_cn", "=", param.getTargetConnection().getConfig().get("id"));
        DynamicObject attachInfo = BusinessDataServiceHelper.loadSingle((String)ISC_ATTACHMENT_STR, (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (attachInfo == null) {
            String srcNumber = D.s((Object)src.get("number"));
            attachInfo = DataCopyAttachment.initAttachInfo(param, fileInfo, srcOid, srcNumber);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachInfo});
        } else {
            attachInfo = BusinessDataServiceHelper.loadSingle((Object)attachInfo.get("id"), (String)ISC_ATTACHMENT_STR);
            fileInfo.put("tarAttachId", attachInfo.getString(TAR_ATTACH));
        }
        fileInfo.put("tarEntity", param.getTargetSchema().getString("full_name"));
        return attachInfo;
    }

    private static DynamicObject initAttachInfo(DataCopyParam param, Map<String, Object> fileInfo, String srcOid, String srcNumber) {
        DynamicObject attachInfo = BusinessDataServiceHelper.newDynamicObject((String)ISC_ATTACHMENT_STR);
        attachInfo.set("src_cn", param.getSourceConnection().getConfig().get("id"));
        attachInfo.set("tar_cn", param.getTargetConnection().getConfig().get("id"));
        attachInfo.set(SRC_OID_STR, (Object)srcOid);
        attachInfo.set("src_number", (Object)StringUtil.trim((String)srcNumber, (int)50));
        attachInfo.set("src_table", (Object)param.getSourceTableName());
        attachInfo.set(SRC_ATTACH, fileInfo.get("srcAttachId"));
        attachInfo.set("file_name", fileInfo.get("name"));
        attachInfo.set("file_type", fileInfo.get("type"));
        attachInfo.set("file_desc", fileInfo.get("desc"));
        attachInfo.set("bytes", fileInfo.get("bytes"));
        attachInfo.set("f1", fileInfo.get("f1"));
        attachInfo.set("f2", fileInfo.get("f2"));
        attachInfo.set("f3", fileInfo.get("attachCreator"));
        attachInfo.set("src_att_creator", (Object)D.s((Object)fileInfo.get("srcAttachCreator")));
        attachInfo.set("src_att_creator_num", (Object)D.s((Object)fileInfo.get("srcAttachCreatorNum")));
        attachInfo.set("src_att_create_time", (Object)D.t((Object)fileInfo.get("srcAttachCreateTime")));
        attachInfo.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        attachInfo.set(UPDATED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        return attachInfo;
    }
}

