/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebuggableRuntime;
import kd.isc.iscb.util.debugger.DebugCoordinator;
import kd.isc.iscb.util.debugger.DebuggableResource;
import kd.isc.iscb.util.debugger.DebuggableRuntime;
import kd.isc.iscb.util.debugger.DebuggerAction;

public class DataCopyDebuggableResource
implements DebuggableResource {
    private List<Line> lines = new ArrayList<Line>();
    private Map<String, Integer> breakpoints = new HashMap<String, Integer>();
    private String id;

    public DataCopyDebuggableResource(String id) {
        this.id = id;
    }

    public String getResourceId() {
        return this.id;
    }

    public boolean attachBreakpoint(int line) {
        Line e = this.lines.get(line - 1);
        this.breakpoints.put(e.step, line);
        if (e.action != null) {
            e.action.onAttachBreakpoint();
        }
        return true;
    }

    public void detachBreakpoint(int line) {
        Line e = this.lines.get(line - 1);
        this.breakpoints.remove(e.step);
        if (e.action != null) {
            e.action.onDetachBreakpoint();
        }
    }

    public Set<Integer> collectBreakpoints() {
        return new HashSet<Integer>(this.breakpoints.values());
    }

    public String getLine(int line) {
        Line e = this.lines.get(line - 1);
        if (e.step.length() == 0) {
            return e.text;
        }
        if ("source_data_query".equals(e.step)) {
            return e.text + ";";
        }
        return "    " + e.text + ";";
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public void debugTrap(String step, Map<String, Object> params, Map<String, Object> src, Map<String, Object> tar) {
        DebugCoordinator c = (DebugCoordinator)DebugCoordinator.REF.get();
        if (!c.isDebuggerEnabled()) {
            return;
        }
        Integer line = this.breakpoints.get(step);
        if (line != null) {
            DataCopyDebuggableRuntime runtime = new DataCopyDebuggableRuntime(this, params, src, tar);
            c.handleBreakpoint((DebuggableRuntime)runtime, line.intValue(), this.collectBreakpoints());
        }
    }

    public void registerLine(String step, String text) {
        this.lines.add(new Line(step, text));
    }

    public void registerLine(String step, String text, DebuggerAction action) {
        this.lines.add(new Line(step, text, action));
    }

    private static class Line {
        private String step;
        private String text;
        private DebuggerAction action;

        private Line(String step, String text) {
            this.step = step;
            this.text = text;
        }

        private Line(String step, String text, DebuggerAction action) {
            this.step = step;
            this.text = text;
            this.action = action;
        }
    }
}

