/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.Map;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebuggableResource;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.dt.D;

public class DataCopyDebugger {
    private static final ThreadLocal<Boolean> debug_enabled = new ThreadLocal();

    public static String decorateNumber(String number) {
        if (D.x((Object)debug_enabled.get())) {
            number = number.substring(0, number.length() - 6) + "#DEBUG";
        }
        return number;
    }

    public static boolean isDebug(String executionNumber) {
        if (executionNumber == null) {
            return false;
        }
        return executionNumber.endsWith("#DEBUG");
    }

    public static void trap(Object dataCopyParam, String step, Map<String, Object> src, Map<String, Object> tar) {
        if (dataCopyParam instanceof DataCopyParam) {
            DataCopyParam param = (DataCopyParam)dataCopyParam;
            DataCopyDebuggableResource res = param.getDebuggableResource();
            res.debugTrap(step, param.getFilterParamsForDebug(), src, tar);
        }
    }

    public static void attachBreakpoints(DataCopyParam param) {
        if (param.isDebug()) {
            param.getDebuggableResource().attachBreakpoint(2);
        }
    }

    public static void registerLine(DataCopyParam dataCopyParam, String step, String text) {
        DataCopyDebuggableResource res = dataCopyParam.getDebuggableResource();
        res.registerLine(step, text);
    }

    public static void registerLine(DataCopyParam dataCopyParam, String step, String text, DebuggerAction action) {
        DataCopyDebuggableResource res = dataCopyParam.getDebuggableResource();
        res.registerLine(step, text, action);
    }

    public static void setDebug(boolean debug) {
        debug_enabled.set(debug);
    }

    public static void unsetDebug() {
        debug_enabled.remove();
    }
}

