/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ischub.EventUtil;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyMessageSender;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.Json;

public class DataCopyEvent {
    private Consumer consumer;
    private String handler;

    public DataCopyEvent(Consumer consumer, String handler) {
        this.consumer = consumer;
        this.handler = handler;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public String getHandler() {
        return this.handler;
    }

    private static Map<String, Object> cloneMapWithoutEntryVals(Map<String, Object> data) {
        HashMap<String, Object> cloneMap = new HashMap<String, Object>(data.size());
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getValue() instanceof List) continue;
            cloneMap.put(entry.getKey(), entry.getValue());
        }
        return cloneMap;
    }

    public static enum Consumer {
        SourceSystem{

            @Override
            protected ConnectionWrapper getConnection(DataCopyParam param) {
                return param.getSourceConnection();
            }
        }
        ,
        TargetSystem{

            @Override
            protected ConnectionWrapper getConnection(DataCopyParam param) {
                return param.getTargetConnection();
            }
        }
        ,
        ThisSystem{

            @Override
            protected ConnectionWrapper getConnection(DataCopyParam param) {
                return param.getThisConnection();
            }
        };


        protected abstract ConnectionWrapper getConnection(DataCopyParam var1);

        protected void raiseEvent(DataCopyParam param, String handler, Map<String, Object> data) {
            try {
                ConnectionWrapper cn = this.getConnection(param);
                cn.getFactory().raiseEvent(cn, handler, data);
            }
            catch (Throwable error) {
                DataCopyTask.saveErrorLog(param, error, null, null);
            }
        }
    }

    public static enum Type {
        OnRowSuccess{

            @Override
            protected void innerDispose(DataCopyParam param) {
            }
        }
        ,
        OnRowFailed{

            @Override
            protected void innerDispose(DataCopyParam param) {
            }
        }
        ,
        OnTaskSuccess{

            @Override
            protected void innerDispose(DataCopyParam param) {
                param.dispose();
            }
        }
        ,
        OnTaskFailed{

            @Override
            protected void innerDispose(DataCopyParam param) {
                param.dispose();
            }
        };


        private Map<String, Object> getMessageData(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar, Throwable error) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
            data.put("event", this.name());
            if (tar != null) {
                data.put("action", D.s((Object)tar.get("$action")));
            }
            if (src != null) {
                data.put("source_id", src.get(param.getSourcePrimaryKey()));
                data.put("source_selector", this.getSelector(src, param.getSourceJudgeFields()));
                Map srcData = DataCopyEvent.cloneMapWithoutEntryVals(src);
                data.put("src_data", srcData);
            }
            if (tar != null && error == null) {
                data.put("target_id", tar.get(param.getTargetPrimaryKey()));
                data.put("target_selector", this.getSelector(tar, param.getJudgeFields()));
                Map tarData = DataCopyEvent.cloneMapWithoutEntryVals(tar);
                data.put("tar_data", tarData);
            }
            DynamicObject t = param.getTrigger();
            data.put("trigger_id", t.get("id"));
            data.put("trigger_number", t.get("number"));
            data.put("task_id", param.getExecutionId());
            if (param.getExecution() != null) {
                data.put("task_number", param.getExecution().getString("number"));
            }
            if (src == null) {
                Counter c = param.getCounter();
                data.put("total_count", c.getTotalCount());
                data.put("success_count", c.getSuccessCount());
                data.put("failed_count", c.getFailedCount());
                data.put("ignored_count", c.getIgnoredCount());
            }
            if (error != null) {
                data.put("error", Json.wrap((Throwable)error));
            }
            return data;
        }

        private Map<String, Object> getSelector(Map<String, Object> bill, List<String> fields) {
            LinkedHashMap<String, Object> selector = new LinkedHashMap<String, Object>(fields.size());
            for (String field : fields) {
                selector.put(field, bill.get(field));
            }
            return selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void raiseEvent(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar, Throwable error) {
            this.sendMessage(param, src, tar, error);
            EventUtil.saveDcTriggerEventLog(this, param, src, tar, error);
            List<DataCopyEvent> handlers = param.getEventHandlers(this);
            if (handlers.isEmpty()) {
                return;
            }
            try {
                Map<String, Object> data = this.getMessageData(param, src, tar, error);
                for (DataCopyEvent e : handlers) {
                    e.consumer.raiseEvent(param, e.handler, data);
                }
            }
            catch (Throwable e2) {
                DataCopyTask.saveErrorLog(param, e2, null, null);
            }
            finally {
                this.innerDispose(param);
            }
        }

        private void sendMessage(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar, Throwable error) {
            for (DataCopyMessageSender handler : param.getMessageHandlers(this)) {
                handler.sendMessage(this, src, tar, error);
            }
        }

        protected abstract void innerDispose(DataCopyParam var1);

        public String toString() {
            return super.toString();
        }
    }
}

