/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.apic.InvokeAPI;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.consume.ConsumeUtil;
import kd.isc.iscb.platform.core.consume.IscConsumeInfo;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.Filter;
import kd.isc.iscb.platform.core.dc.e.FlatObjectToMapOrList;
import kd.isc.iscb.platform.core.dc.e.MarkedReader;
import kd.isc.iscb.platform.core.dc.e.QueryDataSet;
import kd.isc.iscb.platform.core.dc.e.ServiceInvoker;
import kd.isc.iscb.platform.core.dc.e.ServiceUtil;
import kd.isc.iscb.platform.core.dc.e.p.ViewUtil;
import kd.isc.iscb.platform.core.dc.e.s.SourceDataDecorator;
import kd.isc.iscb.platform.core.dc.e.v.a.BizQueryFunction;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.debugger.InlineScriptDebuggerAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ListAsReader;
import kd.isc.iscb.util.io.NullObjectReader;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public class DataCopyInput {
    private static final String SORT_MODE = "sort_mode";
    private static final String SORT_FIELD = "sort_field";
    private static final String FULL_NAME = "full_name";
    private static final String NUMBER = "number";
    private DataCopyProvider param;
    private ObjectReader<? extends Map<String, Object>> reader;
    private int totalCount;
    private IscRuntimeInfo info = IscRuntimeInfo.get();
    private volatile boolean needsRPC = false;
    private int count = 0;
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    public DataCopyInput(DataCopyProvider param) {
        this(param, null);
    }

    public DataCopyInput(DataCopyProvider param, ObjectReader<? extends Map<String, Object>> reader) {
        this.param = param;
        this.reader = reader;
        this.totalCount = reader == null ? -1 : reader.getTotalCount();
        param.getCounter().setTotalCount(this.totalCount);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public ObjectReader<? extends Map<String, Object>> getReader() {
        return this.reader;
    }

    public static void registerLine2(DataCopyParam param) {
        DataCopyDebugger.registerLine(param, "source_data_read", ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u8bfb\u53d6\u5b8c\u6210", (String)"DataCopyInput_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public Map<String, Object> read() {
        this.prepare();
        try {
            Map<String, Object> data = this.innerRead();
            if (data != null) {
                data = this.dataRow2Map(data);
                this.decorate(data);
                DataCopyDebugger.trap(this.param, "source_data_read", data, null);
            }
            Map<String, Object> map = data;
            return map;
        }
        catch (Throwable e) {
            if (this.needsRPC) {
                this.info.incDataCopyReadFailedCount();
            }
            throw e;
        }
        finally {
            if (this.needsRPC) {
                this.info.incDataCopyReadTotalCount();
            }
        }
    }

    private Map<String, Object> dataRow2Map(Map<String, Object> data) {
        if (data instanceof DataRow) {
            data = ((DataRow)data).toMap();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decorate(Map<String, Object> data) {
        SourceDataDecorator decorator = this.param.getSourceDataDecorator();
        if (decorator == null) {
            return;
        }
        long beforeReadTick = System.currentTimeMillis();
        try {
            decorator.decorate(data, this.param);
        }
        finally {
            this.param.getCounter().incReadTime(System.currentTimeMillis() - beforeReadTick);
            this.param.getCounter().incReadBytes(DbUtil.getObjectSize(data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, Object> innerRead() {
        if (++this.count > this.param.getMaxCount()) {
            return null;
        }
        long beforeReadTick = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap();
        try {
            HashMap<String, Object> hashMap = data = (Map)this.reader.read();
            return hashMap;
        }
        finally {
            this.param.getCounter().incReadTime(System.currentTimeMillis() - beforeReadTick);
            this.param.getCounter().incReadBytes(DbUtil.getObjectSize(data));
        }
    }

    public synchronized void prepare() {
        if (this.isNotReady()) {
            DataCopyDebugger.trap(this.param, "source_data_query", null, null);
            long beforeReadTick = System.currentTimeMillis();
            try {
                this.createReader();
            }
            finally {
                this.param.getCounter().incReadTime(System.currentTimeMillis() - beforeReadTick);
            }
        }
    }

    public static void registerLine(DataCopyParam param) {
        if (param.getSrcDataRetrieveScript() == null) {
            DataCopyDebugger.registerLine(param, "source_data_query", DataCopyInput.getDebugText(param));
        } else {
            DataCopyDebugger.registerLine(param, "source_data_query", DataCopyInput.getDebugText(param), (DebuggerAction)new InlineScriptDebuggerAction(param.getSrcDataRetrieveScript().getProgram()));
        }
    }

    public synchronized boolean isNotReady() {
        return this.reader == null && this.totalCount < 0;
    }

    private void createReader() {
        Object data = this.param.getPushedData();
        this.needsRPC = true;
        if (data != null) {
            this.reader = this.pushedDataAsStream(data);
            this.needsRPC = false;
        } else if (this.param.sourceIsTable()) {
            this.reader = this.executeJdbcQuery();
        } else if (this.param.sourceIsView()) {
            this.reader = this.executeJdbcQuery();
        } else if (this.param.sourceIsEntity()) {
            this.reader = this.executeEntityQuery();
        } else if (this.param.sourceIsQuery()) {
            this.reader = this.executeApiQuery();
        } else if (this.param.sourceIsStruct()) {
            this.reader = this.executeScriptQuery();
        } else {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b\uff1a%s", (String)"DataCopyInput_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s((Object)this.param.getSourceSchema().get("type"))));
        }
        this.param.getCounter().setTotalCount(this.totalCount);
    }

    private static String getDebugText(DataCopyParam param) {
        Object data = param.getPushedData();
        if (data != null) {
            return ResManager.loadKDString((String)"\u63a8\u9001\u7684\u6570\u636e\u8f6c\u8f93\u5165\u6d41", (String)"DataCopyInput_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.sourceIsTable()) {
            return ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u6570\u636e\u8868/\u89c6\u56fe\u67e5\u8be2", (String)"DataCopyInput_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.sourceIsView()) {
            return ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edfSQL\u67e5\u8be2", (String)"DataCopyInput_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.sourceIsEntity()) {
            return ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u5b9e\u4f53\u67e5\u8be2", (String)"DataCopyInput_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.sourceIsQuery()) {
            return ResManager.loadKDString((String)"\u6267\u884c\u6765\u6e90\u7cfb\u7edf\u67e5\u8be2\u670d\u52a1", (String)"DataCopyInput_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.sourceIsStruct()) {
            return ResManager.loadKDString((String)"\u6267\u884c\u6765\u6e90\u6570\u636e\u67e5\u8be2\u811a\u672c", (String)"DataCopyInput_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u51c6\u5907", (String)"DataCopyInput_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectReader<Map<String, Object>> executeScriptQuery() {
        if (this.param.getSrcDataRetrieveScript() != null) {
            Object result;
            Map<String, Object> ctx = this.initCtx();
            long start = System.currentTimeMillis();
            try {
                result = this.param.getSrcDataRetrieveScript().eval(ctx);
            }
            finally {
                String title = ConsumeUtil.innerGetTitle(this.param.getSchema(), "src_retrieve_script", ResManager.loadKDString((String)"\u3010\u6765\u6e90\u6570\u636e\u67e5\u8be2\u811a\u672c\u3011\uff1a", (String)"DataCopyInput_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                IscConsumeInfo.recordOnce(start, this.param.getSchema(), title);
            }
            return this.wrapResult(result);
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u7ed3\u6784\u7c7b\u578b\u7684\u6e90\u5bf9\u8c61\u5fc5\u987b\u914d\u7f6e\u6e90\u6570\u636e\u67e5\u8be2\u811a\u672c", (String)"DataCopyInput_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private ObjectReader<Map<String, Object>> wrapResult(Object result) {
        if (result instanceof Collection) {
            Collection list = (Collection)result;
            this.totalCount = list.size();
            return DataCopyInput.createFilterReader((ObjectReader)new ListAsReader(list), this.param);
        }
        if (result instanceof ObjectReader) {
            ObjectReader reader = (ObjectReader)result;
            this.totalCount = reader.getTotalCount();
            return DataCopyInput.createFilterReader(reader, this.param);
        }
        if (result == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u67e5\u8be2\u811a\u672c\u7ed3\u679c\u662f\u7a7a\u503c\uff08null\uff09\u3002", (String)"DataCopyInput_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u83b7\u53d6\u811a\u672c\u7ed3\u679c\u7c7b\u578b\u5e94\u8be5\u662flist,\u5f53\u524d\u8fd4\u56de\u7c7b\u578b\u4e3a:%s", (String)"DataCopyInput_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), result.getClass().getName()));
    }

    private Map<String, Object> initCtx() {
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        ctx.put("params", this.param.getFilterParams());
        ConnectionWrapper cn = this.param.getSourceConnection();
        ctx.put("$src", cn);
        ctx.put("$service", new ServiceInvoker(cn, null));
        ctx.put("bizQuery", new BizQueryFunction());
        ctx.put("flatObjectToMapOrList", new FlatObjectToMapOrList());
        ctx.put("invoke_api", new InvokeAPI());
        ctx.put("query_data_set", new QueryDataSet());
        return ctx;
    }

    private ObjectReader<Map<String, Object>> executeApiQuery() {
        Map<String, Object> data;
        DynamicObject meta;
        ConnectionWrapper cn = this.param.getSourceConnection();
        Object result = ServiceUtil.callService(cn, meta = this.param.getSourceSchema(), data = this.param.getFilterParams(), null);
        if (result instanceof ObjectReader) {
            ObjectReader reader = (ObjectReader)result;
            this.totalCount = reader.getTotalCount();
            return DataCopyInput.createFilterReader(reader, this.param);
        }
        if (result instanceof Collection) {
            Collection list = (Collection)result;
            this.totalCount = list.size();
            return DataCopyInput.createFilterReader((ObjectReader)new ListAsReader(list), this.param);
        }
        if (result == null) {
            throw new NullPointerException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\uff08%s\uff09\u7684\u7ed3\u679c\u4e3a\u7a7a\uff01", (String)"DataCopyInput_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.get(NUMBER)));
        }
        throw new IllegalArgumentException(result.getClass().getName());
    }

    public static ObjectReader createFilterReader(ObjectReader reader, DataCopyProvider param) {
        List<Map<String, Object>> filter_entries = param.prepareFilter();
        if (filter_entries.size() > 0) {
            reader = new MarkedReader(reader, new Filter(filter_entries));
        }
        return reader;
    }

    private ObjectReader<Map<String, Object>> pushedDataAsStream(Object data) {
        if (data instanceof Map) {
            if (this.param.supportsFileCopy()) {
                this.appendAttach((Map)data);
            }
            this.totalCount = 1;
            return DataCopyInput.createFilterReader((ObjectReader)new ListAsReader(Collections.singletonList(data)), this.param);
        }
        if (data instanceof Collection) {
            Collection list = (Collection)data;
            if (this.param.supportsFileCopy()) {
                this.appendAttach(list);
            }
            this.totalCount = list.size();
            return DataCopyInput.createFilterReader((ObjectReader)new ListAsReader(list), this.param);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u6570\u636e\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u7c7b\u578b\uff1a%s", (String)"DataCopyInput_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), data.getClass()));
    }

    private void appendAttach(Collection<Map<String, Object>> list) {
        for (Map<String, Object> data : list) {
            this.appendAttach(data);
        }
    }

    private void appendAttach(Map<String, Object> data) {
        Collection list;
        Object fileList = data.get("$file_list");
        HashMap<String, Object> invokeParam = new HashMap<String, Object>();
        invokeParam.put("id", data.get("id"));
        invokeParam.put("entity", this.param.getSourceSchema().getString(FULL_NAME));
        if (fileList == null) {
            this.retrieveAttachList(data, invokeParam);
        }
        if (fileList instanceof Collection && (list = (Collection)fileList).size() == 0) {
            this.retrieveAttachList(data, invokeParam);
        }
    }

    private void retrieveAttachList(Map<String, Object> data, Map<String, Object> invokeParam) {
        List<Map<String, Object>> mapList = this.param.getSourceConnection().getFactory().retrieveAttachList(this.param.getSourceConnection(), invokeParam);
        if (mapList != null && mapList.size() > 0) {
            data.put("$file_list", mapList);
        }
    }

    private ObjectReader<? extends Map<String, Object>> executeEntityQuery() {
        String entity = this.param.getSourceSchema().getString(FULL_NAME);
        Map<String, Object> requires = this.param.getSourceRequires();
        String pk = this.param.getSourcePrimaryKey();
        if (pk != null && !requires.containsKey(pk)) {
            requires.put(pk, 1);
        }
        if (this.param.hasConfigSourceTsField()) {
            requires.put(this.param.getSourceTsField(), 1);
        }
        List<Map<String, Object>> filter = this.param.prepareFilter();
        filter = this.removeIgnoredItems(filter);
        List<Map<String, String>> orderBy = this.prepareOrderBy();
        ObjectReader<Map<String, Object>> reader = ConnectionManager.query(this.param.getSourceConnection(), entity, requires, filter, orderBy);
        this.totalCount = reader.getTotalCount();
        return reader;
    }

    private List<Map<String, Object>> removeIgnoredItems(List<Map<String, Object>> filter) {
        Iterator<Map<String, Object>> it = filter.iterator();
        while (it.hasNext()) {
            Map<String, Object> item = it.next();
            Object value = item.get("filter_value");
            if (!Filter.isIgnoredFilterItem(value)) continue;
            it.remove();
        }
        return filter;
    }

    private List<Map<String, String>> prepareOrderBy() {
        ArrayList<Map<String, String>> orderBy = new ArrayList<Map<String, String>>(2);
        for (Pair<String, String> p : this.param.getOrderBy()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(SORT_FIELD, p.getKey());
            item.put(SORT_MODE, p.getValue());
            orderBy.add(item);
        }
        return orderBy;
    }

    private ObjectReader<DataRow> executeJdbcQuery() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = this.prepareQuerySQL(types, values);
        if (this.param.getSourceConnection().supportsExecuteCount()) {
            this.totalCount = this.executeCount(sql, types, values);
            this.outputLogger(values, sql);
            if (this.totalCount > 0) {
                return this.param.getSourceConnection().executeQuery(sql, values, types);
            }
            return new NullObjectReader();
        }
        return this.param.getSourceConnection().executeQuery(sql, values, types);
    }

    private void outputLogger(List<Object> params, String sql) {
        LinkedHashMap<Object, Object> info = new LinkedHashMap<Object, Object>();
        Pair<String, String> p = this.param.getTaskNumber();
        info.put(p.getKey(), p.getValue());
        info.put("total_count", this.totalCount);
        info.put("sql", sql);
        info.put("params", params);
        logger.info("\u96c6\u6210\u4e91\u6570\u636e\u83b7\u53d6\uff0c\u96c6\u6210\u5bf9\u8c61\uff1a" + this.param.getSourceSchema().getString(NUMBER), (Object)Json.toString(info));
    }

    private int executeCount(String sql, List<Integer> types, List<Object> values) {
        long count = this.param.getSourceConnection().executeCount(sql, values, types);
        if (count > Integer.MAX_VALUE) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u884c\u6570\u592a\u591a\uff08%s\uff09\uff0c\u4e0d\u652f\u6301\u6570\u636e\u590d\u5236\uff01", (String)"DataCopyInput_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), count));
        }
        return (int)count;
    }

    private String prepareQuerySQL(List<Integer> types, List<Object> values) {
        String tableName;
        Table schema;
        if (this.param.sourceIsTable()) {
            schema = this.param.getSourceTable();
            tableName = this.param.getSourceTable().getQuotedName();
        } else {
            schema = ViewUtil.getSchema(this.param.getSourceSchema(), this.param.getSourceConnection());
            tableName = "(" + ViewUtil.getSQL(this.param.getSourceSchema()) + ") ISC_SOURCE_VIEW ";
        }
        String select = this.createSelect((Schema)schema);
        String filter = this.createFilter((Schema)schema, types, values);
        String order_by = this.createOrderBy((Schema)schema);
        String sql = this.getSqlStr(select, filter, order_by, tableName);
        return sql;
    }

    private String createSelect(Schema tableSchema) {
        StringBuilder select = new StringBuilder();
        HashSet<String> fieldSet = new HashSet<String>();
        for (Map.Entry<String, Object> e : this.param.getSourceRequires().entrySet()) {
            if (e.getValue() instanceof Map) continue;
            String src = e.getKey();
            this.appendColumnFormMasterTable(tableSchema, select, fieldSet, src);
        }
        String primaryKeyName = tableSchema.getPrimaryKeyName();
        if (primaryKeyName != null) {
            this.appendColumnFormMasterTable(tableSchema, select, fieldSet, primaryKeyName);
        }
        if (this.param.hasConfigSourceTsField()) {
            this.appendColumnFormMasterTable(tableSchema, select, fieldSet, this.param.getSourceTsField());
        }
        return select.toString();
    }

    private void appendColumnFormMasterTable(Schema tableSchema, StringBuilder select, Set<String> fieldSet, String src) {
        Column field = tableSchema.getField(src);
        String binding = field.getBinding();
        if (!fieldSet.contains(binding)) {
            if (fieldSet.size() > 0) {
                select.append(", ");
            }
            select.append(binding);
        }
        fieldSet.add(binding);
    }

    private String createOrderBy(Schema table) {
        StringBuilder sort = new StringBuilder();
        for (Pair<String, String> item : this.param.getOrderBy()) {
            if (sort.length() > 0) {
                sort.append(", ");
            }
            Column field = table.getField((String)item.getKey());
            sort.append(field.getBinding());
            sort.append(' ');
            sort.append((String)item.getValue());
        }
        return sort.toString();
    }

    private String getSqlStr(String select, String filter, String sort, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(select);
        sb.append(" from ");
        sb.append(tableName);
        if (filter.length() > 0) {
            sb.append(" where ");
            sb.append(filter);
        }
        if (sort.length() > 0) {
            sb.append(" order by ");
            sb.append(sort);
        }
        return sb.toString();
    }

    private String createFilter(Schema src_table, List<Integer> types, List<Object> values) {
        List<Map<String, Object>> filter_collection = this.param.prepareFilter();
        StringBuilder filter = new StringBuilder();
        for (int i = 0; i < filter_collection.size(); ++i) {
            Map<String, Object> obj = filter_collection.get(i);
            filter.append(this.trim(obj.get("filter_left_bracket")));
            Object value = obj.get("filter_value");
            if (Filter.isIgnoredFilterItem(value)) {
                filter.append(" 1=1 ");
            } else {
                Column field = this.getFilterField(src_table, obj);
                filter.append(field.getBinding());
                if (value instanceof List) {
                    this.handleListTypeParam(filter, values, field, (List)value, types, D.s((Object)obj.get("filter_compare")));
                } else if (this.isArray(value)) {
                    List list = (List)JSON.parseObject((String)value.toString(), List.class);
                    this.handleListTypeParam(filter, values, field, list, types, D.s((Object)obj.get("filter_compare")));
                } else {
                    this.handleBaseTypeParam(filter, values, obj, field, value, types);
                }
            }
            filter.append(this.trim(obj.get("filter_right_bracket")));
            if (i >= filter_collection.size() - 1) continue;
            filter.append("OR".equals(obj.get("filter_link")) ? " OR " : " AND ");
        }
        return filter.toString().trim();
    }

    private String trim(Object value) {
        String s = D.s((Object)value);
        if (s == null) {
            return "";
        }
        return s;
    }

    private void handleBaseTypeParam(StringBuilder filter, List<Object> values, Map<?, ?> obj, Column field, Object value, List<Integer> types) {
        CommonUtil.filterCompareHandle(filter, values, obj, field, value, types);
    }

    private void handleListTypeParam(StringBuilder filter, List<Object> values, Column field, List<?> list, List<Integer> types, String filter_compare) {
        String com = "not in".equalsIgnoreCase(filter_compare) ? "not in" : "in";
        filter.append(com);
        filter.append(" (");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                filter.append(',');
            }
            filter.append('?');
            types.add(field.getSqlType());
            values.add(field.toSqlParam(list.get(i)));
        }
        filter.append(')');
    }

    private boolean isArray(Object value) {
        return value instanceof String && value.toString().startsWith("[");
    }

    private Column getFilterField(Schema table, Map<?, ?> filter_item) {
        String filter_field = (String)filter_item.get("filter_column");
        Column field = table.getField(filter_field);
        return field;
    }

    public void dispose() {
        DbUtil.close(this.reader);
    }

    public void initEntityQueryIdReader() {
        this.prepareQueryIdReader();
    }

    public synchronized void prepareQueryIdReader() {
        if (this.isNotReady()) {
            long beforeReadTick = System.currentTimeMillis();
            try {
                this.createQueryIdReader();
            }
            finally {
                this.param.getCounter().incReadTime(System.currentTimeMillis() - beforeReadTick);
            }
        }
    }

    private void createQueryIdReader() {
        if (this.param.sourceIsTable()) {
            this.reader = this.executeJdbcQueryId();
        } else if (this.param.sourceIsView()) {
            this.reader = this.executeJdbcQueryId();
        } else if (this.param.sourceIsEntity()) {
            this.reader = this.executeEntityQueryId();
        } else {
            throw new UnsupportedOperationException(D.s((Object)this.param.getSourceSchema().get("type")));
        }
        this.param.getCounter().setTotalCount(this.totalCount);
    }

    private ObjectReader<DataRow> executeJdbcQueryId() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = this.prepareQueryIdSQL(types, values);
        this.totalCount = this.executeCount(sql, types, values);
        this.outputLogger(values, sql);
        if (this.totalCount > 0) {
            return this.param.getSourceConnection().executeQuery(sql, values, types);
        }
        return new NullObjectReader();
    }

    private String prepareQueryIdSQL(List<Integer> types, List<Object> values) {
        String tableName;
        Table table;
        if (this.param.sourceIsTable()) {
            table = this.param.getSourceTable();
            tableName = this.param.getSourceTableName();
        } else {
            table = ViewUtil.getSchema(this.param.getSourceSchema(), this.param.getSourceConnection());
            tableName = "(" + ViewUtil.getSQL(this.param.getSourceSchema()) + ") ISC_SOURCE_VIEW ";
        }
        String fieldName = table.getField(this.param.getSourcePrimaryKey()).getBinding();
        String filter = this.createFilter((Schema)table, types, values);
        String order_by = this.createOrderById(fieldName);
        String sql = this.getSqlStr(fieldName, filter, order_by, tableName);
        return sql;
    }

    private String createOrderById(String fieldName) {
        StringBuilder sort = new StringBuilder();
        sort.append(fieldName);
        sort.append(' ');
        sort.append("ASC");
        return sort.toString();
    }

    private ObjectReader<? extends Map<String, Object>> executeEntityQueryId() {
        String entity = this.param.getSourceSchema().getString(FULL_NAME);
        HashMap<String, Object> requires = new HashMap<String, Object>();
        requires.put(this.param.getSourcePrimaryKey(), 1);
        List<Map<String, Object>> filt = this.param.prepareFilter();
        List<Map<String, Object>> filter = this.removeIgnoredItems(filt);
        List<Map<String, String>> orderBy = this.prepareOrderByIdASC();
        ObjectReader<Map<String, Object>> reader = ConnectionManager.query(this.param.getSourceConnection(), entity, requires, filter, orderBy);
        this.totalCount = reader.getTotalCount();
        return reader;
    }

    private List<Map<String, String>> prepareOrderByIdASC() {
        ArrayList<Map<String, String>> orderBy = new ArrayList<Map<String, String>>();
        HashMap<String, String> item = new HashMap<String, String>();
        item.put(SORT_FIELD, this.param.getSourcePrimaryKey());
        item.put(SORT_MODE, "ASC");
        orderBy.add(item);
        return orderBy;
    }
}

