/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.constant.MessageType;
import kd.isc.iscb.platform.core.dc.e.DataCopyEvent;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.MarkedReader;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class DataCopyMessageSender {
    private static final Pattern ID_REGEX = Pattern.compile("(?<=\\()[0-9]*?(?=\\))");
    private static final Log logger = LogFactory.getLog(DataCopyMessageSender.class);
    private final Map<String, Object> ctx = new HashMap<String, Object>();
    private static final List<String> PERSON_STR = Arrays.asList("person_var", "outsideperson_var");
    private static final List<String> MSG_STR = Arrays.asList("msg_title", "msg_content");
    private final Script titleScript = Script.compile((String)"$${msg_title}");
    private final Script contentScript = Script.compile((String)"$${msg_content}");
    private final Map<String, Script> personScriptMap = new HashMap<String, Script>();
    private final int MAX_MSG_NUM;
    private final DataCopyParam dataCopyParam;
    private final String MESSAGE_SENDER_NUMBER;
    private final List<Long> recipients = new ArrayList<Long>();

    public DataCopyMessageSender(DataCopyParam param, DynamicObject object) {
        this.dataCopyParam = param;
        this.MAX_MSG_NUM = Math.min(D.i((Object)object.get("maxmsgnum")), 500);
        this.MESSAGE_SENDER_NUMBER = D.s((Object)object.get("number"));
        this.initCtx(object);
        this.initPersonScript(object);
        this.buildMessage(object);
    }

    public void sendMessage(DataCopyEvent.Type type, Map<String, Object> src, Map<String, Object> tar, Throwable error) {
        if (MarkedReader.isIgnored(src) || MarkedReader.isIgnored(tar)) {
            return;
        }
        if (this.overMaxSendNum(type)) {
            return;
        }
        MessageType.Message message = new MessageType.Message();
        message.setNoticeMethod("system_message");
        message.setRecipients(this.recipients);
        try {
            this.sendMessage(this.castDesc(type.name()), src, tar, error, message);
        }
        catch (Exception e) {
            logger.warn("\u5355\u636e\u7ea7\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5355\u636e\u901a\u77e5\u65b9\u6848\u7f16\u7801\u4e3a[" + this.MESSAGE_SENDER_NUMBER + "]\uff0c\u542f\u52a8\u65b9\u6848\u7f16\u7801\u4e3a[" + this.dataCopyParam.getTrigger().get("number") + "]\uff0c\u5f02\u5e38\u4fe1\u606f\uff1axxx" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
    }

    private boolean overMaxSendNum(DataCopyEvent.Type type) {
        int count = this.dataCopyParam.incMessageCount();
        if (count > this.MAX_MSG_NUM) {
            if (count == this.MAX_MSG_NUM + 1) {
                logger.warn("\u5f53\u524d\u6267\u884c\u60c5\u51b5\uff1a" + this.castDesc(type.name()) + "\u7f16\u7801\u4e3a[" + this.dataCopyParam.getTrigger().get("number") + "]\u7684\u542f\u52a8\u65b9\u6848\u5bf9\u5e94\u7684\u5355\u636e\u901a\u77e5\u65b9\u6848[" + this.MESSAGE_SENDER_NUMBER + "]\u5355\u636e\u7ea7\u6d88\u606f\u901a\u77e5\u53d1\u9001\u6761\u6570\u8d85\u51fa\u6700\u5927\u9600\u503c" + this.MAX_MSG_NUM + "\uff0c\u5df2\u53d6\u6d88\u53d1\u9001\u3002");
            }
            return true;
        }
        return false;
    }

    private String castDesc(String desc) {
        if ("OnRowSuccess".equals(desc)) {
            return ResManager.loadKDString((String)"\u5355\u636e\u6267\u884c\u6210\u529f", (String)"DataCopyMessageSender_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if ("OnRowFailed".equals(desc)) {
            return ResManager.loadKDString((String)"\u5355\u636e\u6267\u884c\u5931\u8d25", (String)"DataCopyMessageSender_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return desc;
    }

    private void sendMessage(String statusDesc, Map<String, Object> src, Map<String, Object> tar, Throwable error, MessageType.Message message) {
        this.prepareCtx(statusDesc, src, tar, error);
        this.setPerson(message);
        this.setMsg(message);
        MessageType.COSMIC.send(message);
    }

    private void setPerson(MessageType.Message message) {
        ArrayList<Long> tempList = new ArrayList<Long>();
        for (Map.Entry<String, Script> entry : this.personScriptMap.entrySet()) {
            Object value = entry.getValue().eval(this.ctx);
            try {
                long pid;
                if (value instanceof Map) {
                    Map map = (Map)value;
                    pid = D.l(map.get("id"));
                    if (pid == 0L) continue;
                    tempList.add(pid);
                    continue;
                }
                if (value instanceof List) {
                    List value1 = (List)value;
                    for (Object val : value1) {
                        tempList.add(D.l(val));
                    }
                    continue;
                }
                pid = D.l((Object)value);
                tempList.add(pid);
            }
            catch (Exception ex) {
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u6d88\u606f\u53d1\u9001\u7684\u63a5\u6536\u4eba\u53d8\u91cf: \u201c%1$s\u201d\u53d6\u5230\u7684\u503c\u4e0d\u6b63\u786e\uff0c\u5b9e\u9645\u503c\u4e3a:%2$s\uff0c\u8bf7\u786e\u8ba4\u8be5\u53d8\u91cf\u7684\u53d6\u503c\u4e3a\u82cd\u7a79\u7684\u4eba\u5458\u6216\u8005\u662f\u624b\u673a\u53f7\u7801\u3002", (String)"DataCopyMessageSender_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entry.getKey(), value), ex);
            }
        }
        message.setRecipients(tempList);
    }

    private void setMsg(MessageType.Message message) {
        message.setFinalMsgTitle(D.s((Object)this.titleScript.eval(this.ctx)));
        message.setFinalMsgContent(D.s((Object)this.contentScript.eval(this.ctx)));
    }

    private void initPersonScript(DynamicObject object) {
        for (String fieldName : PERSON_STR) {
            String[] persons;
            String str = D.s((Object)object.getString(fieldName));
            if (str == null) continue;
            for (String person : persons = str.split(";")) {
                this.personScriptMap.put(person, Script.compile((String)person));
            }
        }
    }

    private void initCtx(DynamicObject object) {
        this.ctx.put("schema_id", this.dataCopyParam.getSchema().getPkValue());
        this.ctx.put("schema_number", this.dataCopyParam.getSchema().get("number"));
        this.ctx.put("schema_name", this.dataCopyParam.getSchema().get("name"));
        this.ctx.put("trigger_id", this.dataCopyParam.getTrigger().getPkValue());
        this.ctx.put("trigger_number", this.dataCopyParam.getTrigger().get("number"));
        this.ctx.put("trigger_name", this.dataCopyParam.getTrigger().get("name"));
        this.ctx.put("task_id", this.dataCopyParam.getExecutionId());
        if (this.dataCopyParam.getExecution() != null) {
            this.ctx.put("task_number", this.dataCopyParam.getExecution().getString("number"));
            this.ctx.put("task_name", this.dataCopyParam.getExecution().getString("name"));
        }
        for (String s : MSG_STR) {
            String str = D.s((Object)object.getString(s));
            if (str == null) continue;
            this.ctx.put(s, str);
        }
    }

    private void prepareCtx(String desc, Map<String, Object> src, Map<String, Object> tar, Throwable error) {
        this.ctx.put("data_execute_status", desc);
        this.ctx.put("src", src);
        this.ctx.put("tar", tar);
        if (error != null) {
            this.ctx.put("$error", StringUtil.getCascadeMessage((Throwable)error));
            this.ctx.put("$error_tag", StringUtil.toString((Throwable)error));
        } else {
            this.ctx.put("$error", null);
            this.ctx.put("$error_tag", null);
        }
    }

    private void buildMessage(DynamicObject object) {
        String person = D.s((Object)object.get("person"));
        if (person != null) {
            this.buildMessage(person);
        }
        if ((person = D.s((Object)object.get("outsideperson"))) != null) {
            this.buildMessage(person);
        }
    }

    private void buildMessage(String person) {
        Matcher idMatcher = ID_REGEX.matcher(person);
        ArrayList<Long> ids = new ArrayList<Long>();
        while (idMatcher.find()) {
            ids.add(Long.parseLong(idMatcher.group()));
        }
        this.recipients.addAll(ids);
    }
}

