/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.sql.Timestamp;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.Murmur;

public class DataCopyOidLog {
    private static final String[] number_fields = new String[]{"number", "fnumber", "FNumber", "FBillNo", "code", "fcode", "billno", "fbillno", "name", "fname", "Name", "FName", "label", "flabel"};

    public static void saveLog(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar, DynamicObject log) {
        String status = DataCopyOidLog.getStatus(tar);
        if (status == null) {
            return;
        }
        Object log_id = DataCopyOidLog.getLogId(log);
        Object schema = param.getSchema().getPkValue();
        Object trigger = DataCopyOidLog.getTriggerId(param);
        Object task = DataCopyOidLog.getTaskId(param);
        String spk = param.getSourcePrimaryKey();
        ConnectionWrapper scn = param.getSourceConnection();
        String stable = param.getSourceTableName();
        DataCopyOidLog.saveLog(src, stable, spk, scn, "1", status, log_id, schema, trigger, task);
        String tpk = param.getTargetPrimaryKey();
        ConnectionWrapper tcn = param.getTargetConnection();
        String ttable = param.getTargetTableName();
        DataCopyOidLog.saveLog(tar, ttable, tpk, tcn, "2", status, log_id, schema, trigger, task);
    }

    private static void saveLog(Map<String, Object> data, String table_name, String pk, ConnectionWrapper cn, String role, String status, Object log_id, Object schema, Object trigger, Object task) {
        if (table_name == null) {
            return;
        }
        String oid = D.s((Object)data.get(pk));
        if (oid == null) {
            return;
        }
        table_name = table_name.toUpperCase();
        String number = DataCopyOidLog.getNumber(data);
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_bill_log_relation");
        long system = D.l((Object)cn.getConfig().getPkValue());
        String vid = DataCopyOidLog.generateVirtualOID(system, table_name, oid);
        log.set("vid", (Object)vid);
        log.set("system", (Object)system);
        log.set("table_name", (Object)table_name);
        log.set("time", (Object)new Timestamp(System.currentTimeMillis()));
        log.set("oid", (Object)oid);
        log.set("number", (Object)number);
        log.set("role", (Object)role);
        log.set("status", (Object)status);
        log.set("log", log_id);
        log.set("schema", schema);
        log.set("trigger", trigger);
        log.set("task", task);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static String generateVirtualOID(long system, String table_name, String oid) {
        return Murmur.calc32((Object[])new Object[]{system, table_name.toUpperCase(), oid});
    }

    private static String getNumber(Map<String, Object> data) {
        for (String field : number_fields) {
            String number = D.s((Object)data.get(field));
            if (number == null) continue;
            return StringUtil.trim((String)number, (int)50);
        }
        return null;
    }

    private static Object getTaskId(DataCopyParam param) {
        DynamicObject t = param.getExecution();
        return t == null ? null : t.getPkValue();
    }

    private static Object getTriggerId(DataCopyParam param) {
        DynamicObject t = param.getTrigger();
        return t == null ? null : t.getPkValue();
    }

    private static Object getLogId(DynamicObject log) {
        if (log != null) {
            return log.getPkValue();
        }
        return null;
    }

    private static String getStatus(Map<String, Object> tar) {
        SaveDataType action = (SaveDataType)tar.get("$action");
        if (action == null) {
            return null;
        }
        switch (action) {
            case FAILED: {
                return "0";
            }
            case NOP: {
                return "5";
            }
        }
        return "9";
    }
}

