/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.constant.TimestampStatus;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.BizBatchException;
import kd.isc.iscb.platform.core.dc.e.DataCopyAttachment;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyEvent;
import kd.isc.iscb.platform.core.dc.e.DataCopyInput;
import kd.isc.iscb.platform.core.dc.e.DataCopyMapping;
import kd.isc.iscb.platform.core.dc.e.DataCopyOidLog;
import kd.isc.iscb.platform.core.dc.e.DataCopyOidLookup;
import kd.isc.iscb.platform.core.dc.e.DataCopyOutput;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.DataCreteria;
import kd.isc.iscb.platform.core.dc.e.MarkedReader;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskWorker;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.util.MappingDataUtil;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.ConnectionException;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.io.ObjectWriter;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceManager;
import kd.isc.iscb.util.trace.TraceTask;

public class DataCopyRunner {
    private static final int MIN_BATCH = 10;
    private static final ThreadLocal<Map<String, Object>> lastSrc = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> lastTar = new ThreadLocal();
    private DataCopyParam param;
    private DataCopyInput input;
    private DataCopyOutput output;
    private DataCopyMapping mapping;
    private volatile boolean running = true;
    private Map<String, String> parentMapping = new HashMap<String, String>();
    private Collector collector;
    private AtomicInteger errorLogCount = new AtomicInteger(0);
    private int subTaskCount = 0;
    private volatile Throwable lastError;
    private volatile TaskCancelException cancelSignal;
    private static final TaskWorker SUB_TASK_QUEUE = new TaskWorker("ISC_SUB_TASK_WORKER", 32);

    public DataCopyRunner(DynamicObject exection) {
        this(exection, null, null, null, DataCopyRunner.createDefaultCollector());
    }

    public DataCopyRunner(DynamicObject exection, Collector collector) {
        this(exection, null, null, null, collector);
    }

    public DataCopyRunner(DynamicObject obj, ObjectReader<? extends Map<String, Object>> reader, ObjectWriter<Map<String, Object>> writer, Map<String, Object> filter_params) {
        this(obj, reader, writer, filter_params, DataCopyRunner.createDefaultCollector());
    }

    public DataCopyRunner(DynamicObject obj, ObjectReader<? extends Map<String, Object>> reader, ObjectWriter<Map<String, Object>> writer, Map<String, Object> filter_params, Collector collector) {
        long start = System.currentTimeMillis();
        DataCopyParam param = new DataCopyParam(obj, filter_params);
        this.init(param, collector, reader, writer);
        this.param.getCounter().incPrepareTime(System.currentTimeMillis() - start);
    }

    public DataCopyRunner(DataCopyParam param) {
        this.init(param, DataCopyRunner.createDefaultCollector(), null, null);
    }

    public DataCopyRunner(DataCopyParam param, Collector collector) {
        this.init(param, collector, null, null);
    }

    public DataCopyRunner(DataCopyParam param, Collector collector, ObjectReader<? extends Map<String, Object>> reader, ObjectWriter<Map<String, Object>> writer) {
        this.init(param, collector, reader, writer);
    }

    private void init(DataCopyParam param, Collector collector, ObjectReader<? extends Map<String, Object>> reader, ObjectWriter<Map<String, Object>> writer) {
        this.collector = collector;
        this.param = param;
        this.input = new DataCopyInput(param, reader);
        this.output = new DataCopyOutput(param, writer);
        this.mapping = new DataCopyMapping(param);
    }

    public DataCopyParam getParam() {
        return this.param;
    }

    public Map<String, Object> getLastSrc() {
        return lastSrc.get();
    }

    public Map<String, Object> getLastTar() {
        return lastTar.get();
    }

    public void clearLastRow() {
        lastSrc.remove();
        lastTar.remove();
    }

    public DataCopyInput getInput() {
        if (this.input.isNotReady()) {
            this.input.prepare();
        }
        return this.input;
    }

    public DataCopyOutput getOutput() {
        return this.output;
    }

    public DataCopyMapping getMapping() {
        return this.mapping;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        this.errorLogCount.set(0);
        String executionId = this.param.getExecutionId();
        SignalManager.registerTask(executionId);
        try {
            DataCopyDebugger.attachBreakpoints(this.param);
            this.doJob();
        }
        finally {
            SignalManager.unregisterTask(executionId);
        }
    }

    private void doJob() {
        try {
            this.param.getCounter().resetThreadCount();
            this.param.getCounter().setStartTime(System.currentTimeMillis());
            this.doCopyWithTrace();
            this.param.getCounter().resetTotalCount();
        }
        catch (Throwable e) {
            this.doRollback(e);
            throw e;
        }
        finally {
            this.running = false;
            this.dispose();
            this.handleOmittedErrorLogs();
        }
    }

    private void handleOmittedErrorLogs() {
        int omitted = this.errorLogCount.get() - this.param.getMaxErrorLogRecordCount();
        if (omitted > 0) {
            String message = String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u5931\u8d25\u65e5\u5fd7\u6700\u5927\u6570\u91cf\u9650\u5236\uff0c\u6709%s\u6761\u5931\u8d25\u65e5\u5fd7\u88ab\u4e22\u5f03\u3002", (String)"DataCopyRunner_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), omitted);
            DataCopyTask.saveErrorLog(this.param, null, null, message, null, "F");
        }
    }

    private void doCopyWithTrace() {
        if (!this.param.isFree()) {
            IscLicenseUtil.check_PRO_ISCB_License();
        }
        Pair<TraceType, DynamicObject> p = this.param.getTraceInfo();
        this.doCopyWithTrace((TraceType)((Object)p.getKey()), (DynamicObject)p.getValue());
    }

    private void doCopyWithTrace(TraceType type, DynamicObject runtime) {
        TraceStack.run(type, runtime, new TraceTask(){

            public void run() {
                DataCopyRunner.this.checkDisableTrace();
                DataCopyRunner.this.prepareContext();
                DataCopyRunner.this.startSubTasks();
                DataCopyRunner.this.doMainTask();
                DataCopyRunner.this.throwLastError();
            }
        });
    }

    private void doRollback(Throwable e) {
        if (this.output.rollback(e)) {
            this.param.getCounter().rollback();
        }
    }

    private void doMainTask() {
        try {
            this.doCopy();
        }
        catch (Throwable e) {
            this.lastError = e;
        }
        finally {
            this.waitForSubTasks();
        }
    }

    private synchronized void waitForSubTasks() {
        while (this.subTaskCount > 0) {
            try {
                this.wait(1000L);
                try {
                    if (this.cancelSignal != null) continue;
                    SignalManager.checkCancelSignal();
                }
                catch (TaskCancelException err) {
                    this.cancelSignal = err;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void checkCancelSignal() {
        TaskCancelException e = this.cancelSignal;
        if (e != null) {
            throw e;
        }
        try {
            SignalManager.checkCancelSignal();
        }
        catch (TaskCancelException err) {
            this.cancelSignal = err;
            throw this.cancelSignal;
        }
    }

    private void throwLastError() {
        Throwable e = this.lastError;
        if (e == null) {
            return;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw D.e((Throwable)e);
    }

    synchronized void incSubTaskCount() {
        ++this.subTaskCount;
        this.param.getCounter().incThreadCount();
    }

    synchronized void decSubTaskCount() {
        --this.subTaskCount;
        this.notifyAll();
    }

    private void startSubTasks() {
        int count = this.param.getCounter().getTotalCount();
        if (this.param.isRollbackOnError() || this.param.getThreadUBound() <= 1 || this.param.getTargetParentField() != null || count >= 0 && count <= 10) {
            return;
        }
        int max = Math.min(32, this.param.getThreadUBound()) - 1;
        if (count > 0) {
            max = Math.min(max, (count + 10 - 1) / 10);
        }
        List<String> tasks = SignalManager.currentTasks();
        for (int i = 0; i < max; ++i) {
            SUB_TASK_QUEUE.submit(new SubTask(tasks));
        }
    }

    private void doCopy() {
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(this.param.getSchema()));
        try {
            LinkedList<Pair<Map<String, Object>, Map<String, Object>>> buffer = new LinkedList<Pair<Map<String, Object>, Map<String, Object>>>();
            Map<String, Object> src = this.input.read();
            while (src != null) {
                this.doCopy(src, buffer);
                src = this.input.read();
            }
            this.doCommit(buffer);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(List<Pair<Map<String, Object>, Map<String, Object>>> buffer) {
        Throwable error = null;
        try {
            this.output.commit();
        }
        catch (Throwable e) {
            error = e;
            this.saveErrorLog(null, null, null, e);
            this.tryThrowError(e);
        }
        finally {
            this.refreshCounter(buffer, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopy(Map<String, Object> src, List<Pair<Map<String, Object>, Map<String, Object>>> buffer) {
        lastSrc.set(src);
        Map<String, Object> tar = DataCopyRunner.createEmptyTar();
        DynamicObject log = null;
        Throwable error = null;
        try {
            this.checkCancelSignal();
            if (MarkedReader.isIgnored(src)) {
                this.setTargetIgnored(src, tar);
                log = this.saveSuccessLog(src, tar);
            } else {
                DataCopyAttachment.handleAttachmentFile(this.param, src);
                this.translate(src, tar);
                this.doOutput(tar);
                log = this.saveSuccessLog(src, tar);
                this.handleSuccess(src, tar);
            }
        }
        catch (Throwable e) {
            error = e;
            this.setFailedAction(tar, e);
            log = this.saveErrorLog(src, tar, log, e);
            this.tryThrowError(e);
        }
        finally {
            buffer.add((Pair<Map<String, Object>, Map<String, Object>>)new Pair(src, tar));
            this.refreshCounter(buffer, error);
            this.saveOidLog(src, tar, log);
        }
    }

    private void setFailedAction(Map<String, Object> tar, Throwable e) {
        if (e instanceof TaskCancelException) {
            tar.put("$action", SaveDataType.CANCELLED);
        } else if (!(e instanceof BizBatchException)) {
            tar.put("$action", SaveDataType.FAILED);
        }
    }

    private void doOutput(Map<String, Object> tar) {
        if (MarkedReader.isIgnored(tar)) {
            TimestampStatus tsStatus = (TimestampStatus)((Object)tar.get("#_TS_STATUS"));
            if (tsStatus == null) {
                tar.put("$action", SaveDataType.NOP);
                tar.put("$reason", ResManager.loadKDString((String)"\u8f6c\u6362\u811a\u672c\u5c06\u76ee\u6807\u5355\u6807\u8bb0\u4e3a\u5ffd\u7565", (String)"DataCopyRunner_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            } else {
                this.setTsIgnoreReason(tar, tsStatus);
            }
        } else {
            this.output.write(tar);
        }
    }

    private void setTsIgnoreReason(Map<String, Object> tar, TimestampStatus tsStatus) {
        if (tsStatus == TimestampStatus.EVER_HANDLED) {
            tar.put("$action", SaveDataType.EVER_HANDLED);
        } else {
            tar.put("$action", SaveDataType.NOP);
        }
        tar.put("$reason", tsStatus.getReason());
    }

    private void handleSuccess(Map<String, Object> src, Map<String, Object> tar) {
        DataCopyOidLookup.saveOidMapping(this.param, src, tar);
        this.postHandleForTree(src, tar);
        this.handleWriteBackRule(src, tar);
    }

    private DynamicObject saveErrorLog(Map<String, Object> src, Map<String, Object> tar, DynamicObject log, Throwable e) throws HandledException {
        if (e instanceof BizBatchException) {
            return null;
        }
        int count = this.errorLogCount.incrementAndGet();
        if (count <= this.param.getMaxErrorLogRecordCount()) {
            DynamicObject error_log = DataCopyTask.saveErrorLog(this.param, e, src, tar);
            return log == null ? error_log : log;
        }
        if (count == this.param.getMaxErrorLogRecordCount() + 1) {
            String message = String.format(ResManager.loadKDString((String)"\u5931\u8d25\u6570\u91cf\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff08%s\u6761\uff09\uff0c\u672c\u6b21\u6267\u884c\u7684\u540e\u7eed\u9519\u8bef\u65e5\u5fd7\u5c06\u88ab\u4e22\u5f03\u3002", (String)"DataCopyRunner_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param.getMaxErrorLogRecordCount());
            return DataCopyTask.saveErrorLog(this.param, null, null, message, null, "N");
        }
        return null;
    }

    private Map<String, Object> setTargetIgnored(Map<String, Object> src, Map<String, Object> tar) {
        tar.put("$action", SaveDataType.NOP);
        TimestampStatus tsStatus = (TimestampStatus)((Object)src.get("#_TS_STATUS"));
        if (tsStatus == null) {
            tar.put("$reason", src.get("#_IGNORE_REASON"));
        } else {
            tar.put("$reason", tsStatus.getReason());
        }
        return tar;
    }

    private void prepareContext() {
        this.input.prepare();
        this.output.prepare();
    }

    private void saveOidLog(Map<String, Object> src, Map<String, Object> tar, DynamicObject log) {
        if (this.param.isRecordOidLog()) {
            try {
                DataCopyOidLog.saveLog(this.param, src, tar, log);
            }
            catch (Throwable e) {
                this.saveErrorLog(null, null, null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translate(Map<String, Object> src, Map<String, Object> tar) {
        long beforeTranslateTick = System.currentTimeMillis();
        try {
            if (this.isTsLogEverHandle(src, tar)) {
                return;
            }
            this.mapping.translateAll(src, tar);
            this.preHandleForTree(src, tar);
            DataCopyOidLookup.restoreFromOidMapping(this.param, src, tar);
        }
        finally {
            this.param.getCounter().incConvertTime(System.currentTimeMillis() - beforeTranslateTick);
        }
    }

    private boolean isTsLogEverHandle(Map<String, Object> src, Map<String, Object> tar) {
        if (this.param.hasConfigSourceTsField()) {
            Object value = src.get("#_TS_STATUS");
            tar.put("#_TS_STATUS", value);
            if (TimestampStatus.EVER_HANDLED == value) {
                tar.put("#_IGNORE_TAG", Boolean.TRUE);
                return true;
            }
        }
        return false;
    }

    private void tryThrowError(Throwable e) {
        if (e instanceof TaskCancelException) {
            this.cancelSignal = (TaskCancelException)e;
            throw this.cancelSignal;
        }
        if (e instanceof ConnectionException) {
            throw (ConnectionException)e;
        }
        if (D.isError((Throwable)e)) {
            throw D.e((Throwable)e);
        }
        if (this.param.isBreakOnError()) {
            if (e instanceof HandledException) {
                throw (HandledException)e;
            }
            throw new HandledException(e);
        }
    }

    private DynamicObject saveSuccessLog(Map<String, Object> src, Map<String, Object> tar) {
        if (this.param.isTraceAll()) {
            return DataCopyTask.saveErrorLog(this.param, null, src, tar);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCounter(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, Throwable err) {
        ArrayList<Object> src_failed = new ArrayList<Object>(buffer.size());
        ArrayList<Object> tar_failed = new ArrayList<Object>(buffer.size());
        ArrayList<Pair<Map<String, Object>, Map<String, Object>>> dataListForNotify = new ArrayList<Pair<Map<String, Object>, Map<String, Object>>>(buffer.size());
        try {
            this.refreshCounter(buffer, src_failed, tar_failed, err, dataListForNotify);
        }
        finally {
            this.saveBatchFailedData(err, src_failed, tar_failed);
            this.notify(dataListForNotify, err);
        }
    }

    private void notify(List<Pair<Map<String, Object>, Map<String, Object>>> dataListForNotify, Throwable err) {
        for (Pair<Map<String, Object>, Map<String, Object>> pair : dataListForNotify) {
            Map src = (Map)pair.getA();
            Map tar = (Map)pair.getB();
            SaveDataType action = (SaveDataType)tar.get("$action");
            if (action == null) continue;
            if (action.isFailType()) {
                DataCopyEvent.Type.OnRowFailed.raiseEvent(this.param, src, tar, err);
                continue;
            }
            if (!action.isSuccessType()) continue;
            DataCopyEvent.Type.OnRowSuccess.raiseEvent(this.param, src, tar, null);
        }
    }

    private void saveBatchFailedData(Throwable err, List<Object> src_failed, List<Object> tar_failed) {
        if (src_failed.size() > 0) {
            int count = this.errorLogCount.incrementAndGet();
            if (count <= this.param.getMaxErrorLogRecordCount()) {
                String message = String.format(ResManager.loadKDString((String)"\u6279\u5904\u7406\u5931\u8d25\uff08\u5171\uff1a%1$s\u6761\uff09\uff0c\u539f\u56e0: %2$s", (String)"DataCopyRunner_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), src_failed.size(), StringUtil.toString((Throwable)err));
                DataCopyTask.saveErrorLog(this.param, src_failed, tar_failed, message, null, "F");
            } else if (count == this.param.getMaxErrorLogRecordCount() + 1) {
                String message = String.format(ResManager.loadKDString((String)"\u5931\u8d25\u6570\u91cf\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff08%s\u6761\uff09\uff0c\u672c\u6b21\u6267\u884c\u7684\u540e\u7eed\u9519\u8bef\u65e5\u5fd7\u5c06\u88ab\u4e22\u5f03\u3002", (String)"DataCopyRunner_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param.getMaxErrorLogRecordCount());
                DataCopyTask.saveErrorLog(this.param, null, null, message, null, "N");
            }
        }
    }

    private void refreshCounter(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, List<Object> src_failed, List<Object> tar_failed, Throwable err, List<Pair<Map<String, Object>, Map<String, Object>>> dataListForNotify) {
        Iterator<Pair<Map<String, Object>, Map<String, Object>>> it = buffer.iterator();
        while (it.hasNext()) {
            Pair<Map<String, Object>, Map<String, Object>> p = it.next();
            Map tar = (Map)p.getValue();
            Map src = (Map)p.getKey();
            this.collectBatchFailedData(src_failed, tar_failed, tar, src);
            dataListForNotify.add(p);
            this.refreshCounter(it, tar, src, err);
        }
    }

    private void collectBatchFailedData(List<Object> src_failed, List<Object> tar_failed, Map<String, Object> tar, Map<String, Object> src) {
        if (tar.containsKey("$error_message")) {
            src_failed.add(src);
            tar_failed.add(tar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCounter(Iterator<Pair<Map<String, Object>, Map<String, Object>>> it, Map<String, Object> tar, Map<String, Object> src, Throwable err) {
        SaveDataType action = (SaveDataType)tar.get("$action");
        if (action != null) {
            it.remove();
            try {
                this.tarActionHandle(src, action);
            }
            finally {
                this.collector.collect(src, tar, action, err);
            }
        }
    }

    private void tarActionHandle(Map<String, Object> src, SaveDataType action) {
        switch (action) {
            case NOP: {
                this.param.getCounter().incIgnoredCount(1);
                break;
            }
            case FAILED: {
                this.param.getCounter().incFailedCount(1);
                break;
            }
            case EVER_HANDLED: {
                this.param.getCounter().incSuccessCount(1);
                break;
            }
            case CANCELLED: {
                break;
            }
            default: {
                this.param.getCounter().incSuccessCount(1);
                this.handleTsLog(src);
            }
        }
    }

    private void handleTsLog(Map<String, Object> src) {
        TimestampStatus tsStatus;
        if (this.param.hasConfigSourceTsField() && (tsStatus = (TimestampStatus)((Object)src.get("#_TS_STATUS"))) != null) {
            tsStatus.saveLog(this.param, src);
        }
    }

    private void handleWriteBackRule(Map<String, Object> src, Map<String, Object> tar) {
        SaveDataType action = (SaveDataType)tar.get("$action");
        if (action == null) {
            return;
        }
        if (this.param.getWriteBackRuleId() > 0L) {
            String src_id = D.s((Object)src.get(this.param.getSourcePrimaryKey()));
            String tar_id = D.s((Object)tar.get(this.param.getTargetPrimaryKey()));
            if (src_id != null && tar_id != null) {
                if (action == SaveDataType.INSERT) {
                    MappingDataUtil.recordMapppingValue(this.param.getWriteBackRuleId(), src_id, tar_id);
                } else if (action == SaveDataType.DELETE) {
                    MappingDataUtil.deleteMappingValue(this.param.getWriteBackRuleId(), src_id, tar_id);
                }
            }
        }
    }

    private void postHandleForTree(Map<String, Object> src, Map<String, Object> tar) {
        if (this.param.getTargetParentField() == null) {
            return;
        }
        String srcId = D.s((Object)src.get(this.param.getSourcePrimaryKey()));
        String tarId = D.s((Object)tar.get(this.param.getTargetPrimaryKey()));
        this.checkId(srcId, tarId);
        this.parentMapping.put(srcId, tarId);
    }

    private void checkId(String srcId, String tarId) {
        if (tarId == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u6ca1\u6709ID\u503c\uff0c\u4e0d\u652f\u6301\u5c42\u6b21\u7ed3\u6784\uff01", (String)"DataCopyRunner_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (srcId == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6e90\u5355\u6ca1\u6709ID\u503c\uff0c\u4e0d\u652f\u6301\u5c42\u6b21\u7ed3\u6784\uff01", (String)"DataCopyRunner_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void preHandleForTree(Map<String, Object> src, Map<String, Object> tar) {
        if (this.param.getTargetParentField() == null) {
            return;
        }
        if (this.isRoot(src, tar)) {
            tar.put(this.param.getTargetParentField(), this.param.getTargetDefaultRootParent());
        } else {
            this.setTargetParent(src, tar);
        }
    }

    private void setTargetParent(Map<String, Object> src, Map<String, Object> tar) {
        String srcParent = D.s((Object)src.get(this.param.getSourceParentField()));
        String tarParent = this.parentMapping.get(srcParent);
        if (tarParent == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4e3a\u6e90\u5355ID\uff08%s\uff09\u627e\u5230\u76ee\u6807\u5355ID\uff0c\u8bf7\u68c0\u67e5\u6392\u5e8f\u5b57\u6bb5\u548c\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u5c42\u6b21\u7ed3\u6784\u6570\u636e\u90fd\u80fd\u83b7\u53d6\u5230\u3002", (String)"DataCopyRunner_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), srcParent));
        }
        tar.put(this.param.getTargetParentField(), tarParent);
    }

    private boolean isRoot(Map<String, Object> src, Map<String, Object> tar) {
        DataCreteria createria = this.param.getTargetRootNodeCreteria();
        if (createria != null && createria.matches(tar)) {
            return true;
        }
        return D.s((Object)src.get(this.param.getSourceParentField())) == null;
    }

    private void dispose() {
        this.output.dispose();
        this.input.dispose();
        this.param.dispose();
    }

    private void checkDisableTrace() {
        if (this.param.isDisableTrace()) {
            TraceManager.disableTrace();
        }
    }

    private static Map<String, Object> createEmptyTar() {
        LinkedHashMap<String, Object> tar = new LinkedHashMap<String, Object>();
        lastTar.set(tar);
        return tar;
    }

    private static Collector createDefaultCollector() {
        return new Collector(){

            @Override
            public void collect(Map<String, Object> src, Map<String, Object> tar, SaveDataType action, Throwable err) {
            }
        };
    }

    public static void submitDataStreamTask(Task task) {
        String name = task.getClass().getName();
        if (!name.startsWith("kd.isc.iscx.platform.core.res.runtime.job")) {
            throw new IllegalArgumentException(name);
        }
        SUB_TASK_QUEUE.submit(task);
    }

    private final class SubTask
    implements LightTask {
        private String id = UUID.randomUUID().toString();
        private List<String> tasks;

        private SubTask(List<String> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void run() {
            DataCopyRunner.this.incSubTaskCount();
            try {
                SignalManager.registerOnSubTaskBegin(this.tasks);
                Pair<TraceType, DynamicObject> p = DataCopyRunner.this.param.getTraceInfo();
                this.doCopyWithTrace((TraceType)((Object)p.getKey()), (DynamicObject)p.getValue());
            }
            catch (Throwable e) {
                DataCopyRunner.this.lastError = e;
            }
            finally {
                DataCopyRunner.this.decSubTaskCount();
                DataCopyRunner.this.clearLastRow();
                SignalManager.unregisterOnSubTaskEnd();
            }
        }

        private void doCopyWithTrace(TraceType type, DynamicObject runtime) {
            TraceStack.run(type, runtime, new TraceTask(){

                public void run() {
                    DataCopyRunner.this.checkDisableTrace();
                    DataCopyRunner.this.doCopy();
                }
            });
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    public static interface Collector {
        public void collect(Map<String, Object> var1, Map<String, Object> var2, SaveDataType var3, Throwable var4);
    }
}

