/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.ExecutionLogRedoJobFactory;
import kd.isc.iscb.platform.core.dc.e.ExecutionLogRetry;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.misc.StringUtil;

public class ExecutionLogRedoJob
implements Job {
    public static final JobFactory FACTORY = new ExecutionLogRedoJobFactory();
    private static Log logger = LogFactory.getLog(ExecutionLogRedoJob.class);
    private List<Object> logIds;
    private transient AtomicInteger success = new AtomicInteger(0);
    private transient AtomicInteger failed = new AtomicInteger(0);
    private transient AtomicInteger ommitted = new AtomicInteger(0);
    private volatile transient String judgefields;
    private Throwable error;

    public ExecutionLogRedoJob(List<Object> logIds) {
        this.logIds = logIds;
    }

    @Override
    public String getParam() {
        return ExecutionLogRedoJobFactory.getParam(this.logIds);
    }

    @Override
    public String getTitle() {
        return String.format(ResManager.loadKDString((String)"\u65e5\u5fd7\u91cd\u505a\uff08%s\uff09", (String)"ExecutionLogRedoJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.logIds.size());
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        for (Object id : this.logIds) {
            SignalManager.checkCancelSignal();
            DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_copy_exec_log");
            this.judgefields = D.s((Object)log.getString("judgefields"));
            if (D.s((Object)log.get("source_data_tag")) != null) {
                this.retry(log);
                continue;
            }
            this.omit(log);
        }
        if (this.error != null) {
            throw D.e((Throwable)this.error);
        }
    }

    private void omit(DynamicObject log) {
        DataCopyTask.omitLog(log);
        this.ommitted.incrementAndGet();
    }

    private void retry(DynamicObject log) {
        block2: {
            try {
                ExecutionLogRetry.execute(log);
                this.success.incrementAndGet();
            }
            catch (Throwable e) {
                this.failed.incrementAndGet();
                logger.error("\u65e5\u5fd7\u91cd\u8bd5\u6267\u884c\u51fa\u9519\uff1a" + StringUtil.getCascadeMessage((Throwable)e), e);
                if (e instanceof HandledException) break block2;
                this.error = e;
                DataCopyTask.updateLog(log, e);
            }
        }
    }

    @Override
    public String getJobSummary() {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5904\u7406\u4e86 %1$s \u6761\u65e5\u5fd7\uff0c\u5176\u4e2d\uff1a\u6210\u529f %2$s\u6761\uff0c\u5ffd\u7565 %3$s\u6761\uff0c\u5931\u8d25 %4$s\u6761\u3002", (String)"ExecutionLogRedoJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.logIds.size(), this.success, this.ommitted, this.failed);
    }

    @Override
    public String refreshProgress() {
        return String.format(ResManager.loadKDString((String)"%1$s/%2$s\uff0c\u5176\u4e2d\uff1a\u6210\u529f %3$s\u6761\uff0c\u5ffd\u7565 %4$s\u6761\uff0c\u5931\u8d25 %5$s\u6761\u3002", (String)"ExecutionLogRedoJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.getCount(), this.logIds.size(), this.success, this.ommitted, this.failed);
    }

    private int getCount() {
        return this.success.get() + this.ommitted.get() + this.failed.get();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        StringBuilder sb = new StringBuilder();
        if (this.judgefields != null) {
            sb.append(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\uff1a%1$s...\r\n", (String)"ExecutionLogRedoJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.judgefields));
        }
        sb.append(String.format(ResManager.loadKDString((String)"\u5df2\u5904\u7406 %1$s\u6761\uff0c\u5176\u4e2d\uff1a\u6210\u529f %2$s\u6761\uff0c\u5ffd\u7565 %3$s\u6761\uff0c\u5931\u8d25 %4$s\u6761\u3002", (String)"ExecutionLogRedoJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.getCount(), this.success, this.ommitted, this.failed));
        return new Job.Progress(this.logIds.size(), this.getCount(), sb.toString());
    }
}

