/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyRunner;
import kd.isc.iscb.platform.core.dc.e.ExecutionLogReader;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.dc.e.p.ViewUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.io.SingleAsReader;
import kd.isc.iscb.util.misc.StringUtil;

public class ExecutionLogRetry {
    private static Log logger = LogFactory.getLog(ExecutionLogRetry.class);

    public static void execute(Object id) {
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_copy_exec_log");
        ExecutionLogRetry.execute(log);
    }

    public static void execute(List<Object> pkIds) {
        DynamicObject[] logs;
        for (DynamicObject log : logs = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_data_copy_exec_log"))) {
            ExecutionLogRetry.execute(log);
        }
    }

    public static void execute(DynamicObject log) throws HandledException {
        block13: {
            Map<String, Object> map = ExecutionLogRetry.getSrcDataFromLog(log);
            try (DLock lock = DLock.create((String)("/isc/iscb/redo_log/" + log.get("id"))).fastMode();){
                if (lock.tryLock()) {
                    Map<String, Object> data = ExecutionLogRetry.reLoadSrcData(log, map);
                    ExecutionLogRetry.run(log, data);
                    break block13;
                }
                throw new IscBizException(ResManager.loadKDString((String)"\u65e5\u5fd7\u91cd\u505a\u529f\u80fd\u5df2\u7ecf\u89e6\u53d1\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c", (String)"ExecutionLogRetry_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
        }
    }

    public static Map<String, Object> reLoadSrcData(DynamicObject log, Map<String, Object> map) {
        Map<String, Object> data = ExecutionLogRetry.query(log, map);
        if (data == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6839\u636e\u6e90\u5355\u5185\u5bb9\u4ece\u6765\u6e90\u7cfb\u7edf\u672a\u80fd\u67e5\u5230\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u505a\u3002", (String)"ExecutionLogRetry_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return data;
    }

    public static Map<String, Object> getSrcDataFromLog(DynamicObject log) {
        Assert.notNull((Object)log, (String)ResManager.loadKDString((String)"\u65e5\u5fd7\u5bf9\u8c61\u4e3a\u7a7a!", (String)"ExecutionLogRetry_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        String srcData = log.getString("source_data_tag");
        if (StringUtil.isEmpty((String)srcData)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u91cd\u505a!", (String)"ExecutionLogRetry_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!srcData.startsWith("{") || !srcData.endsWith("}")) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u5185\u5bb9\u4e0d\u662f\u5355\u884c\u6570\u636e\u6216\u56e0\u4e3a\u592a\u957f\u5df2\u622a\u65ad\uff0c\u6682\u4e0d\u652f\u6301\u91cd\u505a!", (String)"ExecutionLogRetry_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return JSON.parseObject((String)srcData.replace("\n", "").replace("\t", ""));
    }

    public static void run(DynamicObject log, Map<String, Object> data) throws HandledException {
        DynamicObject execution = BusinessDataServiceHelper.loadSingle((Object)log.get("data_copy_execution_id"), (String)"isc_data_copy_execution");
        ExecutionLogReader reader = new ExecutionLogReader();
        DataCopyRunner runner = new DataCopyRunner(execution, reader, null, null);
        try {
            String sourceDataTag = D.s((Object)execution.get("source_data_tag"));
            if (sourceDataTag != null) {
                ExecutionLogRetry.initReaderBySourceDataTag(data, reader, runner, sourceDataTag);
            } else {
                reader.init(data);
            }
            runner.run();
            DataCopyTask.updateLog(log, runner, null);
        }
        catch (Throwable e) {
            DataCopyTask.updateLog(log, runner, e);
            throw new HandledException(e);
        }
    }

    private static void initReaderBySourceDataTag(Map<String, Object> data, ExecutionLogReader reader, DataCopyRunner runner, String sourceDataTag) {
        Object o = JSON.parse((String)sourceDataTag);
        if (o instanceof Map && D.x(((Map)o).get("$is_filter"))) {
            reader.init(data);
        } else {
            reader.init(runner.getParam(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> query(DynamicObject log, Map<String, Object> map) {
        DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)log.get("data_copy_schema_id"), (String)"isc_data_copy");
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(dataCopy));
        try {
            Map<String, Object> map2 = ExecutionLogRetry.query(log, map, dataCopy);
            return map2;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    /*
     * Loose catch block
     */
    private static Map<String, Object> query(DynamicObject log, Map<String, Object> map, DynamicObject dataCopy) {
        DynamicObject trigger = null;
        if (log.getLong("data_copy_trigger_id") != 0L) {
            trigger = BusinessDataServiceHelper.loadSingle((Object)log.getLong("data_copy_trigger_id"), (String)"isc_data_copy_trigger");
        }
        if (ExecutionLogRetry.isDeleteSchema(dataCopy) || ExecutionLogRetry.isMessageDriven(trigger)) {
            return map;
        }
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)dataCopy.getString("source_schema_id"), (String)"isc_metadata_schema");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataCopy.get("data_source_id"), (String)"isc_data_source");
        ObjectReader<? extends Map<String, Object>> reader = null;
        try {
            try (ConnectionWrapper cn = ConnectionManager.getConnection((Long)dataSource.get("dblink_id"));){
                reader = ExecutionLogRetry.query(cn, dataCopy, meta, map);
                Map data = (Map)reader.read();
                if (data == null && ExecutionLogRetry.isEventDriven(trigger)) {
                    Map<String, Object> map2 = map;
                    return map2;
                }
                Map map3 = data;
                return map3;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            DbUtil.close(reader);
        }
    }

    public static boolean isMessageDriven(DynamicObject trigger) {
        return trigger != null && "message".equals(trigger.getString("trigger_type"));
    }

    private static boolean isEventDriven(DynamicObject trigger) {
        return trigger != null && "event".equals(trigger.getString("trigger_type"));
    }

    public static boolean isDeleteSchema(DynamicObject dataCopy) {
        DynamicObjectCollection targetActions = dataCopy.getDynamicObjectCollection("target_actions");
        for (DynamicObject action : targetActions) {
            String actionNumber = action.getString("tar_action_type");
            if (!"delete".equalsIgnoreCase(actionNumber)) continue;
            return true;
        }
        return false;
    }

    private static ObjectReader<? extends Map<String, Object>> query(ConnectionWrapper cn, DynamicObject dataCopy, DynamicObject meta, Map<String, Object> map) {
        String type = meta.getString("type");
        if ("TABLE".equals(type) || "VIEW".equals(type)) {
            return ExecutionLogRetry.queryTable(cn, meta, map);
        }
        if ("ENTITY".equals(type)) {
            return ExecutionLogRetry.queryEntity(cn, dataCopy, meta, ExecutionLogRetry.getEntityFilter(meta, map));
        }
        return new SingleAsReader(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectReader<? extends Map<String, Object>> queryTable(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> map) {
        Table table;
        String table_name;
        String pk = ExecutionLogRetry.getPrimaryKey(meta, map, "fid");
        Object value = map.get(pk);
        if (value == null) {
            logger.warn("\u6e90\u5355\u6570\u636e\u4e2d\u6ca1\u6709\u4e3b\u952e\u503c\uff0c\u5c06\u53d6\u65e5\u5fd7\u4e2d\u7684\u6570\u636e\u91cd\u505a.");
            return new SingleAsReader(map);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        values.add(value);
        if (value instanceof Number) {
            types.add(-5);
        } else {
            types.add(12);
        }
        if ("VIEW".equals(meta.get("type"))) {
            table_name = "(" + ViewUtil.getSQL(meta) + ") ISC_SOURCE_VIEW ";
            table = ViewUtil.getSchema(meta, cn);
        } else {
            table = ConnectionManager.getTable(cn, meta.getString("table_name"));
            table_name = table.getQuotedName();
        }
        Column pkc = table.getField(pk);
        String sql = "select " + ExecutionLogRetry.getTableFields((Schema)table) + " from " + table_name + " where " + (pkc == null ? pk : pkc.getBinding()) + " = ?";
        try (ObjectReader<DataRow> ds = cn.executeQuery(sql, values, types);){
            SingleAsReader singleAsReader;
            ArrayList<DataRow> list = new ArrayList<DataRow>(2);
            DataRow row = (DataRow)ds.read();
            while (row != null) {
                list.add(row);
                if (list.size() > 1) break;
                row = (DataRow)ds.read();
            }
            switch (list.size()) {
                case 1: {
                    singleAsReader = new SingleAsReader(list.get(0));
                    return singleAsReader;
                }
                case 0: {
                    logger.warn("\u6e90\u5355\u6570\u636e\u672a\u67e5\u5230\uff0c\u5c06\u53d6\u65e5\u5fd7\u4e2d\u7684\u6570\u636e\u91cd\u505a.");
                    singleAsReader = new SingleAsReader(map);
                    return singleAsReader;
                }
            }
            logger.warn("\u6e90\u5355\u6570\u636e\u67e5\u5230\u591a\u884c\uff0c\u5c06\u53d6\u65e5\u5fd7\u4e2d\u7684\u6570\u636e\u91cd\u505a.");
            singleAsReader = new SingleAsReader(map);
            return singleAsReader;
        }
    }

    private static StringBuilder getTableFields(Schema table) {
        StringBuilder sb = new StringBuilder();
        int j = table.getFieldCount();
        for (int i = 0; i < j; ++i) {
            Column c = table.getField(i);
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(c.getBinding());
        }
        return sb;
    }

    public static ObjectReader<? extends Map<String, Object>> queryEntity(ConnectionWrapper cn, DynamicObject dataCopy, DynamicObject meta, Map<String, Object> entityFilter) {
        Map<String, Object> requires = SQLUtil.prepareRequires(dataCopy);
        return ConnectionManager.query(cn, meta.getString("full_name"), requires, Collections.singletonList(entityFilter), Collections.emptyList());
    }

    private static String getPrimaryKey(DynamicObject meta, Map<String, Object> map, String defaultPK) {
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject o : properties) {
            if (!o.getBoolean("is_primary_key") || !map.containsKey(o.getString("prop_name"))) continue;
            return o.getString("prop_name");
        }
        return defaultPK;
    }

    private static Map<String, Object> getEntityFilter(DynamicObject meta, Map<String, Object> map) {
        Object pkValue;
        Object key = map.get("$pk");
        if (key != null) {
            pkValue = map.containsKey("$keyMapping") ? map.get("$id") : map.get("$" + key);
        } else {
            key = ExecutionLogRetry.getPrimaryKey(meta, map, "id");
            pkValue = map.get(key);
        }
        if (pkValue == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6e90\u5355\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u4e3b\u952e\u503c!", (String)"ExecutionLogRetry_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("filter_column", key);
        filter.put("filter_compare", "=");
        filter.put("filter_value", pkValue);
        return filter;
    }
}

