/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.dc.e.FilterEvaluator;
import kd.isc.iscb.platform.core.dc.e.FilterItem;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.Script;

public class Filter {
    private Script script;
    private List<Map<String, Object>> filter_entries;

    public List<Map<String, Object>> getFilter_entries() {
        return this.filter_entries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.filter_entries.size(); ++i) {
            Map<String, Object> filterEntry = this.filter_entries.get(i);
            if (filterEntry == null) continue;
            sb.append(this.trim(filterEntry.get("filter_left_bracket")));
            sb.append(this.trim(filterEntry.get("filter_column")));
            sb.append(' ');
            sb.append(FilterEvaluator.getCompareLabelTitle(this.trim(filterEntry.get("filter_compare"))));
            sb.append(' ');
            sb.append(this.trim(filterEntry.get("filter_value")));
            sb.append(this.trim(filterEntry.get("filter_right_bracket")));
            this.appendFilterLink(this.filter_entries, sb, i);
        }
        return sb.toString();
    }

    public Filter(List<Map<String, Object>> filter_entries) {
        this.filter_entries = filter_entries;
        StringBuilder sb = new StringBuilder();
        HashMap<String, FilterEvaluator> ctx = new HashMap<String, FilterEvaluator>();
        for (int i = 0; i < filter_entries.size(); ++i) {
            Map<String, Object> filterEntry = filter_entries.get(i);
            if (filterEntry == null) continue;
            FilterEvaluator filterEvaluator = this.getFilterEvaluator(i, filterEntry);
            ctx.put(filterEvaluator.getName(), filterEvaluator);
            sb.append(this.trim(filterEntry.get("filter_left_bracket")));
            sb.append(this.trim(filterEvaluator.getName()));
            sb.append(this.trim(filterEntry.get("filter_right_bracket")));
            this.appendFilterLink(filter_entries, sb, i);
        }
        if (sb.length() > 0) {
            this.script = Script.compile((String)sb.toString(), ctx);
        }
    }

    private String trim(Object o) {
        String s = D.s((Object)o);
        if (s == null) {
            return "";
        }
        return s;
    }

    private void appendFilterLink(List<Map<String, Object>> filter_entries, StringBuilder sb, int n) {
        if (n < filter_entries.size() - 1) {
            if ("OR".equals(D.s((Object)filter_entries.get(n).get("filter_link")))) {
                sb.append("||");
            } else {
                sb.append("&&");
            }
        }
    }

    private FilterEvaluator getFilterEvaluator(int n, Map<String, Object> filterEntry) {
        String filter_value_fixed = D.s((Object)filterEntry.get("filter_value"));
        String filter_compare = D.s((Object)filterEntry.get("filter_compare"));
        String filter_column = D.s((Object)filterEntry.get("filter_column"));
        FilterItem filterItem = new FilterItem(filter_column, filter_compare, filter_value_fixed);
        return new FilterEvaluator("e" + n, filterItem);
    }

    public boolean matches(Map<String, Object> data) {
        if (this.script == null) {
            return true;
        }
        HashMap<String, Map<String, Object>> ctx = new HashMap<String, Map<String, Object>>();
        ctx.put("data", data);
        return D.x((Object)this.script.eval(ctx));
    }

    public static boolean isIgnoredFilterItem(Object value) {
        return "*".equals(value);
    }
}

