/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.HashMap;
import java.util.Map;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.accessor.TestedBeforeNameAccessor;
import kd.isc.iscb.util.script.core.Reference;

public class FilterItem {
    private String columnName;
    private Script valueExpr;
    private String compareLabel;
    private String compareValue;

    public FilterItem(String columnName, String compareLabel, String compareValue) {
        this.columnName = columnName;
        this.compareLabel = compareLabel;
        this.compareValue = compareValue;
        if (columnName.indexOf(46) >= 0) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(".", new TestedBeforeNameAccessor());
            if (this.isValidVariable(columnName)) {
                this.addVariables(columnName, ctx);
            }
            this.valueExpr = Script.compile((String)columnName, ctx);
        }
    }

    private void addVariables(String columnName, Map<String, Object> ctx) {
        String[] varNames;
        for (String varName : varNames = columnName.split("\\.")) {
            ctx.put(varName, Reference.create((String)varName));
        }
    }

    private boolean isValidVariable(String columnName) {
        for (int j = 0; j < columnName.length(); ++j) {
            char c = columnName.charAt(j);
            if (this.isValidChar(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '.';
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getValue(Map<String, Object> data) {
        if (this.valueExpr != null) {
            return this.valueExpr.eval(data);
        }
        return data.get(this.columnName);
    }

    public String getCompareLabel() {
        return this.compareLabel;
    }

    public String getCompareValue() {
        return this.compareValue;
    }
}

