/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.dc.e.MQueueWriter;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectWriter;

public class MMQueueWriter
implements ObjectWriter<Map<String, Object>> {
    private List<MQueueWriter> queues;

    MMQueueWriter(DataCopyConsumer param) {
        List<DynamicObject> list = param.getPublisherQueueList();
        int topicCount = list.size();
        this.queues = new ArrayList<MQueueWriter>(topicCount);
        for (DynamicObject publisher : list) {
            this.queues.add(new MQueueWriter(param, publisher, topicCount));
        }
    }

    public void write(Map<String, Object> o) {
        Throwable err = null;
        for (MQueueWriter q : this.queues) {
            try {
                q.write(o);
            }
            catch (Throwable e) {
                err = e;
            }
        }
        if (err != null) {
            throw D.e(err);
        }
    }

    public void close() {
        Throwable err = null;
        for (MQueueWriter q : this.queues) {
            try {
                q.close();
            }
            catch (Throwable e) {
                err = e;
            }
        }
        MQueueWriter.disposeForMultiTopicMode();
        if (err != null) {
            throw D.e(err);
        }
    }

    public void commit() {
        Throwable err = null;
        for (MQueueWriter q : this.queues) {
            try {
                q.commit();
            }
            catch (Throwable e) {
                err = e;
            }
        }
        if (err != null) {
            throw D.e(err);
        }
    }

    public boolean rollback(Throwable cause) {
        Throwable err = null;
        for (MQueueWriter q : this.queues) {
            try {
                q.rollback(cause);
            }
            catch (Throwable e) {
                err = e;
            }
        }
        if (err != null) {
            throw D.e(err);
        }
        return false;
    }
}

