/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.d;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.e.d.EntryCollectionType;
import kd.isc.iscb.platform.core.dc.e.d.MapValueType;
import kd.isc.iscb.platform.core.dc.e.d.MultiLangStringK3CType;
import kd.isc.iscb.platform.core.dc.e.d.MultiLangStringType;
import kd.isc.iscb.platform.core.dc.e.d.ObjectRefType;
import kd.isc.iscb.platform.core.dc.e.d.SimpleValueType;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;

public class Util {
    public static DynamicObject findMetaSchema(long dataSourceId, String entityNumber) {
        QFilter filter = new QFilter("number", "=", (Object)entityNumber).and(new QFilter("group", "=", (Object)dataSourceId));
        DynamicObject[] schemas = BusinessDataServiceHelper.load((String)"isc_metadata_schema", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"createtime");
        if (schemas.length >= 1) {
            return BusinessDataServiceHelper.loadSingle((Object)schemas[0].getPkValue(), (String)"isc_metadata_schema");
        }
        if ("bos_attachment".equals(entityNumber) || "bd_attachment".equals(entityNumber)) {
            return Util.syncAttachment(dataSourceId, entityNumber);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u662f\uff08%s\uff09\u7684\u5143\u6570\u636e\u672a\u627e\u5230\u3002", (String)"Util_26", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityNumber));
    }

    private static DynamicObject syncAttachment(long dataSourceId, String entity) {
        DynamicObject ds = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        DynamicObject link = BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (String)"database_type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ds.getLong("dblink_id"))});
        String type = D.s((Object)link.get("database_type"));
        if ("ierp".equals(type) || "self".equals(type)) {
            HashMap<String, MetaType> metas = new HashMap<String, MetaType>(2);
            metas.put(entity, MetaType.ENTITY);
            Object id = MetaSchemaUtil.syncMetaBasic(ds, metas.entrySet().iterator().next());
            MetaSchemaUtil.syncMetaSchema(id);
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_metadata_schema");
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u662f\uff08%s\uff09\u7684\u5143\u6570\u636e\u672a\u627e\u5230\u3002", (String)"Util_26", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
    }

    public static Map<String, DataType> getProperties(DynamicObject schema) {
        LinkedHashMap<String, DataType> properties = new LinkedHashMap<String, DataType>();
        DynamicObjectCollection prop_entryentity = (DynamicObjectCollection)schema.get("prop_entryentity");
        for (DynamicObject p : prop_entryentity) {
            DataType dt = Util.getDataType(schema, p);
            String name = p.getString("prop_name");
            properties.put(name, dt);
        }
        return properties;
    }

    public static String getLongestEntryProperty(Map<String, DataType> properties, String propName) {
        if (properties == null || propName == null) {
            return null;
        }
        String[] path = propName.split("\\.");
        if (path.length > 1) {
            String name;
            DataType type;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < path.length && (type = properties.get(name = path[i])) instanceof EntryCollectionType; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(name);
                properties = ((EntryCollectionType)type).getProperties();
            }
            return D.s((Object)sb);
        }
        return null;
    }

    private static DataType getDataType(DynamicObject schema, DynamicObject p) {
        String data_type = D.s((Object)p.get("data_type"));
        if ("REF".equals(data_type)) {
            return ObjectRefType.INS;
        }
        if ("ml_string".equals(data_type)) {
            return MultiLangStringType.INS;
        }
        if ("ml_string_k3c".equals(data_type)) {
            return MultiLangStringK3CType.INS;
        }
        if ("ENTRIES".equals(data_type)) {
            return new EntryCollectionType(schema.getLong("group_id"), p.getString("data_schema"));
        }
        if (Util.isMapType(data_type)) {
            return MapValueType.INS;
        }
        return SimpleValueType.INS;
    }

    private static boolean isMapType(String data_type) {
        return "struct".equalsIgnoreCase(data_type) || "map".equalsIgnoreCase(data_type) || "meta".equalsIgnoreCase(data_type);
    }
}

