/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.p;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.GeneralSchema;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;

public class ViewUtil {
    private static final String FULL_NAME = "full_name";

    public static Map<String, Object> getViewInfo(ConnectionWrapper cn, DynamicObject meta) {
        String sql = ViewUtil.getSQL(meta);
        HashMap<String, Object> view_info = new HashMap<String, Object>();
        view_info.put(FULL_NAME, meta.get(FULL_NAME));
        view_info.put("name", "V_" + Hash.mur32((Object[])new Object[]{sql}));
        view_info.put("type", "VIEW");
        Object title = meta.getString("name");
        if (title == null) {
            title = meta.get(FULL_NAME);
        }
        view_info.put("title", title);
        view_info.put("table_name", null);
        List<Map<String, Object>> properties = cn.getProperties(sql);
        view_info.put("properties", properties);
        return view_info;
    }

    private static void checkPrimaryKey(List<Map<String, Object>> properties) {
        for (Map<String, Object> field : properties) {
            Object name = field.get("name");
            if (!"id".equals(name) && !"fid".equals(name) && !"_id".equals(name)) continue;
            field.put("is_primary_key", Boolean.TRUE);
        }
    }

    public static List<Map<String, Object>> getProperties(Connection cn, String topSql) {
        List<Map<String, Object>> properties;
        Statement smt = null;
        ResultSet rs = null;
        try {
            smt = cn.createStatement();
            rs = smt.executeQuery(topSql);
            GeneralSchema schema = new GeneralSchema(rs.getMetaData());
            properties = AbstractConnectionFactory.getProperties((Schema)schema);
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.SQL_QUERY_FAILURE.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close((Statement)smt, rs);
                throw throwable;
            }
        }
        DbUtil.close((Statement)smt, (ResultSet)rs);
        ViewUtil.checkPrimaryKey(properties);
        return properties;
    }

    public static String getSQL(DynamicObject meta) {
        String sql = D.s((Object)meta.get("view_sql_tag"));
        if (sql == null) {
            sql = D.s((Object)meta.get("view_sql"));
        }
        if (sql == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08%s\uff09\u6ca1\u6709\u8bbe\u7f6e\u89c6\u56feSQL\u3002", (String)"ViewUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.get(FULL_NAME)));
        }
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    public static Schema getSchema(DynamicObject meta, ConnectionWrapper cn) {
        ArrayList<Column> fields = new ArrayList<Column>();
        String pk = null;
        for (DynamicObject i : meta.getDynamicObjectCollection("prop_entryentity")) {
            String name = D.s((Object)i.get("prop_name"));
            if (D.x((Object)i.get("is_primary_key"))) {
                pk = pk == null ? name : "";
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("COLUMN_NAME", name);
            data.put("IS_NULLABLE", !D.x((Object)i.get("required")));
            String data_type = D.s((Object)i.get("data_type"));
            int index = data_type.indexOf(40);
            if (index > 0) {
                data_type = data_type.substring(0, index);
            }
            data.put("DATA_TYPE", DataTypeUtil.getSqlType((String)data_type));
            data.put("COLUMN_SIZE", -1);
            data.put("DECIMAL_DIGITS", -1);
            data.put("TYPE_NAME", data_type);
            fields.add(new Column(data, fields.size(), cn.getQuot()));
        }
        String sql = ViewUtil.getSQL(meta);
        return new GeneralSchema(fields, pk, " (" + sql + ") ISC_VIEW ");
    }
}

