/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.s;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.constant.TimestampStatus;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.DataCopyTsLog;
import kd.isc.iscb.platform.core.dc.e.s.SourceDataDecorator;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.util.dt.D;

public class TimeStampDataDecorator
implements SourceDataDecorator {
    @Override
    public void registerLine(DataCopyParam dataCopyParam) {
        DataCopyDebugger.registerLine(dataCopyParam, "ts_check", ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u65f6\u95f4\u6233\u68c0\u67e5", (String)"TimeStampDataDecorator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void decorate(Map<String, Object> data, DataCopyProvider param) {
        DataCopyDebugger.trap(param, "ts_check", data, null);
        DynamicObject tsLog = DataCopyTsLog.queryTsLog(param, data);
        TimestampStatus status = TimeStampDataDecorator.calcStatus(tsLog, data, param);
        data.put("#_TS_STATUS", (Object)status);
        if (TimestampStatus.NOT_CHANGED == status) {
            data.put("#_IGNORE_TAG", Boolean.TRUE);
        }
    }

    public static TimestampStatus calcStatus(DynamicObject tsLog, Map<String, Object> src, DataCopyProvider param) {
        if (tsLog == null) {
            return TimestampStatus.NOT_FOUND;
        }
        String tsLogTsStr = D.s((Object)tsLog.get("timestamp"));
        String srcTs = DataCopyTsLog.calcProperTsValue(src.get(param.getSourceTsField()));
        if (tsLogTsStr != null) {
            return TimeStampDataDecorator.handleLogTsNotNull(tsLog, param, tsLogTsStr, srcTs);
        }
        return TimeStampDataDecorator.handleLogTsNull(tsLog, param, srcTs);
    }

    private static TimestampStatus handleLogTsNull(DynamicObject tsLog, DataCopyProvider param, String srcTs) {
        if (srcTs == null) {
            return TimeStampDataDecorator.getStatusWhenTsEqual(tsLog, param);
        }
        return TimestampStatus.CHANGED;
    }

    private static TimestampStatus handleLogTsNotNull(DynamicObject tsLog, DataCopyProvider param, String tsLogTsStr, String srcTs) {
        if (!tsLogTsStr.equals(srcTs)) {
            return TimestampStatus.CHANGED;
        }
        return TimeStampDataDecorator.getStatusWhenTsEqual(tsLog, param);
    }

    private static TimestampStatus getStatusWhenTsEqual(DynamicObject tsLog, DataCopyProvider param) {
        String executionId = param.getExecutionId();
        if (executionId != null && executionId.equals(D.s((Object)tsLog.get("task_id")))) {
            return TimestampStatus.EVER_HANDLED;
        }
        return TimestampStatus.NOT_CHANGED;
    }
}

