/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v;

import java.math.BigDecimal;
import java.util.Map;
import kd.isc.iscb.platform.core.dc.e.v.Evaluator;
import kd.isc.iscb.platform.core.dc.e.v.PropertyAssembler;
import kd.isc.iscb.platform.core.dc.e.v.PropertyEvaluator;
import kd.isc.iscb.platform.core.dc.meta.DataCopyTransformer;
import kd.isc.iscb.util.dt.D;

public class AnalysisEvaluator
implements Evaluator {
    private String expr;

    public AnalysisEvaluator(String expr) {
        this.expr = expr;
    }

    public String toString() {
        return this.expr;
    }

    @Override
    public int level() {
        return -1;
    }

    @Override
    public Object eval(DataCopyTransformer param, Map<String, Object> data, PropertyAssembler assembler) {
        if ("${seq}".equals(this.expr)) {
            return AnalysisEvaluator.generateSequence(data, assembler.getPath());
        }
        if (this.expr.startsWith("${acc(")) {
            return AnalysisEvaluator.calcAccumulation(data, this.expr, assembler.getPath());
        }
        throw new UnsupportedOperationException("TODO - " + this.expr);
    }

    public static Object generateSequence(Map<String, Object> data, String[] path) {
        Object[] list = (Object[])PropertyEvaluator.getValue(data, path);
        AnalysisEvaluator.generateSequence(list);
        return list;
    }

    private static void generateSequence(Object[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        if (list[0] instanceof Object[]) {
            for (int i = 0; i < list.length; ++i) {
                AnalysisEvaluator.generateSequence((Object[])list[i]);
            }
        } else {
            for (int i = 0; i < list.length; ++i) {
                list[i] = i + 1;
            }
        }
    }

    public static Object calcAccumulation(Map<String, Object> data, String expr, String[] path) {
        String field;
        path[path.length - 1] = field = expr.substring(expr.indexOf(40) + 1, expr.indexOf(41));
        Object[] list = (Object[])PropertyEvaluator.getValue(data, path);
        return AnalysisEvaluator.calcAccumlation(list);
    }

    private static Object calcAccumlation(Object[] list) {
        if (list.length == 0) {
            return list;
        }
        if (list[0] instanceof Object[]) {
            for (int i = 0; i < list.length; ++i) {
                AnalysisEvaluator.calcAccumlation((Object[])list[i]);
            }
            return list;
        }
        BigDecimal acc = D.n((Object)list[0]);
        for (int i = 1; i < list.length; ++i) {
            acc = acc.add(D.n((Object)list[i]));
            list[i] = acc;
        }
        return list;
    }

    @Override
    public boolean runOnSource() {
        return false;
    }
}

