/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.dc.e.v.Evaluator;
import kd.isc.iscb.platform.core.dc.e.v.FixScriptUtil;
import kd.isc.iscb.platform.core.dc.e.v.PropertyAssembler;
import kd.isc.iscb.platform.core.dc.e.v.PropertyEvaluator;
import kd.isc.iscb.platform.core.dc.meta.DataCopyTransformer;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.connector.s.IDUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.feature.tool.date.DateRange;
import kd.isc.iscb.util.script.feature.tool.date.DateToolKit;

public class ExprEvaluator
implements Evaluator {
    private String expr;
    private boolean run_before_assembling;
    private PropertyAssembler a;

    public static Object calc(Object value, DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        if (!(value instanceof String)) {
            return value;
        }
        String s = D.s((Object)value);
        if (s != null) {
            return ExprEvaluator.handleExpr(param, data, a, s);
        }
        return s;
    }

    public static Object calc(Object value) {
        return ExprEvaluator.calc(value, null, null, null);
    }

    private static Object handleExpr(DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a, String s) {
        if (s.startsWith("#{") && s.endsWith("}")) {
            return ExprEvaluator.translate(s, param, data, a);
        }
        if (s.startsWith("<%") && s.endsWith("%>")) {
            return ExprEvaluator.handleScript(s, param, data, a);
        }
        return s;
    }

    private static Object handleScript(String expr, DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        HashMap<String, Map<String, Object>> ctx = new HashMap<String, Map<String, Object>>();
        ctx.put("src", data);
        if (param != null) {
            ctx.put("params", param.getFilterParams());
        }
        Script script = FixScriptUtil.parseScript(expr, param);
        return script.eval(ctx);
    }

    public static String calcKeys(DynamicObject o, List<String> judgeFields) {
        StringBuilder sb = new StringBuilder();
        for (String key : judgeFields) {
            Object value = o.get(key);
            if (value == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5(%s)\u672a\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u548c\u6e90\u8868\u6570\u636e\u3002", (String)"ExprEvaluator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
            }
            sb.append(value).append('\n');
        }
        return sb.toString();
    }

    private static Object translate(String s, DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        if ("#{null}".equals(s)) {
            return "";
        }
        if ("#{now}".equals(s)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if ("#{today}".equals(s)) {
            return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        }
        if (s.startsWith("#{new_")) {
            return ExprEvaluator.generateId(s, data, a);
        }
        if ("#{ssid}".equals(s)) {
            return param.getSsid();
        }
        if ("#{tenant}".equals(s)) {
            return RequestContext.get().getTenantId();
        }
        if ("#{ssid+','+soid}".equals(s)) {
            return ExprEvaluator.getSsidPlusSoid(param, data);
        }
        if ("#{soid}".equals(s)) {
            return ExprEvaluator.getSoid(param, data);
        }
        if ("#{md5(ssid+','+soid)}".equals(s)) {
            return Hash.md5((String)ExprEvaluator.getSsidPlusSoid(param, data));
        }
        if ("#{md5(soid)}".equals(s)) {
            return Hash.md5((String)D.s((Object)ExprEvaluator.getSoid(param, data)));
        }
        if ("#{mur(soid)}".equals(s)) {
            return Hash.mur64((byte[])D.s((Object)ExprEvaluator.getSoid(param, data)).getBytes(D.UTF_8));
        }
        if ("#{scheduled_time}".equals(s)) {
            return new Timestamp(ExprEvaluator.getDateTime(param));
        }
        if (s.startsWith("#{now-")) {
            return ExprEvaluator.parseTimeStamp(System.currentTimeMillis(), s, 6);
        }
        if (s.startsWith("#{scheduled_time-")) {
            return ExprEvaluator.parseTimeStamp(ExprEvaluator.getDateTime(param), s, 17);
        }
        if (ExprEvaluator.isSuperKeyExpr(s)) {
            return ExprEvaluator.generateKey(s, param, data, a);
        }
        if (s.startsWith("#{replace(")) {
            return ExprEvaluator.replaceSubString(s, data);
        }
        if (s.startsWith("#{rtrim(")) {
            return ExprEvaluator.rtrim(s, data);
        }
        if (s.startsWith("#{boid(")) {
            s = s.substring(s.indexOf(40) + 1, s.indexOf(41));
            String[] path = s.substring(0, s.indexOf(44)).trim().split("\\.");
            byte[] bostype = Hex.decode((String)s.substring(s.indexOf(44) + 1).trim());
            return ExprEvaluator.calcBOSID(param, data, path, bostype);
        }
        if ("#{last_month}".equals(s)) {
            Calendar date = Calendar.getInstance();
            date.add(2, -1);
            return DateRange.calc((Object)DateToolKit.MONTH, (Object)date);
        }
        throw new IllegalArgumentException(s);
    }

    private static long getDateTime(DataCopyTransformer param) {
        Date createdate = param.getExecution().getDate("createtime");
        return createdate.getTime();
    }

    private static Object calcBOSID(DataCopyTransformer param, Map<String, Object> src, String[] path, byte[] bostype) {
        Object value = PropertyEvaluator.getValue(src, path);
        Object boid = ExprEvaluator.newBOSID(value, bostype);
        return boid;
    }

    public static Object newBOSID(Object value, byte[] bostype) {
        return IDUtil.newBOSID((Object)value, (byte[])bostype);
    }

    public static Object newIerpID(Object value) {
        return IDUtil.newIerpID((Object)value);
    }

    private static Object replaceSubString(String s, Map<String, Object> data) {
        int k;
        int i = s.indexOf(40);
        int j = s.indexOf(44);
        String[] patterns = s.substring(j + 1, k = s.indexOf(41)).trim().split(",");
        if (patterns.length % 2 == 1) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u201c%s\u201d\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"ExprEvaluator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s));
        }
        String field = s.substring(i + 1, j).trim();
        String value = D.s((Object)data.get(field));
        if (value == null) {
            return null;
        }
        for (i = 0; i < patterns.length; i += 2) {
            String regex = patterns[i];
            String replacement = patterns[i + 1];
            String s1 = regex.substring(1, regex.length() - 1);
            String s2 = replacement.substring(1, replacement.length() - 1);
            Util.checkPatternStr(data, (String)s1);
            value = value.replaceAll(s1, s2);
        }
        return value;
    }

    private static Object rtrim(String s, Map<String, Object> data) {
        int k;
        int i = s.indexOf(40);
        int j = s.indexOf(44);
        String[] patterns = s.substring(j + 1, k = s.indexOf(41)).trim().split(",");
        if (patterns.length < 1) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u201c%s\u201d\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"ExprEvaluator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s));
        }
        String field = s.substring(i + 1, j).trim();
        String value = D.s((Object)data.get(field));
        if (value == null) {
            return null;
        }
        for (i = 0; i < patterns.length; ++i) {
            String regex = patterns[i];
            String s1 = regex.substring(1, regex.length() - 1);
            if (!value.endsWith(s1)) continue;
            value = value.substring(0, value.lastIndexOf(s1));
            break;
        }
        return value;
    }

    private static boolean isSuperKeyExpr(String expr) {
        return expr.contains("($keys");
    }

    private static Object generateKey(String s, DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        if ("#{md5($keys)}".equals(s)) {
            return ExprEvaluator.calcMd5OfKeys(param, data, a);
        }
        if ("#{mur($keys)}".equals(s)) {
            return ExprEvaluator.calcMur64OfKeys(param, data, a);
        }
        if ("#{md5s18($keys)}".equals(s)) {
            return ExprEvaluator.calcMd5S18OfKeys(param, data, a);
        }
        if ("#{mur32($keys)}".equals(s)) {
            return ExprEvaluator.calcMur32OfKeys(param, data, a);
        }
        if (s.startsWith("#{boid($keys,")) {
            return ExprEvaluator.calcBOSID(param, data, s, a);
        }
        throw new IllegalArgumentException(s);
    }

    private static Object generateId(String s, Map<String, Object> data, PropertyAssembler a) {
        if (a == null) {
            return ExprEvaluator.newId(s);
        }
        Object v = PropertyEvaluator.getValue(data, a.getPath());
        if (v instanceof Object[]) {
            Object[] list = (Object[])v;
            for (int i = 0; i < list.length; ++i) {
                list[i] = ExprEvaluator.newId(s);
            }
            return list;
        }
        return ExprEvaluator.newId(s);
    }

    public static Object newId(String s) {
        if ("#{new_uuid()}".equals(s)) {
            return UUID.randomUUID().toString();
        }
        if ("#{new_int_id()}".equals(s)) {
            return IDService.get().genLongId();
        }
        if ("#{new_int32_id()}".equals(s)) {
            byte[] bytes = StringUtil.toBytes((UUID)UUID.randomUUID());
            return Integer.MAX_VALUE & Hash.mur32((byte[])bytes);
        }
        if ("#{new_string_id()}".equals(s)) {
            byte[] bytes = StringUtil.toBytes((UUID)UUID.randomUUID());
            return new String(Base64.encode((byte[])bytes), StandardCharsets.UTF_8).substring(2, 20).replace('+', '_');
        }
        if (s.startsWith("#{new_boid(")) {
            byte[] bytes = StringUtil.toBytes((UUID)UUID.randomUUID());
            String type = s.substring(s.indexOf(40) + 1, s.indexOf(41));
            byte[] bostype = Hex.decode((String)type);
            return IDUtil.compositeBOID((byte[])bytes, (byte[])bostype);
        }
        throw new UnsupportedOperationException(s);
    }

    private static Object calcMd5OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = ExprEvaluator.calcKeys(param, tar, a);
        return Hash.md5((String)sb);
    }

    private static Object calcMur64OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = ExprEvaluator.calcKeys(param, tar, a);
        return Math.abs(Hash.mur64((byte[])sb.getBytes(D.UTF_8)));
    }

    private static Object calcMd5S18OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = ExprEvaluator.calcKeys(param, tar, a);
        return new String(Base64.encode((byte[])Hash.md5((byte[])sb.getBytes(D.UTF_8))), 0, 18, D.UTF_8).replace('+', '-');
    }

    private static Object calcMur32OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = ExprEvaluator.calcKeys(param, tar, a);
        return Hash.mur64((byte[])sb.getBytes(D.UTF_8));
    }

    private static Object calcBOSID(DataCopyTransformer param, Map<String, Object> tar, String expr, PropertyAssembler a) {
        String sb = ExprEvaluator.calcKeys(param, tar, a);
        byte[] hash = Hash.md5((byte[])sb.getBytes(D.UTF_8));
        byte[] bostype = Hex.decode((String)expr.substring(expr.indexOf(44) + 1, expr.indexOf(41)));
        return IDUtil.compositeBOID((byte[])hash, (byte[])bostype);
    }

    private static String calcKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        List<String> judgeFields = ExprEvaluator.getJudgeFields(param, a);
        return TableUtil.calcKeys(tar, judgeFields);
    }

    private static List<String> getJudgeFields(DataCopyTransformer param, PropertyAssembler a) {
        if (a.getPathLength() == 1) {
            return param.getJudgeFields();
        }
        if (a.getPathLength() == 2) {
            return param.getEntryJudgeFields(a.getPath(0));
        }
        throw new UnsupportedOperationException("TODO-" + a);
    }

    private static Object parseTimeStamp(long timeMillis, String s, int startIndex) {
        if (s.endsWith("day}")) {
            int i = s.indexOf("day}");
            long days = Long.parseLong(s.substring(startIndex, i));
            return new Timestamp(timeMillis - days * 24L * 60L * 60L * 1000L);
        }
        if (s.endsWith("hour}")) {
            int i = s.indexOf("hour}");
            long hours = Long.parseLong(s.substring(startIndex, i));
            return new Timestamp(timeMillis - hours * 60L * 60L * 1000L);
        }
        if (s.endsWith("minute}")) {
            int i = s.indexOf("minute}");
            long mins = Long.parseLong(s.substring(startIndex, i));
            return new Timestamp(timeMillis - mins * 60L * 1000L);
        }
        throw new IllegalArgumentException(s);
    }

    private static String getSsidPlusSoid(DataCopyTransformer param, Map<String, Object> src) {
        Object soid = ExprEvaluator.getSoid(param, src);
        return param.getSsid() + "," + soid;
    }

    private static Object getSoid(DataCopyTransformer param, Map<String, Object> src) {
        String pk = param.getSourcePrimaryKey();
        Object soid = src.get(pk);
        if (soid == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5355\u4e3b\u952e\uff01", (String)"ExprEvaluator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), param.getSourceTable()));
        }
        return soid;
    }

    public ExprEvaluator(String expr, PropertyAssembler a) {
        this.expr = expr;
        this.a = a;
        this.run_before_assembling = !ExprEvaluator.isSuperKeyExpr(expr) && !expr.startsWith("#{new_");
    }

    public String toString() {
        return this.expr;
    }

    @Override
    public int level() {
        return this.a.getPathLength();
    }

    @Override
    public Object eval(DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        Object value = ExprEvaluator.calc(this.expr, param, data, a);
        return value;
    }

    @Override
    public boolean runOnSource() {
        return this.run_before_assembling;
    }

    public boolean isSuperKey() {
        return ExprEvaluator.isSuperKeyExpr(this.expr);
    }
}

