/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v.a;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import kd.isc.iscb.platform.core.dc.e.v.Aggregation;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DataTypeError;

public class DateParser
implements Aggregation {
    private String format;

    public DateParser(String aggr) {
        int i = aggr.indexOf(40);
        if (i > 0) {
            int j = aggr.indexOf(41);
            this.format = aggr.substring(i + 1, j);
        }
    }

    @Override
    public Object calc(Object value, Map<String, Object> src) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.cast(values[i]);
            }
            return value;
        }
        return this.cast(value);
    }

    private Object cast(Object value) {
        if (this.isNull(value)) {
            return null;
        }
        if (this.format == null) {
            return D.t((Object)value);
        }
        String s = D.s((Object)value);
        if (s == null) {
            return null;
        }
        try {
            return new Timestamp(new SimpleDateFormat(this.format).parse(s).getTime());
        }
        catch (ParseException e) {
            throw DataTypeError.INVALID_DATE_STRING.create((Throwable)e, new String[]{s});
        }
    }

    private boolean isNull(Object value) {
        return value == null || "".equals(value);
    }

    @Override
    public Aggregation.RunAt runAt() {
        return Aggregation.RunAt.AFTER_VALUE_CONVERT;
    }
}

