/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.e.ExportDataFileJob;
import kd.isc.iscb.platform.core.dc.f.i.ImportDataFileJob;
import kd.isc.iscb.platform.core.job.JobEngine;

public enum DataFileAction {
    IMPORT{

        @Override
        public String getFormId() {
            return "isc_import_file";
        }

        @Override
        public String getTriggerFormId() {
            return "isc_import_file_trigger";
        }

        @Override
        public String getJobFormId() {
            return "isc_import_file_job";
        }

        @Override
        public String getJobTableName() {
            return "t_iscb_import_file_job";
        }

        @Override
        public String getJobTitle(String schemaNumber) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u8fc1\u79fb\u5bfc\u5165\u65b9\u6848:%s", (String)"DataFileAction_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), schemaNumber);
        }

        @Override
        public String getName() {
            return ResManager.loadKDString((String)"\u6570\u636e\u8fc1\u79fb\u5bfc\u5165", (String)"DataFileAction_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }

        @Override
        public String getTag() {
            return "IM";
        }

        @Override
        public void startJob(DynamicObject job) {
            ImportDataFileJob dataFileJob = new ImportDataFileJob(job);
            JobEngine.submit(dataFileJob);
        }
    }
    ,
    EXPORT{

        @Override
        public String getFormId() {
            return "isc_export_file";
        }

        @Override
        public String getTriggerFormId() {
            return "isc_export_file_trigger";
        }

        @Override
        public String getJobFormId() {
            return "isc_export_file_job";
        }

        @Override
        public String getJobTableName() {
            return "t_iscb_export_file_job";
        }

        @Override
        public String getJobTitle(String schemaNumber) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u8fc1\u79fb\u5bfc\u51fa\u65b9\u6848\uff1a%s", (String)"DataFileAction_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), schemaNumber);
        }

        @Override
        public String getName() {
            return ResManager.loadKDString((String)"\u6570\u636e\u8fc1\u79fb\u5bfc\u51fa", (String)"DataFileAction_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }

        @Override
        public String getTag() {
            return "EX";
        }

        @Override
        public void startJob(DynamicObject job) {
            ExportDataFileJob dataFileJob = new ExportDataFileJob(job);
            JobEngine.submit(dataFileJob);
        }
    };

    private static Map<String, DataFileAction> ACTION_MAP;

    public static DataFileAction getActionByObj(DynamicObject obj) {
        String entityId = obj.getDataEntityType().getName();
        return ACTION_MAP.get(entityId);
    }

    public static DataFileAction getActionByEntityId(String entityId) {
        return ACTION_MAP.get(entityId);
    }

    public abstract String getFormId();

    public abstract String getTriggerFormId();

    public abstract String getJobFormId();

    public abstract String getJobTableName();

    public abstract String getJobTitle(String var1);

    public abstract String getName();

    public abstract String getTag();

    public abstract void startJob(DynamicObject var1);

    static {
        ACTION_MAP = new HashMap<String, DataFileAction>();
        ACTION_MAP.put("isc_export_file", EXPORT);
        ACTION_MAP.put("isc_export_file_trigger", EXPORT);
        ACTION_MAP.put("isc_export_file_job", EXPORT);
        ACTION_MAP.put("isc_import_file", IMPORT);
        ACTION_MAP.put("isc_import_file_trigger", IMPORT);
        ACTION_MAP.put("isc_import_file_job", IMPORT);
    }
}

