/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.constant.ExecutionStatus;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileSchema;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.Json;

public abstract class DataFileJob
implements Job {
    protected static final String TYPE = "type";
    protected static final String ID = "id";
    protected DynamicObject job;
    protected DataFileSchema param;
    protected String title;
    protected DataFileAction action;
    protected String jobId;
    protected Counter counter = new Counter();
    protected volatile ExecutionStatus status = ExecutionStatus.CREATE;

    public DataFileJob(String title, Object jobId, DataFileAction action) {
        this.job = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)action.getJobFormId());
        this.action = action;
        this.title = title;
        this.jobId = D.s((Object)this.job.getPkValue());
    }

    public DataFileJob(DynamicObject job, DataFileAction action) {
        this.job = job;
        this.action = action;
        this.jobId = D.s((Object)job.getPkValue());
    }

    @Override
    public String getParam() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ID, this.jobId);
        return Json.toString(map, (boolean)true);
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            this.title = this.action.getJobTitle(D.s((Object)this.param.fileschema.get("number")));
        }
        return this.title;
    }

    protected void refreshCounter(Map<String, Object> tar) {
        SaveDataType action = (SaveDataType)tar.get("$action");
        if (action == null) {
            action = SaveDataType.SAVE;
        }
        this.tarActionHandle(action);
    }

    protected void tarActionHandle(SaveDataType action) {
        switch (action) {
            case NOP: {
                this.counter.incIgnoredCount(1);
                break;
            }
            case FAILED: {
                this.counter.incFailedCount(1);
                break;
            }
            case EVER_HANDLED: {
                this.counter.incSuccessCount(1);
                break;
            }
            case CANCELLED: {
                break;
            }
            default: {
                this.counter.incSuccessCount(1);
            }
        }
    }

    protected void setFailedAction(Map<String, Object> tar, Throwable e) {
        if (e instanceof TaskCancelException) {
            tar.put("$action", SaveDataType.CANCELLED);
        } else {
            tar.put("$action", SaveDataType.FAILED);
        }
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public DynamicObject getJob() {
        return this.job;
    }

    public DataFileAction getAction() {
        return this.action;
    }

    public DynamicObject getTrigger() {
        return this.param.trigger;
    }

    public DynamicObject getSchema() {
        return this.param.fileschema;
    }
}

