/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dc.e.BizBatchException;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.i.ImportDataFileJob;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class DataFileJobLogger {
    private static final String ACTION = "$action";

    public static void saveStartLog(DynamicObject job, Counter counter) {
        job.set("total_count", (Object)counter.getTotalCount());
        job.set("state", (Object)"R");
        job.set("start_time", (Object)new Date());
        job.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job});
    }

    public static void saveStartLogForImport(DynamicObject job, Counter counter, DataCopyConsumer consumer) {
        job.set("total_count", (Object)counter.getTotalCount());
        job.set("state", (Object)"R");
        job.set("start_time", (Object)new Date());
        job.set("modifytime", (Object)new Date());
        job.set("batch_size", (Object)consumer.getBatchSize());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job});
    }

    public static void saveErrorLog(DynamicObject job, Throwable error, Counter counter) {
        String s = StringUtil.toString((Throwable)error);
        job.set("message", (Object)StringUtil.trim((String)s, (int)150));
        job.set("message_tag", (Object)s);
        job.set("state", (Object)(error instanceof TaskCancelException ? "X" : "F"));
        DataFileJobLogger.setFinalLogProperty(job, counter);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job});
    }

    public static void saveErrorLogForImport(ImportDataFileJob job, Throwable error, Counter counter) {
        job.getJob().set("state", (Object)(error instanceof TaskCancelException ? "X" : "F"));
        DataFileJobLogger.setFinalLogProperty(job.getJob(), counter);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job.getJob()});
        DataFileJobLogger.writeFailLog(null, job, error);
    }

    public static void saveSuccessLog(DynamicObject job, Counter counter) {
        if (counter.getTotalCount() == counter.getSuccessCount() || counter.getTotalCount() == counter.getSuccessCount() + counter.getIgnoredCount()) {
            job.set("state", (Object)"S");
        } else if (counter.getTotalCount() == counter.getFailedCount() || counter.getTotalCount() == counter.getFailedCount() + counter.getIgnoredCount() || counter.getTotalCount() == -1) {
            job.set("state", (Object)"F");
        } else {
            job.set("state", (Object)"P");
        }
        DataFileJobLogger.setFinalLogProperty(job, counter);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job});
    }

    private static void setFinalLogProperty(DynamicObject job, Counter counter) {
        job.set("total_count", (Object)counter.getTotalCount());
        job.set("ignored_count", (Object)counter.getIgnoredCount());
        job.set("success_count", (Object)counter.getSuccessCount());
        job.set("failed_count", (Object)counter.getFailedCount());
        DataFileAction action = DataFileAction.getActionByObj(job);
        job.set("deal_bytes", (Object)(action == DataFileAction.IMPORT ? counter.getLoadBytes() : counter.getReadBytes()));
        job.set("modifytime", (Object)new Date());
        job.set("end_time", (Object)new Date());
    }

    public static void writeSuccessLog(Map<String, Object> tar, ImportDataFileJob job) {
        String action;
        String string = action = tar == null ? null : D.s((Object)tar.get(ACTION));
        if (tar == null) {
            return;
        }
        String message = null;
        message = tar.containsKey("$error_message") ? D.s((Object)tar.remove("$error_message")) : action + "\uff1a" + DataFileJobLogger.getIdentity(tar, job);
        DynamicObject log = DataFileJobLogger.createCommonLog(tar, job, message, null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void writeBatchFailLog(Object data, ImportDataFileJob job, String message) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_import_file_data_log");
        log.set("id", (Object)IDService.get().genLongId());
        log.set("import_file_job", job.getJob().getPkValue());
        log.set("import_trigger", job.getTrigger().getPkValue());
        log.set("import_schema", job.getSchema().getPkValue());
        log.set("server", (Object)NetUtil.getServerId());
        log.set("created_time", (Object)new Date());
        log.set("modified_time", (Object)new Date());
        log.set("state", (Object)"F");
        if (message != null) {
            log.set("message", (Object)DataFileJobLogger.trim(message));
            log.set("message_tag", (Object)message);
        }
        DataFileJobLogger.writeDataToLog(data, log);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void writeFailLog(Map<String, Object> tar, ImportDataFileJob job, Throwable err) {
        String action;
        String string = action = tar == null ? null : D.s((Object)tar.get(ACTION));
        if (err instanceof BizBatchException || err instanceof HandledException) {
            return;
        }
        if (err == null && tar != null && action == null) {
            return;
        }
        String message = StringUtil.toString((Throwable)err);
        DynamicObject log = DataFileJobLogger.createCommonLog(tar, job, message, err);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private static Object getIdentity(Map<String, Object> tar, ImportDataFileJob job) {
        DataCopyConsumer consumer = job.getConsumer();
        Object id = tar.get(consumer.getTargetPrimaryKey());
        if (id == null) {
            id = tar.get("$id");
        }
        return id != null ? id : DataFileJobLogger.getJudgeFieldsValue(tar, consumer.getTargetJudgeFields().get("$"));
    }

    private static String getJudgeFieldsValue(Map<String, Object> tar, List<String> judgeFields) {
        StringBuilder sb = new StringBuilder();
        if (tar != null && judgeFields != null) {
            for (int i = 0; i < judgeFields.size(); ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(tar.get(judgeFields.get(i)));
            }
            if (sb.length() > 255) {
                return sb.substring(0, 255);
            }
        }
        return D.s((Object)sb);
    }

    private static DynamicObject createCommonLog(Map<String, Object> tar, ImportDataFileJob job, String message, Throwable err) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_import_file_data_log");
        log.set("id", (Object)IDService.get().genLongId());
        log.set("import_file_job", job.getJob().getPkValue());
        log.set("import_trigger", job.getTrigger().getPkValue());
        log.set("import_schema", job.getSchema().getPkValue());
        log.set("server", (Object)NetUtil.getServerId());
        log.set("created_time", (Object)new Date());
        log.set("modified_time", (Object)new Date());
        String action = tar == null ? null : D.s((Object)tar.get(ACTION));
        String state = DataFileJobLogger.getLogState(tar, action, err);
        log.set("state", (Object)state);
        DataCopyConsumer consumer = job.getConsumer();
        log.set("judgefields", (Object)DataFileJobLogger.getJudgeFieldsValue(tar, consumer.getTargetJudgeFields().get("$")));
        if (message != null) {
            log.set("message", (Object)DataFileJobLogger.trim(message));
            log.set("message_tag", (Object)message);
        }
        DataFileJobLogger.writeDataToLog(tar, log);
        return log;
    }

    private static void writeDataToLog(Object data, DynamicObject log) {
        log.set("data", (Object)DataFileJobLogger.trim(JSON.toJSONString((Object)data)));
        String json = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        if (data instanceof List) {
            log.set("data_tag", (Object)StringUtil.trim((String)json, (int)800000));
        } else {
            log.set("data_tag", (Object)json);
        }
    }

    private static String trim(String s) {
        if ("null".equals(s)) {
            return "";
        }
        return StringUtil.trim((String)s, (int)150);
    }

    private static String getLogState(Map<String, Object> tar, String action, Throwable err) {
        String state = tar != null && tar.containsKey("$error_message") || SaveDataType.FAILED.name().equals(action) || err != null ? "F" : (SaveDataType.NOP.name().equals(action) ? "N" : "S");
        return state;
    }
}

