/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.dc.f.DataFileReader;
import kd.isc.iscb.platform.core.dc.f.DataFileSchema;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.platform.core.dc.f.DataFileWriter;
import kd.isc.iscb.platform.core.dc.f.Delimiter;
import kd.isc.iscb.platform.core.dc.f.ExportJobFileBinding;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.platform.core.dc.f.FileIterator;
import kd.isc.iscb.platform.core.dc.f.ImportJobFileIterator;
import kd.isc.iscb.platform.core.dc.f.t.csv.CsvFileReader;
import kd.isc.iscb.platform.core.dc.f.t.csv.CsvFileWriter;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelFileReader;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelFileWriter;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelType;
import kd.isc.iscb.platform.core.dc.f.t.json.JsonFileReader;
import kd.isc.iscb.platform.core.dc.f.t.json.JsonFileWriter;
import kd.isc.iscb.platform.core.dc.f.tag.FileTag;
import kd.isc.iscb.platform.core.dc.f.validate.FileValidator;
import kd.isc.iscb.platform.core.dc.f.validate.JsonFileValidator;
import kd.isc.iscb.platform.core.dc.f.validate.XlsFileValidator;
import kd.isc.iscb.platform.core.dc.f.validate.XlsxFileValidator;
import kd.isc.iscb.util.dt.D;

public enum DataFileType {
    JSON{

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, Map<String, Object> requiredFields) throws Exception {
            return new JsonFileWriter(fileBinding, tag);
        }

        @Override
        public DataFileReader createReader(FileIterator iterator) throws Exception {
            return new JsonFileReader(iterator);
        }

        @Override
        public FileValidator createFileValidator(Object dataSourceId) {
            FileTag fileTag = new FileTag(dataSourceId);
            return new JsonFileValidator(fileTag);
        }

        @Override
        public boolean validateFile(Object dataSourceId, String cacheFileUrl) throws Exception {
            FileValidator validator = this.createFileValidator(dataSourceId);
            return validator.validate(cacheFileUrl);
        }

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, DataFileSchema schema) throws Exception {
            return new JsonFileWriter(fileBinding, tag);
        }

        @Override
        public DataFileReader createReader(FileIterator iterator, DataFileSchema schema) throws Exception {
            return new JsonFileReader(iterator);
        }
    }
    ,
    XLSX{

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, Map<String, Object> requiredFields) throws Exception {
            return new ExcelFileWriter(fileBinding, requiredFields, tag, ExcelType.XLSX);
        }

        @Override
        public DataFileReader createReader(FileIterator iterator) throws Exception {
            return new ExcelFileReader(iterator, null, ExcelType.XLSX);
        }

        @Override
        public FileValidator createFileValidator(Object dataSourceId) {
            FileTag fileTag = new FileTag(dataSourceId);
            return new XlsxFileValidator(fileTag);
        }

        @Override
        public boolean validateFile(Object dataSourceId, String cacheFileUrl) throws Exception {
            FileValidator validator = this.createFileValidator(dataSourceId);
            return validator.validate(cacheFileUrl);
        }

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, DataFileSchema schema) throws Exception {
            DynamicObject fileSchema = schema.getFileschema();
            return new ExcelFileWriter(fileBinding, DataFileUtils.buildRequiredFields(fileSchema), tag, ExcelType.XLSX);
        }

        @Override
        public DataFileReader createReader(FileIterator iterator, DataFileSchema schema) throws Exception {
            return new ExcelFileReader(iterator, DataFileType.buildJudgeFields(schema), ExcelType.XLSX);
        }
    }
    ,
    CSV{

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, Map<String, Object> requiredFields) throws Exception {
            return new CsvFileWriter(fileBinding, requiredFields, ",", false);
        }

        @Override
        public FileValidator createFileValidator(Object dataSourceId) {
            return null;
        }

        @Override
        public boolean validateFile(Object dataSourceId, String cacheFileUrl) throws Exception {
            return true;
        }

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, DataFileSchema schema) throws Exception {
            DynamicObject fileSchema = schema.getFileschema();
            String delimiter = Delimiter.getDelimiter(D.s((Object)fileSchema.get("delimiter"))).getValue();
            return new CsvFileWriter(fileBinding, DataFileUtils.buildRequiredFields(fileSchema), delimiter, false);
        }

        @Override
        public DataFileReader createReader(FileIterator iterator, DataFileSchema schema) throws Exception {
            return new CsvFileReader(iterator, ",", false);
        }
    }
    ,
    XLS{

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, Map<String, Object> requiredFields) throws Exception {
            return new ExcelFileWriter(fileBinding, requiredFields, tag, ExcelType.XLS);
        }

        @Override
        public FileValidator createFileValidator(Object dataSourceId) {
            FileTag fileTag = new FileTag(dataSourceId);
            return new XlsFileValidator(fileTag);
        }

        @Override
        public boolean validateFile(Object dataSourceId, String cacheFileUrl) throws Exception {
            FileValidator validator = this.createFileValidator(dataSourceId);
            return validator.validate(cacheFileUrl);
        }

        @Override
        public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, DataFileSchema schema) throws Exception {
            DynamicObject fileSchema = schema.getFileschema();
            return new ExcelFileWriter(fileBinding, DataFileUtils.buildRequiredFields(fileSchema), tag, ExcelType.XLS);
        }

        @Override
        public DataFileReader createReader(FileIterator iterator, DataFileSchema schema) throws Exception {
            return new ExcelFileReader(iterator, DataFileType.buildJudgeFields(schema), ExcelType.XLS);
        }
    };


    @Deprecated
    public DataFileWriter createWriter(FileBinding fileBinding, FileTag tag, Map<String, Object> requiredFields) throws Exception {
        return null;
    }

    @Deprecated
    public DataFileReader createReader(FileIterator iterator) throws Exception {
        return null;
    }

    public abstract FileValidator createFileValidator(Object var1);

    public abstract boolean validateFile(Object var1, String var2) throws Exception;

    public abstract DataFileWriter createWriter(FileBinding var1, FileTag var2, DataFileSchema var3) throws Exception;

    public abstract DataFileReader createReader(FileIterator var1, DataFileSchema var2) throws Exception;

    @Deprecated
    public static DataFileWriter buildWriter(String type, Object dsId, FileBinding fileBinding, Map<String, Object> requiredFields) throws Exception {
        DataFileType TYPE = DataFileType.valueOf(type.toUpperCase());
        FileTag tag = new FileTag(dsId);
        return TYPE.createWriter(fileBinding, tag, requiredFields);
    }

    @Deprecated
    public static DataFileReader buildReader(String type, FileIterator iterator) throws Exception {
        DataFileType TYPE = DataFileType.valueOf(type.toUpperCase());
        return TYPE.createReader(iterator);
    }

    public static DataFileWriter buildWriter(DataFileSchema schema, DynamicObject job) throws Exception {
        DynamicObject trigger = schema.getTrigger();
        DynamicObject fileSchema = schema.getFileschema();
        String fileType = fileSchema.getString("filetype");
        String name = fileSchema.getString("name");
        long maxFileSize = fileSchema.getLong("filesize");
        boolean isCompress = trigger.getBoolean("compress");
        ExportJobFileBinding fileBinding = new ExportJobFileBinding(job.getPkValue(), fileType, name, maxFileSize, isCompress);
        DataFileType TYPE = DataFileType.valueOf(fileType.toUpperCase());
        FileTag tag = new FileTag(schema.getFileschema().get("group_id"));
        return TYPE.createWriter((FileBinding)fileBinding, tag, schema);
    }

    public static DataFileReader buildReader(DataFileSchema schema, DynamicObject job) throws Exception {
        DynamicObject trigger = schema.getTrigger();
        String fileType = trigger.getDynamicObject("file_schema").getString("filetype");
        ImportJobFileIterator iter = new ImportJobFileIterator(job.getPkValue());
        DataFileType TYPE = DataFileType.valueOf(fileType.toUpperCase());
        return TYPE.createReader(iter, schema);
    }

    private static Map<String, List<String>> buildJudgeFields(DataFileSchema schema) {
        DynamicObject schemaObj = schema.getFileschema();
        HashMap<String, List<String>> judgeFields = new HashMap<String, List<String>>();
        for (DynamicObject field : schemaObj.getDynamicObjectCollection("fields")) {
            ArrayList<String> list;
            if (!field.getBoolean("is_judge_key")) continue;
            String name = field.getString("alias");
            if ("".equals(name)) {
                name = field.getString("field");
            }
            String key = "";
            String val = name;
            if (name.contains(".")) {
                int index = name.lastIndexOf(46);
                key = name.substring(0, index);
                val = name.substring(index + 1);
            }
            if ((list = (ArrayList<String>)judgeFields.get(key)) == null) {
                list = new ArrayList<String>();
                judgeFields.put(key, list);
            }
            list.add(val);
        }
        return judgeFields;
    }
}

