/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ExportJobFileBinding
implements FileBinding {
    private Object jobId;
    private long maxFileSize;
    private String fileType;
    private String fileName;
    private boolean isCompress;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    public ExportJobFileBinding(Object jobId, String fileType, String fileName, long maxFileSize, boolean isCompress) {
        this.jobId = jobId;
        this.maxFileSize = maxFileSize * 1024L * 1024L;
        this.fileType = fileType;
        this.fileName = fileName;
        this.isCompress = isCompress;
    }

    @Override
    public void bind(File file) throws IOException {
        if (this.isCompress) {
            this.compressFileAndUploadToServer(file);
        } else {
            this.uploadToFileServer(file, this.getFileName(this.fileType));
        }
    }

    private void compressFileAndUploadToServer(File file) {
        String zipPath = System.getProperty("user.home") + File.separator + "downloads" + File.separator + "temp";
        FileUtil.checkFilePath(zipPath);
        String path = null;
        try {
            path = this.compressFile(file.getAbsolutePath(), zipPath, this.fileName);
            this.uploadToFileServer(new File(path), this.getFileName("zip"));
        }
        catch (IOException e) {
            try {
                throw new IscBizException((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.delete(path);
                throw throwable;
            }
        }
        FileUtil.delete(path);
    }

    @Override
    public long maxFileSize() {
        return this.maxFileSize;
    }

    private String getFileName(String fileType) {
        return FileUtil.replaceSpeChar(this.fileName) + "_" + this.dateFormat.format(new Date()) + "." + fileType;
    }

    private void uploadToFileServer(File file, String fileName) throws IOException {
        long randId = IDService.get().genLongId();
        String appId = "iscb";
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)appId, (String)"isc_export_file_job", (Object)randId, (String)fileName);
        try (FileInputStream input = new FileInputStream(file);){
            FileItem fileItem = new FileItem(fileName, path, (InputStream)input);
            fileItem.setCreateNewFileWhenExists(true);
            String url = FileServiceFactory.getAttachmentFileService().upload(fileItem);
            DynamicObject attachment = DataFileUtils.assignAttachmentValue(randId, fileName, this.fileType, file.length(), url, ResManager.loadKDString((String)"\u76ee\u6807\u6587\u4ef6", (String)"ExportJobFileBinding_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            attachment.set("fbilltype", (Object)"isc_export_file_job");
            attachment.set("fattachmentpanel", (Object)"export_files");
            attachment.set("finterid", this.jobId);
            attachment.set("fmodifymen", (Object)RequestContext.get().getUserId());
            attachment.set("fmodifytime", (Object)D.t((Object)new Date()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
        }
    }

    private String compressFile(String file, String zipPath, String zipName) throws IOException {
        File zipFile = this.createZipFile(zipPath, zipName);
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fos);
             FileInputStream fileInputStream = new FileInputStream(file);){
            int len;
            ZipEntry zipEntry = new ZipEntry(file.substring(file.lastIndexOf(File.separator) + 1));
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            while ((len = fileInputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            FileUtil.delete(zipFile.getAbsolutePath());
            throw e;
        }
        return zipFile.getAbsolutePath();
    }

    private File createZipFile(String path, String zipName) throws IOException {
        boolean created;
        File zipFile = new File(path + File.separator + zipName + ".zip");
        if (!zipFile.getParentFile().exists()) {
            zipFile.getParentFile().mkdirs();
        }
        if (!(created = zipFile.createNewFile())) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"zip\u6587\u4ef6%s\u5df2\u5b58\u5728!", (String)"ExportJobFileBinding_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), zipFile.getAbsolutePath()));
        }
        return zipFile;
    }
}

