/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.e.d.EntryCollectionType;
import kd.isc.iscb.platform.core.dc.e.d.SimpleValueType;
import kd.isc.iscb.platform.core.dc.e.d.Util;
import kd.isc.iscb.platform.core.dc.e.v.Evaluator;
import kd.isc.iscb.platform.core.dc.e.v.PropertyEvaluator;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.misc.StringUtil;

public class SimpleFieldMapping {
    private Map<Evaluator, SimplePropertySetter> FIELD_MAPPING = new HashMap<Evaluator, SimplePropertySetter>();
    private Map<String, DataType> target_properties;

    public SimpleFieldMapping(DynamicObject fileSchema, DataFileAction action) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)fileSchema.get("obj_id"), (String)"isc_metadata_schema");
        this.target_properties = Util.getProperties(meta);
        DynamicObjectCollection fields = fileSchema.getDynamicObjectCollection("fields");
        if (action == DataFileAction.IMPORT) {
            this.initImport(fields);
        } else {
            this.initExport(fields);
        }
    }

    private void initImport(DynamicObjectCollection fields) {
        for (DynamicObject field : fields) {
            String name = field.getString("field");
            String alias = field.getString("alias");
            PropertyEvaluator e = D.s((Object)alias) != null ? new PropertyEvaluator(alias) : new PropertyEvaluator(name);
            SimplePropertySetter p = new SimplePropertySetter(name, this.target_properties);
            this.FIELD_MAPPING.put(e, p);
        }
    }

    private void initExport(DynamicObjectCollection fields) {
        for (DynamicObject field : fields) {
            String name = field.getString("field");
            String alias = field.getString("alias");
            SimplePropertySetter p = D.s((Object)alias) != null ? new SimplePropertySetter(alias, (DataType)DataTypeUtil.UNKNOWN_TYPE) : new SimplePropertySetter(name, (DataType)DataTypeUtil.UNKNOWN_TYPE);
            PropertyEvaluator e = new PropertyEvaluator(name);
            this.FIELD_MAPPING.put(e, p);
        }
    }

    public Map<String, Object> mapping(Map<String, Object> src) {
        HashMap<String, Object> tar = new HashMap<String, Object>();
        this.FIELD_MAPPING.forEach((k, v) -> {
            Object value = k.eval(null, src, null);
            ((SimplePropertySetter)v).set(tar, value);
        });
        return tar;
    }

    private static class SimplePropertySetter {
        private String[] path;
        private DataType type;

        private SimplePropertySetter(String property, Map<String, DataType> target_properties) {
            this.path = property.split("\\.");
            this.initDataType(target_properties);
        }

        private SimplePropertySetter(String property, DataType type) {
            this.path = property.split("\\.");
            this.type = type;
        }

        private void set(Map<String, Object> tar, Object value) {
            this.assign(tar, 0, value);
        }

        private void assign(Object target, int index, Object value) {
            if (target instanceof List) {
                if (value instanceof Object[]) {
                    this.assignList2List((List)target, index, (Object[])value);
                } else {
                    this.assignValue2List((List)target, index, value);
                }
            } else if (value instanceof Object[]) {
                this.assignList2Map((Map)target, index, (Object[])value);
            } else {
                this.assignValue2Map((Map)target, index, value);
            }
        }

        private void assignValue2Map(Map<String, Object> target, int index, Object value) {
            if (index == this.path.length - 1) {
                target.put(this.path[index], this.narrow(value));
            } else if (index < this.path.length) {
                HashMap tmp = target.get(this.path[index]);
                if (tmp == null) {
                    HashMap map = new HashMap();
                    target.put(this.path[index], map);
                    tmp = map;
                }
                this.assign(tmp, index + 1, value);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u503c\u7684\u5c42\u7ea7\u6bd4\u76ee\u6807\u5355\u5b57\u6bb5\uff08%s\uff09\u7684\u5c42\u7ea7\u6df1\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u3002", (String)"SimpleFieldMapping_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.join((Object[])this.path)));
            }
        }

        private void assignList2Map(Map<String, Object> target, int index, Object[] values) {
            List targets;
            Object t = target.get(this.path[index]);
            int length = values.length;
            if (t == null) {
                targets = new ArrayList(length);
                while (targets.size() < length) {
                    LinkedHashMap item = new LinkedHashMap();
                    targets.add(item);
                }
                target.put(this.path[index], targets);
            } else if (t instanceof Map) {
                targets = new ArrayList(length);
                Map tmp = (Map)t;
                while (targets.size() < length) {
                    LinkedHashMap item = new LinkedHashMap(tmp.size());
                    item.putAll(tmp);
                    targets.add(item);
                }
                target.put(this.path[index], targets);
            } else {
                targets = (List)t;
            }
            this.assignList2List(targets, index + 1, values);
        }

        private void assignValue2List(List<?> targets, int index, Object value) {
            for (Object target : targets) {
                this.assign(target, index, value);
            }
        }

        private void assignList2List(List<?> targets, int index, Object[] values) {
            if (values.length == 0) {
                return;
            }
            if (targets.size() % values.length != 0) {
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u81f4\uff1a%1$s(%2$s)", (String)"SimpleFieldMapping_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.join((Object[])this.path), index));
            }
            int i = 0;
            int j = 0;
            while (i < targets.size()) {
                if (j >= values.length) {
                    j = 0;
                }
                this.assign(targets.get(i), index, values[j]);
                ++i;
                ++j;
            }
        }

        private Object narrow(Object value) {
            return this.type.narrow(value);
        }

        private void initDataType(Map<String, DataType> properties) {
            DataType type = null;
            for (String name : this.path) {
                if (properties == null) {
                    this.type = SimpleValueType.INS;
                    return;
                }
                type = properties.get(name);
                if (type == null) {
                    this.type = SimpleValueType.INS;
                    return;
                }
                properties = type instanceof EntryCollectionType ? ((EntryCollectionType)type).getProperties() : null;
            }
            this.type = type;
        }
    }
}

