/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.e;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.constant.ExecutionStatus;
import kd.isc.iscb.platform.core.dc.e.DataCopyInput;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileCounterJob;
import kd.isc.iscb.platform.core.dc.f.DataFileJob;
import kd.isc.iscb.platform.core.dc.f.DataFileJobLogger;
import kd.isc.iscb.platform.core.dc.f.DataFileType;
import kd.isc.iscb.platform.core.dc.f.DataFileWriter;
import kd.isc.iscb.platform.core.dc.f.SimpleFieldMapping;
import kd.isc.iscb.platform.core.dc.f.e.ExportDataFileFactory;
import kd.isc.iscb.platform.core.dc.f.e.ExportDataFileSchema;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.ConnectionException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectWriter;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ExportDataFileJob
extends DataFileJob {
    public static final ExportDataFileFactory FACTORY = new ExportDataFileFactory();
    private static final DataFileAction action = DataFileAction.EXPORT;
    private DataFileWriter writer;
    private DataCopyProvider provider;
    private DataCopyInput input;
    private SimpleFieldMapping fieldMapping;

    public ExportDataFileJob(String title, Object jobId) {
        super(title, jobId, action);
        this.init();
    }

    public ExportDataFileJob(DynamicObject job) {
        super(job, action);
        this.init();
    }

    private void init() {
        ExportDataFileSchema param = new ExportDataFileSchema(this.job, this.counter);
        this.param = param;
        this.provider = param.getProvider();
        this.fieldMapping = new SimpleFieldMapping(param.getFileschema(), DataFileAction.EXPORT);
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        SignalManager.registerTask(this.jobId);
        try {
            this.export();
        }
        finally {
            SignalManager.unregisterTask(this.jobId);
        }
    }

    public void export() {
        ScheduleManager.submit((Task)new DataFileCounterJob(this), 5);
        this.status = ExecutionStatus.EXECUTIONING;
        try {
            if (!IscLicenseUtil.getTenantLicenseInfo().hasValidLicense()) {
                IscBizException e = new IscBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u8bb8\u53ef\u6570\u91cf\u4e3a\u96f6\u6216\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u65e0\u6cd5\u4f7f\u7528\u6570\u636e\u8fc1\u79fb\u529f\u80fd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4e3a\u96c6\u6210\u4e91\u6dfb\u52a0\u8bb8\u53ef\u3002", (String)"ExportDataFileJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                e.setStackTrace(new StackTraceElement[0]);
                throw e;
            }
            DataFileJobLogger.saveStartLog(this.job, this.counter);
            this.prepare();
            Map<String, Object> src = this.input.read();
            while (src != null) {
                Map<String, Object> tar = this.fieldMapping.mapping(src);
                this.write(tar);
                src = this.input.read();
            }
            this.writer.commit();
            DataFileJobLogger.saveSuccessLog(this.job, this.counter);
            this.status = ExecutionStatus.FINISHED;
        }
        catch (Throwable e) {
            this.status = e instanceof TaskCancelException ? ExecutionStatus.UNDONE : ExecutionStatus.FAIL;
            DataFileJobLogger.saveErrorLog(this.job, e, this.counter);
            throw D.e((Throwable)e);
        }
        finally {
            this.status = ExecutionStatus.FINISHED;
            DbUtil.close((ObjectWriter)this.writer);
            if (this.input != null) {
                this.input.dispose();
            }
        }
    }

    protected void write(Map<String, Object> src) {
        try {
            SignalManager.checkCancelSignal();
            this.writer.write(src);
        }
        catch (Throwable e) {
            this.setFailedAction(src, e);
            this.tryThrowError(e, src);
        }
        finally {
            this.refreshCounter(src);
        }
    }

    private void tryThrowError(Throwable e, Map<String, Object> src) {
        if (e instanceof TaskCancelException) {
            throw (TaskCancelException)e;
        }
        if (e instanceof ConnectionException) {
            throw (ConnectionException)e;
        }
        String text = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s \u5f53\u524d\u6570\u636e\u884c\u662f\uff1a%2$s", (String)"ExportDataFileJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e), Json.toString(src));
        throw new IscBizException(text, e);
    }

    protected void prepare() throws Exception {
        this.writer = DataFileType.buildWriter(this.param, this.job);
        this.input = new DataCopyInput(this.provider);
    }
}

