/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.e;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.IscScript;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileSchema;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.platform.core.dc.meta.DefaultDataCopyProvider;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.data.ValueRange;

public class ExportDataFileSchema
extends DataFileSchema {
    private DataCopyProvider provider;

    public ExportDataFileSchema(DynamicObject job, Counter counter) {
        super(job, DataFileAction.EXPORT);
        this.provider = new DefaultDataCopyProvider(this.meta, this.getSourceConnection(), this.getSourceRequires(), this.prepareFilter(), this.getOrderBy(), this.getSrcDataRetrieveScript(), this.getFilterParams(), counter);
    }

    public DataCopyProvider getProvider() {
        return this.provider;
    }

    private ConnectionWrapper getSourceConnection() {
        long dataSourceId = this.meta.getLong("group_id");
        long dbLink = DataSource.get(dataSourceId).getDbLink();
        return ConnectionManager.getConnection(dbLink);
    }

    private Map<String, Object> getSourceRequires() {
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>();
        for (DynamicObject obj : this.fileschema.getDynamicObjectCollection("fields")) {
            String src = D.s((Object)obj.get("field"));
            if (src == null) continue;
            if (src.indexOf(46) < 0) {
                requires.putIfAbsent(src, 1);
                continue;
            }
            String[] path = src.split("\\.");
            ExportDataFileSchema.addEntryProperty(requires, path);
        }
        return requires;
    }

    private Map<String, Object> getFilterParams() {
        DynamicObjectCollection c = this.job.getDynamicObjectCollection("params_entryentity");
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (DynamicObject item : c) {
            String name = D.s((Object)item.get("params_name"));
            String value = D.s((Object)item.get("params_value"));
            params.put(name, value);
        }
        return params;
    }

    private List<Map<String, Object>> prepareFilter() {
        Map<String, Object> params = this.getFilterParams();
        DynamicObjectCollection filter_entries_schema = (DynamicObjectCollection)this.fileschema.get("filter_entries");
        return this.prepareFilter(params, filter_entries_schema);
    }

    private Script getSrcDataRetrieveScript() {
        String srcDataRetrieveScriptStr = D.s((Object)this.fileschema.get("src_retrieve_script_tag"));
        if (srcDataRetrieveScriptStr == null) {
            srcDataRetrieveScriptStr = D.s((Object)this.fileschema.get("src_retrieve_script"));
        }
        if (srcDataRetrieveScriptStr != null) {
            return IscScript.compile(srcDataRetrieveScriptStr);
        }
        return null;
    }

    private List<Pair<String, String>> getOrderBy() {
        DynamicObjectCollection sort_entries = (DynamicObjectCollection)this.fileschema.get("sort_entries");
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>(sort_entries.size());
        for (DynamicObject dynamicObject : sort_entries) {
            String sort_field = dynamicObject.getString("sort_field");
            String filter_mode = dynamicObject.getString("sort_mode");
            list.add((Pair<String, String>)new Pair((Object)sort_field, (Object)filter_mode));
        }
        return list;
    }

    public static Map<String, Object> addEntryProperty(Map<String, Object> requires, String[] path) {
        Map entry = requires;
        int j = path.length - 1;
        for (int i = 0; i < j; ++i) {
            String name = path[i];
            LinkedHashMap tmp = entry.get(name);
            if (!(tmp instanceof Map)) {
                tmp = new LinkedHashMap();
                entry.put(name, tmp);
            }
            entry = tmp;
        }
        entry.put((String)path[path.length - 1], 1);
        return entry;
    }

    private List<Map<String, Object>> prepareFilter(Map<String, Object> params, DynamicObjectCollection filter_entries) {
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>();
        for (DynamicObject obj : filter_entries) {
            Object filter_column = obj.get("filter_column");
            Object compare = obj.get("filter_compare");
            Object value = this.parseFilterValue(params, obj);
            this.checkFilterValue(filter_column, compare, value);
            if (value instanceof ValueRange) {
                this.handleValueRange(filter, obj, filter_column, (ValueRange)value);
                continue;
            }
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("filter_left_bracket", obj.get("filter_left_bracket"));
            item.put("filter_column", filter_column);
            item.put("filter_compare", compare);
            item.put("filter_value", value);
            item.put("filter_right_bracket", obj.get("filter_right_bracket"));
            item.put("filter_link", obj.get("filter_link"));
            filter.add(item);
        }
        return filter;
    }

    private Object parseFilterValue(Map<String, Object> params, DynamicObject obj) {
        Object value = obj.get("filter_value_fixed");
        value = this.getFilterValue(params, obj, value);
        value = ExprEvaluator.calc(value, null, null, null);
        return value;
    }

    private void checkFilterValue(Object filter_column, Object compare, Object value) {
        if (value == null && !"IS_NULL".equals(compare) && !"IS_NOT_NULL".equals(compare)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5(%s)\u6ca1\u6709\u8bbe\u7f6e\u6bd4\u8f83\u503c\uff01", (String)"ExportDataFileSchema_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter_column));
        }
    }

    private Object getFilterValue(Map<String, Object> params, DynamicObject obj, Object value) {
        if (D.s((Object)value) != null) {
            return value;
        }
        String filter_value_var = obj.getString("filter_value_var");
        return params.get(filter_value_var);
    }

    private void handleValueRange(List<Map<String, Object>> filter, DynamicObject obj, Object filter_column, ValueRange<?> value) {
        ValueRange<?> range = value;
        HashMap<String, Object> item = new HashMap<String, Object>();
        String leftBracket = D.s((Object)obj.get("filter_left_bracket"));
        String rightBracket = D.s((Object)obj.get("filter_right_bracket"));
        item.put("filter_left_bracket", leftBracket == null ? "(" : "(" + leftBracket);
        item.put("filter_column", filter_column);
        item.put("filter_compare", ">=");
        item.put("filter_value", range.getLBound());
        item.put("filter_link", "AND");
        filter.add(item);
        item = new HashMap();
        item.put("filter_column", filter_column);
        item.put("filter_compare", "<=");
        item.put("filter_value", range.getUBound());
        item.put("filter_right_bracket", rightBracket == null ? ")" : rightBracket + ")");
        item.put("filter_link", obj.get("filter_link"));
        filter.add(item);
    }
}

