/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.i;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.IscScript;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileJobLogger;
import kd.isc.iscb.platform.core.dc.f.DataFileSchema;
import kd.isc.iscb.platform.core.dc.f.i.ImportDataFileJob;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.platform.core.dc.meta.DefaultDataCopyConsumer;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.Script;

public class ImportDataFileSchema
extends DataFileSchema {
    private DataCopyConsumer consumer;
    private List<String> judgeFields;
    private Map<String, List<String>> entryJudgeFields = new HashMap<String, List<String>>();
    private Map<String, Set<String>> targetFields = new HashMap<String, Set<String>>();
    private String judgeField;
    private boolean isTraceAll = this.trigger.getBoolean("trace_all");

    public ImportDataFileSchema(DynamicObject jobObj, final ImportDataFileJob importDataFileJob) {
        super(jobObj, DataFileAction.IMPORT);
        this.consumer = new DefaultDataCopyConsumer(this.meta, this.getTargetConnection(), this.getTargetJudgeFields(), this.getTargetActions(), D.s((Object)this.fileschema.get("proxy_user")), this.getTargetFields(), this.getBatchSize(), this.getMode(), null, this.getTargetScript(), null, null, importDataFileJob.getCounter()){

            @Override
            public void saveTargetErrorLog(Throwable error, Map<String, Object> tar) {
                DataFileJobLogger.writeFailLog(tar, importDataFileJob, error);
            }
        };
    }

    public DataCopyConsumer getConsumer() {
        return this.consumer;
    }

    public boolean targetIsService() {
        return "SERVICE".equals(this.meta.get("type"));
    }

    private int getBatchSize() {
        if (this.trigger != null) {
            int batchSize = D.i((Object)this.trigger.get("batch_size"));
            if (batchSize < 0 || this.isTraceAll()) {
                batchSize = 1;
            }
            return batchSize;
        }
        return 1;
    }

    private Script getTargetScript() {
        String tarScriptStr = D.s((Object)this.fileschema.get("tar_script_tag"));
        if (tarScriptStr == null) {
            tarScriptStr = D.s((Object)this.fileschema.get("tar_script"));
        }
        if (tarScriptStr != null) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            this.compositeContext(ctx);
            return IscScript.compile(tarScriptStr, ctx);
        }
        return null;
    }

    private void compositeContext(Map<String, Object> ctx) {
        ctx.put("files", this.getFiles());
    }

    private List<Map<String, Object>> getFiles() {
        return AttachmentUtil.getAttachmentPanelList("isc_import_file_job", this.job.getPkValue(), "import_file_pane");
    }

    private DefaultDataCopyConsumer.Mode getMode() {
        return DefaultDataCopyConsumer.Mode.valueOf(D.s((Object)this.fileschema.get("mode")));
    }

    private ConnectionWrapper getTargetConnection() {
        long dataSourceId = (Long)this.meta.get("group_id");
        long dbLink = DataSource.get(dataSourceId).getDbLink();
        return ConnectionManager.getConnection(dbLink);
    }

    private List<String> getTargetActions() {
        ArrayList<String> target_actions = new ArrayList<String>(2);
        for (DynamicObject i : this.fileschema.getDynamicObjectCollection("target_actions")) {
            String action = D.s((Object)i.getString("tar_action_number"));
            if (action == null) continue;
            target_actions.add(action);
        }
        if (target_actions.isEmpty()) {
            target_actions.add(TableAction._SAVE.name());
        }
        return target_actions;
    }

    public List<String> getJudgeFields() {
        if (this.judgeFields == null) {
            this.initJudgeFields();
        }
        return this.judgeFields;
    }

    public String getJudgeField() {
        this.initJudgeFields();
        return this.judgeField;
    }

    private Map<String, List<String>> getTargetJudgeFields() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String jf = this.getJudgeField();
        map.put("$", jf != null ? Collections.singletonList(jf) : this.getJudgeFields());
        map.putAll(this.entryJudgeFields);
        return map;
    }

    private Map<String, Set<String>> getTargetFields() {
        DynamicObjectCollection inputCollection = this.fileschema.getDynamicObjectCollection("fields");
        for (DynamicObject obj : inputCollection) {
            String input_field = D.s((Object)obj.get("field"));
            if (input_field == null) continue;
            int i = input_field.indexOf(46);
            if (i > 0) {
                this.registerTargetField(input_field.substring(0, i), input_field.substring(i + 1));
                continue;
            }
            this.registerTargetField("", input_field);
        }
        return Collections.unmodifiableMap(this.targetFields);
    }

    private void registerTargetField(String table, String field) {
        Set fields = this.targetFields.computeIfAbsent(table, k -> new LinkedHashSet());
        fields.add(field);
    }

    private void initJudgeFields() {
        if (this.judgeFields == null) {
            this.selectJudgeFields();
            this.initJudgeField();
            if (this.judgeFields.size() == 0 && !this.targetIsService()) {
                throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u65b9\u6848\u6ca1\u6709\u6307\u5b9a\u7528\u4e8e\u5224\u65ad\u6570\u636e\u662f\u5426\u5b58\u5728\u6240\u9700\u7684\u5019\u9009\u952e\u3002", (String)"ImportDataFileSchema_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            Collections.sort(this.judgeFields);
        }
    }

    private void selectJudgeFields() {
        this.judgeFields = new ArrayList<String>();
        DynamicObjectCollection input_collection = this.fileschema.getDynamicObjectCollection("fields");
        for (DynamicObject obj : input_collection) {
            String input_field = obj.getString("field");
            if (input_field == null) continue;
            int i = input_field.lastIndexOf(46);
            if (i > 0) {
                this.setEntryJudgeField(obj, input_field, i);
                continue;
            }
            this.setMainJudgeField(obj, input_field);
        }
    }

    private void initJudgeField() {
        if (this.judgeField == null && this.judgeFields.size() == 1) {
            this.judgeField = this.judgeFields.get(0);
        }
    }

    private void setMainJudgeField(DynamicObject obj, String input_field) {
        if (D.x((Object)obj.get("is_judge_key")) && input_field != null && !this.judgeFields.contains(input_field)) {
            this.judgeFields.add(input_field);
        }
    }

    private void setEntryJudgeField(DynamicObject obj, String tar_field, int i) {
        if (D.x((Object)obj.get("is_judge_key"))) {
            String entry = tar_field.substring(0, i);
            String field = tar_field.substring(i + 1);
            List fields = this.entryJudgeFields.computeIfAbsent(entry, k -> new ArrayList(2));
            if (!fields.contains(field)) {
                fields.add(field);
            }
        }
    }

    public boolean isTraceAll() {
        return this.isTraceAll;
    }
}

