/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.script;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.platform.core.dc.f.e.ExportDataFileJob;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class DataFileOpenApi {
    public static List<String> executeExportDataTrigger(DynamicObject trigger, Map<String, Object> params, DataFileUtils.InitType type) {
        long jobId = DataFileOpenApi.syncExport(trigger, params, type);
        return DataFileOpenApi.getFileBytesList(jobId);
    }

    public static long syncExport(DynamicObject trigger, Map<String, Object> params, DataFileUtils.InitType type) {
        DynamicObject job = DataFileUtils.createDataFileJob(trigger, params, type, DataFileAction.EXPORT);
        if (job == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4efb\u52a1[%s]\u6b63\u5728\u6267\u884c\uff0c\u5fc5\u987b\u7ed3\u675f\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c\u3002", (String)"DataFileOpenApi_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), trigger.get("number")));
        }
        ExportDataFileJob dataFileJob = new ExportDataFileJob(job);
        dataFileJob.export();
        return D.l((Object)job.getPkValue());
    }

    public static Object asyncImport(DynamicObject trigger, Object data, String fileName, DataFileUtils.InitType type) {
        DynamicObject job = DataFileOpenApi.createJobAndAttachFile(trigger, data, fileName, type);
        DataFileAction.IMPORT.startJob(job);
        return job.getPkValue();
    }

    private static DynamicObject createJobAndAttachFile(DynamicObject trigger, Object data, String fileName, DataFileUtils.InitType type) {
        DynamicObject job = DataFileOpenApi.createJob(trigger, DataFileAction.IMPORT, type);
        return DataFileOpenApi.attachFile(job, data, fileName);
    }

    public static DynamicObject createJob(DynamicObject trigger, DataFileAction action, DataFileUtils.InitType type) {
        return DataFileOpenApi.createJob(null, trigger, action, type);
    }

    public static DynamicObject createJob(String jobName, DynamicObject trigger, DataFileAction action, DataFileUtils.InitType type) {
        DynamicObject job = DataFileUtils.createDataFileJob(jobName, trigger, null, type, action);
        if (job == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u4efb\u52a1[%s]\u6b63\u5728\u6267\u884c\uff0c\u5fc5\u987b\u7ed3\u675f\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c\u3002", (String)"DataFileOpenApi_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), trigger.get("number")));
        }
        return job;
    }

    public static DynamicObject attachFile(DynamicObject job, Object data, String fileName) {
        List<Map<String, String>> urlList = DataFileOpenApi.uploadFileToServer(data, job, fileName);
        DataFileUtils.bindingAttachments(urlList, job.getPkValue());
        return job;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Map<String, String>> uploadFileToServer(Object data, DynamicObject job, String fileName) {
        if (!(data instanceof byte[])) {
            throw DataFileError.DATA_FILE_ARGUMENT_ERR.create(new String[]{"1", ResManager.loadKDString((String)"byte\u6570\u7ec4", (String)"DataFileOpenApi_3", (String)"isc-iscb-platform-core", (Object[])new Object[0])});
        }
        if (fileName == null) {
            fileName = job.getString("name");
        }
        fileName = fileName + "." + job.getString("filetype");
        byte[] bs = (byte[])data;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bs);){
            String url = DataFileUtils.uploadFileToServer(in, fileName);
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("file_type", job.getString("filetype"));
            urlMap.put("file_name", fileName);
            urlMap.put("file_size", D.s((Object)bs.length));
            urlMap.put("upload_url", url);
            List<Map<String, String>> list = Collections.singletonList(urlMap);
            return list;
        }
        catch (IOException e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5c06\u5b57\u8282\u6570\u636e\u6301\u4e45\u5316\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25", (String)"DataFileOpenApi_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static List<String> getFileBytesList(long jobId) {
        List<Map<String, Object>> attachmentInfo = AttachmentUtil.getAttachmentPanelList("isc_export_file_job", jobId, "export_files");
        ArrayList<String> result = new ArrayList<String>(attachmentInfo.size());
        for (Map<String, Object> attachment : attachmentInfo) {
            result.add(D.s((Object)attachment.get("srcUrl")));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static byte[] getBytes(String url, long maxFileSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

