/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.DataFileReader;
import kd.isc.iscb.platform.core.dc.f.FileDirectReader;
import kd.isc.iscb.platform.core.dc.f.FileIterator;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelFileReader;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.except.IscBizException;

public class CsvFileReader
extends DataFileReader
implements FileDirectReader {
    private Map<String, Integer> fieldsMap;
    private BufferedReader reader;
    private int startIndex;
    private String delimiter = ",";
    private boolean hasQuot = false;
    private int fieldCount = 0;

    public CsvFileReader(FileIterator it, String delimiter, boolean hasQuot) throws IOException {
        super(it);
        this.delimiter = delimiter;
        this.hasQuot = hasQuot;
        if (this.initReader()) {
            this.initHeader();
        }
    }

    public CsvFileReader(InputStream in, String delimiter, boolean hasQuot) {
        this.delimiter = delimiter;
        this.hasQuot = hasQuot;
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public int getTotalCount() {
        return -1;
    }

    @Override
    public List<Object> readLine() {
        try {
            if (this.reader == null) {
                return null;
            }
            String s = this.reader.readLine();
            if (s != null) {
                String[] arr = this.directParseLine(s);
                return Arrays.asList(arr);
            }
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_READER_FAILURE.wrap((Throwable)e);
        }
        return null;
    }

    public Map<String, Object> read() {
        try {
            if (this.reader == null) {
                return null;
            }
            String s = this.reader.readLine();
            if (s == null && this.initReader()) {
                s = this.reader.readLine();
            }
            if (s != null) {
                return this.mapping(this.parseLine(s));
            }
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_READER_FAILURE.wrap((Throwable)e);
        }
        return null;
    }

    private String[] parseLine(String s) {
        String[] fields = s.split(this.delimiter);
        int curCell = 0;
        String[] values = new String[this.fieldCount];
        while (curCell < this.fieldCount) {
            if (curCell < fields.length) {
                String token = fields[curCell].trim();
                if (this.hasQuot) {
                    token = token.substring(1, token.length() - 1);
                }
                values[curCell++] = token;
                continue;
            }
            values[curCell++] = null;
        }
        return values;
    }

    private String[] directParseLine(String s) {
        String[] fields = s.split(this.delimiter);
        if (this.hasQuot) {
            try {
                for (int i = 0; i < fields.length; ++i) {
                    String token = fields[i].trim();
                    fields[i] = token.substring(1, token.length() - 1);
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IscBizException(ResManager.loadKDString((String)"csv\u6587\u4ef6\u8bfb\u53d6\u53d1\u751f\u6570\u7ec4\u8d8a\u754c\uff0c\u8bf7\u786e\u5b9a\u6587\u4ef6\u5185\u5bb9\u65f6\u5019\u5305\u542b\u5f15\u53f7\u3002", (String)"CsvFileReader_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
            }
        }
        return fields;
    }

    private Map<String, Object> mapping(String[] values) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> entry : this.fieldsMap.entrySet()) {
            ExcelFileReader.parseObj(data, values[entry.getValue()], entry.getKey().split("\\."), 0);
        }
        return data;
    }

    @Override
    public void close() {
        DbUtil.close((Reader)this.reader);
    }

    private boolean initReader() throws IOException {
        this.close();
        InputStream in = this.nextFileStream();
        if (in == null) {
            return false;
        }
        this.reader = new BufferedReader(new InputStreamReader(in));
        int tmp = this.startIndex;
        while (tmp-- != 0) {
            String string = this.reader.readLine();
        }
        return true;
    }

    private void initHeader() throws IOException {
        this.fieldsMap = new HashMap<String, Integer>();
        String line = this.reader.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line, this.delimiter);
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (this.hasQuot) {
                token = token.substring(1, token.length() - 1);
            }
            this.fieldsMap.put(token, index++);
        }
        this.fieldCount = index;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }
}

