/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.csv;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dc.f.DataFileWriter;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.platform.core.dc.f.FileDirectWriter;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.err.DataFileJobFailException;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelFileWriter;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class CsvFileWriter
extends DataFileWriter
implements FileDirectWriter {
    private final Map<String, Integer> targetFields = new LinkedHashMap<String, Integer>();
    private BufferedOutputStream out;
    private File tempFile;
    private boolean hasQuot;
    private String delimiter;

    public CsvFileWriter(FileBinding binding, Map<String, Object> requiredFields, String delimiter, boolean hasQuot) throws Exception {
        super(binding);
        if (delimiter == null) {
            delimiter = ",";
        }
        this.delimiter = delimiter;
        this.hasQuot = hasQuot;
        ExcelFileWriter.buildTargetFields(requiredFields, "", 0, this.targetFields);
        this.prepare();
    }

    public CsvFileWriter(FileBinding binding, String delimiter, boolean hasQuot) throws FileNotFoundException {
        super(binding);
        this.delimiter = delimiter;
        this.hasQuot = hasQuot;
        this.tempFile = this.createTempFile();
        this.out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
    }

    private void prepare() throws Exception {
        this.tempFile = this.createTempFile();
        this.out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        this.appendHeader();
    }

    private void appendHeader() throws IOException {
        CharSequence[] fields = new String[this.targetFields.size()];
        for (Map.Entry<String, Integer> entry : this.targetFields.entrySet()) {
            fields[entry.getValue().intValue()] = this.wrapQuot(entry.getKey());
        }
        this.out.write(String.join((CharSequence)this.delimiter, fields).getBytes(D.UTF_8));
        this.out.write(13);
        this.out.write(10);
    }

    private File createTempFile() {
        return AttachmentUtil.createTempFile("csv");
    }

    @Override
    public void writeLine(List<Object> list) {
        try {
            String line = this.joinByDelimiter(list);
            this.out.write(line.getBytes(D.UTF_8));
            this.out.write(13);
            this.out.write(10);
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_WRITER_FAILRUE.wrap((Throwable)e);
        }
    }

    public void write(Map<String, Object> data) {
        try {
            this.checkAndSwap();
            String line = this.joinByDelimiter(data);
            this.out.write(line.getBytes(D.UTF_8));
            this.out.write(13);
            this.out.write(10);
            data.put("$action", SaveDataType.UNKNOWN);
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_WRITER_FAILRUE.wrap((Throwable)e);
        }
    }

    private void checkAndSwap() throws Exception {
        if (this.tempFile.length() >= this.getBinding().maxFileSize()) {
            DbUtil.close((OutputStream)this.out);
            super.commit(this.tempFile);
            FileUtil.delete(this.tempFile);
            this.prepare();
        }
    }

    private String joinByDelimiter(List<Object> list) {
        StringBuilder sb = new StringBuilder();
        if (list.size() < 1) {
            return "";
        }
        sb.append(D.s((Object)list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            sb.append(this.delimiter);
            sb.append(CsvFileWriter.toString(list.get(i)));
        }
        return sb.toString();
    }

    private String joinByDelimiter(Map<String, Object> data) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.targetFields.entrySet()) {
            if (entry.getKey().contains(".")) {
                String[] ss = entry.getKey().split("\\.");
                Object tmp = data;
                for (String s : ss) {
                    if (tmp == null) break;
                    if (!(tmp instanceof Map)) {
                        throw new DataFileJobFailException(ResManager.loadKDString((String)"CSV\u6587\u4ef6\u4e0d\u652f\u6301\u5206\u5f55\u6570\u636e\u7684\u5bfc\u51fa\u3002", (String)"CsvFileWriter_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                    }
                    tmp = tmp.get(s);
                }
                sb.append(this.wrapQuot(CsvFileWriter.toString(entry.getKey(), tmp)));
            } else {
                sb.append(this.wrapQuot(CsvFileWriter.toString(entry.getKey(), data.get(entry.getKey()))));
            }
            sb.append(this.delimiter);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String wrapQuot(String field) {
        return this.hasQuot ? "" + field + "" : field;
    }

    public static String toString(String key, Object value) {
        if (value instanceof Map) {
            throw new DataFileJobFailException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 \u201c%s\u201d \u914d\u7f6e\u9519\u8bef\uff0cCSV\u4e0d\u652f\u6301\u5bfc\u51faMap\u7ed3\u6784\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4e0b\u5c42\u4e0d\u80fd\u518d\u62c6\u5206\u7684\u5b57\u6bb5\uff0c\u591a\u8bed\u8a00\u5b57\u6bb5\u5e94\u9009\u62e9\u5177\u4f53\u8bed\u8a00\u5bfc\u51fa\uff0c\u5982 modifier.name.zh_CN", (String)"CsvFileWriter_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private static String toString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public void close() {
        DbUtil.close((OutputStream)this.out);
        FileUtil.delete(this.tempFile);
    }

    @Override
    public void commit() {
        try {
            DbUtil.close((OutputStream)this.out);
            super.commit(this.tempFile);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public boolean rollback(Throwable cause) {
        return false;
    }
}

