/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.DataFileReader;
import kd.isc.iscb.platform.core.dc.f.FileDirectReader;
import kd.isc.iscb.platform.core.dc.f.FileIterator;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.err.DataFileJobFailException;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelType;
import kd.isc.iscb.platform.core.dc.f.t.excel.SheetDataReadHelper;
import kd.isc.iscb.util.except.IscBizException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelFileReader
extends DataFileReader
implements FileDirectReader {
    private Workbook workbook;
    private Sheet sheet;
    private int curSheetIndex = 0;
    private int curRowIndex = 0;
    private ExcelType excelType;
    private Map<String, List<String>> judgeFields;
    private SheetDataReadHelper readHelper;

    public ExcelFileReader(FileIterator it, Map<String, List<String>> judgeFields, ExcelType excelType) throws Exception {
        super(it);
        this.excelType = excelType;
        this.judgeFields = judgeFields;
        this.initWorkBook();
    }

    public ExcelFileReader(InputStream in, int sheetIndex, ExcelType excelType) throws Exception {
        this.excelType = excelType;
        this.workbook = excelType.initReaderWorkBook(in);
        if (sheetIndex >= this.workbook.getNumberOfSheets()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u8d85\u51fa\u6700\u5927\u7d22\u5f15\u9875\u6570\uff0c\u5f53\u524dExcel\u6587\u4ef6\u5171 %2$s\u9875sheet", (String)"ExcelFileReader_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), sheetIndex, this.workbook.getNumberOfSheets()));
        }
        this.curSheetIndex = sheetIndex;
        this.sheet = this.workbook.getSheetAt(sheetIndex);
    }

    public int getTotalCount() {
        return -1;
    }

    @Override
    public List<Object> readLine() {
        try {
            Row row = this.sheet.getRow(this.curRowIndex++);
            if (row == null && this.initWorkBook()) {
                row = this.sheet.getRow(this.curRowIndex++);
            }
            if (row != null) {
                int num = row.getLastCellNum();
                ArrayList<Object> list = new ArrayList<Object>(num);
                for (int i = 0; i < num; ++i) {
                    Cell cell = row.getCell(i);
                    list.add(this.excelType.getValue(cell));
                }
                return list;
            }
            return null;
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_READER_FAILURE.wrap((Throwable)e);
        }
    }

    public Map<String, Object> read() {
        try {
            Map<String, Object> data = this.readHelper.read();
            if (data == null && this.initWorkBook()) {
                return this.readHelper.read();
            }
            return data;
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_READER_FAILURE.wrap((Throwable)e);
        }
    }

    public boolean nextSheet() {
        if (this.curSheetIndex + 1 < this.workbook.getNumberOfSheets()) {
            this.sheet = this.workbook.getSheetAt(++this.curSheetIndex);
            this.curRowIndex = 0;
            return true;
        }
        return false;
    }

    public String getCurrentSheetName() {
        if (this.sheet != null) {
            return this.sheet.getSheetName();
        }
        return "";
    }

    public static Object parseObj(Map<String, Object> data, Object value, String[] fields, int index) {
        if (index == fields.length - 1) {
            data.put(fields[index], value);
            return data;
        }
        Object obj = ExcelFileReader.parseObj(new HashMap<String, Object>(), value, fields, index + 1);
        data.put(fields[index], obj);
        return data;
    }

    @Override
    public void close() {
        this.close((AutoCloseable)this.workbook);
    }

    private boolean initWorkBook() throws IOException {
        this.close();
        InputStream in = this.nextFileStream();
        if (in == null) {
            return false;
        }
        this.workbook = this.excelType.initReaderWorkBook(in);
        this.hasTag();
        this.sheet = this.workbook.getSheetAt(0);
        this.curRowIndex = 1;
        this.readHelper = new SheetDataReadHelper(this.sheet, this.judgeFields, ExcelType.XLSX);
        return true;
    }

    private boolean hasTag() {
        try {
            Sheet sheet = this.workbook.getSheetAt(1);
            for (int i = 0; i < 7; ++i) {
                Row row = sheet.getRow(i);
                Cell cell = row.getCell(0);
                if (!"connection_type_number".equals(cell.getStringCellValue())) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new DataFileJobFailException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4f9b\u8fa8\u8bc6\u7684\u6807\u8bc6\uff0c\u8bf7\u5728\u6587\u4ef6\u5f00\u5934\u6dfb\u52a0\u6a21\u677f\u4e2d\u7684\u6807\u8bc6\u3002", (String)"ExcelFileReader_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e);
        }
        throw new DataFileJobFailException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4f9b\u8fa8\u8bc6\u7684\u6807\u8bc6\uff0c\u8bf7\u5728\u6587\u4ef6\u5f00\u5934\u6dfb\u52a0\u6a21\u677f\u4e2d\u7684\u6807\u8bc6\u3002", (String)"ExcelFileReader_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }
}

