/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.excel;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.DataFileWriter;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.platform.core.dc.f.FileDirectWriter;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.err.DataFileJobFailException;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelType;
import kd.isc.iscb.platform.core.dc.f.t.excel.SheetDataWriteHelper;
import kd.isc.iscb.platform.core.dc.f.tag.FileTag;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelFileWriter
extends DataFileWriter
implements FileDirectWriter {
    private FileTag fileTag;
    private Map<String, Object> targetFields;
    private Workbook workbook;
    private Sheet sheet;
    private int curRowIndex = 0;
    private long currentFileSize;
    private int headerSize;
    private ExcelType excelType;
    private SheetDataWriteHelper writeHelper;
    protected File tempFile;

    public ExcelFileWriter(FileBinding binding, Map<String, Object> requiredFields, FileTag fileTag, ExcelType excelType) throws Exception {
        super(binding);
        this.excelType = excelType;
        this.fileTag = fileTag;
        this.buildColumnNumber(requiredFields, 0);
        this.targetFields = requiredFields;
        this.prepare();
    }

    public ExcelFileWriter(FileBinding binding, String sheetName, ExcelType excelType) {
        super(binding);
        this.excelType = excelType;
        this.workbook = excelType.initWriterWorkBook();
        this.sheet = StringUtil.isEmpty((String)sheetName) ? this.workbook.createSheet() : this.workbook.createSheet(sheetName);
        this.curRowIndex = 0;
        this.currentFileSize = 0L;
    }

    public void nextSheet(String sheetName) {
        this.sheet = this.workbook.createSheet(sheetName);
        this.curRowIndex = 0;
    }

    public static int buildTargetFields(Map<String, Object> requiredFields, String preFix, int curRowIndex, Map<String, Integer> targetFields) {
        for (Map.Entry<String, Object> entry : requiredFields.entrySet()) {
            String preTmp;
            String string = preTmp = StringUtil.isEmpty((String)preFix) ? entry.getKey() : preFix + "." + entry.getKey();
            if (entry.getValue() instanceof Map) {
                curRowIndex = ExcelFileWriter.buildTargetFields((Map)entry.getValue(), preTmp, curRowIndex, targetFields);
                continue;
            }
            targetFields.put(preTmp, curRowIndex++);
        }
        return curRowIndex;
    }

    private void prepare() {
        this.workbook = this.excelType.initWriterWorkBook();
        this.sheet = this.workbook.createSheet();
        this.writeHelper = new SheetDataWriteHelper(this.sheet, this.targetFields);
        this.curRowIndex = 0;
        this.currentFileSize = 0L;
        if (this.headerSize == 0) {
            this.calcHeaderSize();
        }
        Row row = this.sheet.createRow(0);
        this.addHeader(row, "", this.targetFields);
        this.addTag();
    }

    private int buildColumnNumber(Map<String, Object> targetFields, int index) {
        for (Map.Entry<String, Object> entry : targetFields.entrySet()) {
            if (entry.getValue() instanceof Integer) {
                entry.setValue(index++);
                continue;
            }
            index = this.buildColumnNumber((Map)entry.getValue(), index);
        }
        return index;
    }

    private void addTag() {
        Sheet sheet = this.workbook.createSheet(ResManager.loadKDString((String)"\u6807\u8bc6", (String)"ExcelFileWriter_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        int i = 0;
        for (Map.Entry<String, String> entry : this.fileTag.getTagMap().entrySet()) {
            Row row = sheet.createRow(i++);
            Cell cell0 = row.createCell(0);
            cell0.setCellValue(entry.getKey());
            Cell cell1 = row.createCell(1);
            cell1.setCellValue(entry.getValue());
        }
        Row row = sheet.createRow(i);
        Cell tip = row.createCell(0);
        tip.setCellValue(ResManager.loadKDString((String)"*\u6b64\u9875\u5185\u5bb9\u7981\u6b62\u4fee\u6539\u3002", (String)"ExcelFileWriter_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        CellStyle style = this.workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.RED.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        tip.setCellStyle(style);
    }

    public void write(Map<String, Object> data) {
        this.writeHelper.write(data);
        this.checkAndSwap(data);
    }

    @Override
    public void writeLine(List<Object> list) {
        Row row = this.sheet.createRow(this.curRowIndex++);
        for (int i = 0; i < list.size(); ++i) {
            row.createCell(i).setCellValue(D.s((Object)list.get(i)));
        }
    }

    @Deprecated
    private boolean setCellValue(StringBuilder field, Object value, Row row) {
        String key = field.toString();
        Integer index = D.i((Object)this.targetFields.get(key));
        if (index != null) {
            row.createCell(index.intValue()).setCellValue(ExcelFileWriter.toString(key, value));
            return true;
        }
        return false;
    }

    private void checkAndSwap(Object data) {
        this.currentFileSize += this.calcSize(data);
        if (this.excelType.checkAndSwap(this.currentFileSize, this.getBinding().maxFileSize(), this.curRowIndex)) {
            this.commit();
            this.prepare();
        }
    }

    private void calcHeaderSize() {
        this.headerSize = D.i((Object)DbUtil.getObjectSize(this.targetFields));
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void commit() {
        this.tempFile = this.excelType.createTempFile();
        try (FileOutputStream out = new FileOutputStream(this.tempFile);){
            this.workbook.write((OutputStream)out);
            this.commit(this.tempFile);
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_WRITER_ERR.wrap((Throwable)e);
        }
        finally {
            this.dispose();
        }
    }

    private void dispose() {
        this.excelType.dispose(this.workbook);
        this.close((Closeable)this.workbook);
        FileUtil.delete(this.tempFile);
    }

    public boolean rollback(Throwable cause) {
        return false;
    }

    public static String toString(String key, Object value) {
        if (value instanceof Map) {
            throw new DataFileJobFailException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 \u201c%s\u201d \u914d\u7f6e\u9519\u8bef\uff0cExcel\u4e0d\u652f\u6301\u5bfc\u51faMap\u7ed3\u6784\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4e0b\u5c42\u4e0d\u80fd\u518d\u62c6\u5206\u7684\u5b57\u6bb5\uff0c\u591a\u8bed\u8a00\u5b57\u6bb5\u5e94\u9009\u62e9\u5177\u4f53\u8bed\u8a00\u5bfc\u51fa\uff0c\u5982 modifier.name.zh_CN", (String)"ExcelFileWriter_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private void addHeader(Row row, String key, Map<String, Object> fields) {
        CellStyle style = this.workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.SKY_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            if (entry.getValue() instanceof Map) {
                String pre = key + entry.getKey() + ".";
                this.addHeader(row, pre, (Map)entry.getValue());
                continue;
            }
            Cell cell = row.createCell(D.i((Object)entry.getValue()));
            cell.setCellValue(key + entry.getKey());
            cell.setCellStyle(style);
        }
    }

    private long calcSize(Object data) {
        return DbUtil.getObjectSize((Object)data) - (long)this.headerSize;
    }
}

