/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.excel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public enum ExcelType {
    XLSX{

        @Override
        public Workbook initReaderWorkBook(InputStream in) throws IOException {
            return new XSSFWorkbook(in);
        }

        @Override
        public Workbook initWriterWorkBook() {
            return new SXSSFWorkbook(100);
        }

        @Override
        public Object getValue(Cell cell) {
            if (cell == null) {
                return null;
            }
            switch (cell.getCellType()) {
                case STRING: {
                    return cell.getStringCellValue();
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case NUMERIC: {
                    return cell.getNumericCellValue();
                }
            }
            return ((XSSFCell)cell).getRawValue();
        }

        @Override
        public void dispose(Workbook workbook) {
            ((SXSSFWorkbook)workbook).dispose();
        }

        @Override
        public File createTempFile() {
            return AttachmentUtil.createTempFile("xlsx");
        }

        @Override
        public boolean checkAndSwap(long currentFileSize, long maxFileSize, int curRowIndex) {
            return (double)currentFileSize * 0.43 >= (double)maxFileSize;
        }
    }
    ,
    XLS{

        @Override
        public Workbook initReaderWorkBook(InputStream in) throws IOException {
            return new HSSFWorkbook(in);
        }

        @Override
        public Workbook initWriterWorkBook() {
            return new HSSFWorkbook();
        }

        @Override
        public Object getValue(Cell cell) {
            if (cell == null) {
                return null;
            }
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case NUMERIC: {
                    return cell.getNumericCellValue();
                }
            }
            return cell.getStringCellValue();
        }

        @Override
        public void dispose(Workbook workbook) {
        }

        @Override
        public File createTempFile() {
            return AttachmentUtil.createTempFile("xls");
        }

        @Override
        public boolean checkAndSwap(long currentFileSize, long maxFileSize, int curRowIndex) {
            return (double)currentFileSize * 0.43 >= (double)maxFileSize || curRowIndex >= 65535;
        }
    };


    public abstract Workbook initReaderWorkBook(InputStream var1) throws IOException;

    public abstract Workbook initWriterWorkBook();

    public abstract Object getValue(Cell var1);

    public abstract void dispose(Workbook var1);

    public abstract File createTempFile();

    public abstract boolean checkAndSwap(long var1, long var3, int var5);
}

