/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.json;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.DataFileReader;
import kd.isc.iscb.platform.core.dc.f.FileIterator;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.err.DataFileJobFailException;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.misc.Json;

public class JsonFileReader
extends DataFileReader {
    private BufferedReader reader;

    public JsonFileReader(FileIterator it) throws Exception {
        super(it);
        this.initReader();
    }

    public void close() {
        DbUtil.close((Reader)this.reader);
    }

    public int getTotalCount() {
        return -1;
    }

    public Map<String, Object> read() {
        try {
            if (this.reader == null) {
                return null;
            }
            String s = this.reader.readLine();
            if (s == null && this.initReader()) {
                s = this.reader.readLine();
            }
            if (s != null) {
                return (Map)JSON.parseObject((String)s, Map.class);
            }
            return null;
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_READER_FAILURE.wrap((Throwable)e);
        }
    }

    private boolean initReader() throws Exception {
        this.close();
        InputStream in = this.nextFileStream();
        if (in == null) {
            return false;
        }
        this.reader = new BufferedReader(new InputStreamReader(in));
        String tag = this.reader.readLine();
        this.isTag(tag);
        return true;
    }

    private boolean isTag(String tagStr) throws Exception {
        Map tag = (Map)Json.toObject((String)tagStr);
        if (tag.containsKey("connection_type_number")) {
            return true;
        }
        throw new DataFileJobFailException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4f9b\u8fa8\u8bc6\u7684\u6807\u8bc6\uff0c\u8bf7\u5728\u6587\u4ef6\u5f00\u5934\u6dfb\u52a0\u6a21\u677f\u4e2d\u7684\u6807\u8bc6\u3002", (String)"JsonFileReader_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }
}

