/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.tag;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.err.DataFileJobFailException;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;

public class FileTag {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static List<Set<String>> SIMILAR_SYSTEM = new ArrayList<Set<String>>();
    private String connection_type;
    private String ip;
    private String port;
    private String data_center;
    private String sys_name;
    private Date export_time;
    private String user;

    public FileTag(Object dataSourceId) {
        DynamicObject link;
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source", (String)"id,dblink");
        try {
            link = BusinessDataServiceHelper.loadSingle((Object)dataSource.get("dblink_id"), (String)"isc_database_link");
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7cfb\u7edf\u8fde\u63a5\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u5bf9\u8c61\u4e2d\u6570\u636e\u6e90\u7684\u8fde\u63a5\u914d\u7f6e\u662f\u5426\u5b58\u5728\u3002", (String)"FileTag_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
        this.connection_type = link.getString("database_type");
        this.ip = link.getString("server_ip");
        this.port = link.getString("server_port");
        this.data_center = link.getString("data_center");
        DynamicObject conType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"id,name", (QFilter[])QFilterUtil.builder().put("number", "=", this.connection_type).build());
        if (conType != null) {
            this.sys_name = conType.getString("name");
        }
        this.export_time = new Date();
        this.user = RequestContext.get().getUserName();
    }

    public FileTag() {
    }

    public boolean suit(String s) {
        return this.suit((Map)Json.toObject((String)s));
    }

    public boolean suit(Map<String, String> map) {
        try {
            if (map != null && this.connection_type != null) {
                String number = map.get("connection_type_number");
                if (this.connection_type.equals(map.get("connection_type_number"))) {
                    return true;
                }
                for (Set<String> sysSet : SIMILAR_SYSTEM) {
                    if (!sysSet.contains(this.connection_type) || !sysSet.contains(number)) continue;
                    return true;
                }
            }
            StringBuilder mes = new StringBuilder();
            if (map != null) {
                mes.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u6587\u4ef6\u7cfb\u7edf\u7c7b\u578b\u4e3a\uff1a%1$s(%2$s)\uff0c\u76ee\u6807\u7cfb\u7edf\u7c7b\u578b\u4e3a\uff1a%3$s(%4$s)\uff1b", (String)"FileTag_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), map.get("system_name"), map.get("connection_type_number"), this.sys_name, this.connection_type));
            } else {
                mes.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6587\u4ef6\u4e2d\u7684\u7cfb\u7edf\u6807\u8bc6\uff0c\u76ee\u6807\u7cfb\u7edf\u7c7b\u578b\u4e3a\uff1a", (String)"FileTag_5", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(this.sys_name).append('(').append(this.connection_type).append(")\uff1b");
            }
            throw new DataFileJobFailException(mes.toString());
        }
        catch (Exception e) {
            if (e instanceof DataFileJobFailException) {
                throw DataFileError.DATA_FILE_TAG_NOT_SUIT.wrap((Throwable)e);
            }
            String errMes = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7cfb\u7edf\u6807\u8bc6\uff0c\u5f53\u524d\u6807\u8bc6\u4f4d\u7f6e\u5185\u5bb9\u4e3a\uff1a%1$s\uff1b\u76ee\u6807\u7cfb\u7edf\u7c7b\u578b\u4e3a\uff1a%2$s", (String)"FileTag_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Json.toString(map), this.sys_name);
            IscBizException err = new IscBizException(errMes);
            throw DataFileError.DATA_FILE_TAG_NOT_SUIT.wrap((Throwable)err);
        }
    }

    public Map<String, String> getTagMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("connection_type_number", this.connection_type);
        map.put("system_name", this.sys_name);
        map.put("server_ip", this.ip);
        map.put("server_port", this.port);
        map.put("data_center", this.data_center);
        map.put("export_time", this.dateFormat.format(this.export_time));
        map.put("user", this.user);
        return map;
    }

    public String getConnection_type() {
        return this.connection_type;
    }

    public void setConnection_type(String connection_type) {
        this.connection_type = connection_type;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getData_center() {
        return this.data_center;
    }

    public void setData_center(String data_center) {
        this.data_center = data_center;
    }

    public String getSys_name() {
        return this.sys_name;
    }

    public void setSys_name(String sys_name) {
        this.sys_name = sys_name;
    }

    public Date getExport_time() {
        return this.export_time;
    }

    public void setExport_time(Date export_time) {
        this.export_time = export_time;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("self");
        set.add("ierp");
        SIMILAR_SYSTEM.add(set);
    }
}

