/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.validate;

import java.io.InputStream;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.isc.iscb.platform.core.dc.f.tag.FileTag;
import kd.isc.iscb.platform.core.dc.f.validate.FileValidator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxFileValidator
implements FileValidator {
    private FileTag fileTag;

    public XlsxFileValidator(FileTag fileTag) {
        this.fileTag = fileTag;
    }

    @Override
    public boolean validate(String cacheFileUrl) throws Exception {
        TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream input = downLoad.getInputStream(cacheFileUrl);){
            XSSFWorkbook workbook = new XSSFWorkbook(input);
            boolean bl = XlsxFileValidator.validate((Workbook)workbook, this.fileTag);
            return bl;
        }
    }

    public static boolean validate(Workbook workbook, FileTag fileTag) throws Exception {
        Sheet sheet = workbook.getSheetAt(1);
        int size = fileTag.getTagMap().size();
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            Cell cell0 = row.getCell(0);
            Cell cell1 = row.getCell(1);
            map.put(cell0.getStringCellValue(), cell1.getStringCellValue());
        }
        return fileTag.suit(map);
    }
}

