/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.v.Evaluator;
import kd.isc.iscb.platform.core.dc.meta.AbstractDataCopyConsumer;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public abstract class DefaultDataCopyConsumer
extends AbstractDataCopyConsumer {
    private Counter counter;
    private Map<String, List<String>> judgeFields;
    private DynamicObject publisherQueueTopic;
    private List<DynamicObject> publisherQueueTopicList;
    private String targetDataHandler;
    private Script targetDataScript;
    private boolean batchMode;
    private boolean rollbackOnError;
    private boolean breakOnError;
    private ConnectionWrapper cn;
    private int batchSize;
    private List<String> targetActions;
    private Map<String, Object> targetActionParams;
    private Map<String, Set<String>> targetFields;
    private Evaluator proxy_user;
    private boolean has_dynamic_proxy_user;

    protected DefaultDataCopyConsumer(DynamicObject meta, ConnectionWrapper cn, Map<String, List<String>> judgeFields, List<String> targetActions, String proxy_user, Map<String, Set<String>> targetFields, int batchSize, Mode mode, String targetDataHandler, Script targetDataScript, DynamicObject publisherQueueTopic, List<DynamicObject> publisherQueueTopicList, Counter counter) {
        super(meta);
        this.initMemberVariables(cn, judgeFields, targetActions, proxy_user, targetFields, batchSize, mode, targetDataHandler, targetDataScript, publisherQueueTopic, publisherQueueTopicList, counter);
    }

    private void initMemberVariables(ConnectionWrapper cn, Map<String, List<String>> judgeFields, List<String> targetActions, String proxy_user, Map<String, Set<String>> targetFields, int batchSize, Mode mode, String targetDataHandler, Script targetDataScript, DynamicObject publisherQueueTopic, List<DynamicObject> publisherQueueTopicList, Counter counter) {
        this.cn = cn;
        this.publisherQueueTopic = publisherQueueTopic;
        this.publisherQueueTopicList = publisherQueueTopicList;
        this.targetDataHandler = targetDataHandler;
        this.targetDataScript = targetDataScript;
        this.targetActions = targetActions;
        this.batchSize = batchSize;
        this.batchMode = this.initBatchMode(batchSize);
        this.judgeFields = judgeFields;
        this.targetFields = targetFields;
        this.rollbackOnError = Mode.RequiresTransaction == mode;
        this.breakOnError = Mode.BreakOnError == mode;
        Pair<Evaluator, Boolean> p = DataCopyParam.getProxyUser(proxy_user);
        this.proxy_user = (Evaluator)p.getKey();
        this.has_dynamic_proxy_user = (Boolean)p.getValue();
        this.counter = counter;
        this.checkConstructorParams();
    }

    protected DefaultDataCopyConsumer(DynamicObject meta, ConnectionWrapper cn, Map<String, List<String>> judgeFields, List<String> targetActions, Map<String, Object> targetActionParams, String proxy_user, Map<String, Set<String>> targetFields, int batchSize, Mode mode, String targetDataHandler, Script targetDataScript, DynamicObject publisherQueueTopic, List<DynamicObject> publisherQueueTopicList, Counter counter) {
        super(meta);
        this.initMemberVariables(cn, judgeFields, targetActions, proxy_user, targetFields, batchSize, mode, targetDataHandler, targetDataScript, publisherQueueTopic, publisherQueueTopicList, counter);
        this.targetActionParams = targetActionParams;
    }

    protected DefaultDataCopyConsumer(DynamicObject meta, ConnectionWrapper cn, Map<String, List<String>> judgeFields, List<String> targetActions, String proxy_user, Map<String, Set<String>> targetFields, int batchSize, Mode mode, String targetDataHandler, Script targetDataScript, DynamicObject publisherQueueTopic, List<DynamicObject> publisherQueueTopicList) {
        this(meta, cn, judgeFields, targetActions, proxy_user, targetFields, batchSize, mode, targetDataHandler, targetDataScript, publisherQueueTopic, publisherQueueTopicList, new Counter());
    }

    protected DefaultDataCopyConsumer(DynamicObject meta, Counter counter) {
        super(meta);
        this.counter = counter;
    }

    private void checkConstructorParams() {
        if (this.isService() || this.publisherQueueTopic != null || this.targetDataHandler != null || this.targetDataScript != null) {
            return;
        }
        DynamicObject meta = this.getMeta();
        if (this.isTable() || this.isEntity()) {
            if (this.judgeFields == null || this.targetActions == null || this.targetFields == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u201c%1$s\uff08%2$s\uff09\u201d\u4f5c\u4e3a\u76ee\u6807\u5bf9\u8c61\u65f6\uff0c\u5fc5\u987b\u63d0\u4f9b\u201c\u5019\u9009\u952e\u5b57\u6bb5\u201d\u3001\u201c\u76ee\u6807\u64cd\u4f5c\u201d\u548c\u201c\u76ee\u6807\u5b57\u6bb5\u201d\u8bbe\u7f6e\u3002", (String)"DefaultDataCopyConsumer_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.get("name"), meta.get("number")));
            }
        } else if (this.isQuery() || this.isView() || this.isStruct()) {
            if (this.publisherQueueTopic == null && this.targetDataHandler == null && this.targetDataScript == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u201c%1$s\uff08%2$s\uff09\u201d\u4f5c\u4e3a\u76ee\u6807\u5bf9\u8c61\u65f6\uff0c\u5fc5\u987b\u63d0\u4f9b\u201c\u76ee\u6807\u6570\u636e\u5904\u7406\u811a\u672c\u201d\u3001\u201c\u76ee\u6807\u6570\u636e\u5904\u7406\u7c7b\u201d\u6216\u201cMQ\u961f\u5217\u53d1\u5e03\u4e3b\u9898\u201d\u8bbe\u7f6e\u3002", (String)"DefaultDataCopyConsumer_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.get("name"), meta.get("number")));
            }
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u201c%1$s\uff08%2$s\uff09\u201d\u4e0d\u80fd\u4f5c\u4e3a\u76ee\u6807\u5bf9\u8c61\u5904\u7406\u6570\u636e\u3002", (String)"DefaultDataCopyConsumer_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.get("name"), meta.get("number")));
        }
    }

    private boolean initBatchMode(int batchSize) {
        if (batchSize == 1) {
            return false;
        }
        if (!this.isTable() && !this.isBatchScript()) {
            return false;
        }
        List<String> actions = this.getTargetActions();
        if (actions.size() > 1) {
            return false;
        }
        return actions.size() == 0 || TableAction.find((String)actions.get(0)) != null;
    }

    public final boolean isBatchScript() {
        return this.batchSize > 1 && this.targetDataScript != null && this.targetDataScript.getProgram().getContext().get("_tars") != null;
    }

    @Override
    public ConnectionWrapper getTargetConnection() {
        return this.cn;
    }

    @Override
    public Collection<String> getTargetFields(String table_name) {
        Set<String> fields = this.targetFields.get(table_name);
        if (fields != null) {
            return Collections.unmodifiableCollection(fields);
        }
        if (D.s((Object)table_name) == null) {
            table_name = this.getTableName();
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6570\u636e\u8868\uff08%s\uff09\u7684\u5b57\u6bb5\u3002", (String)"DefaultDataCopyConsumer_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), table_name));
    }

    @Override
    public String getProxyUser(Map<String, Object> data) {
        return DataCopyParam.evalProxyUser(null, this.proxy_user, data);
    }

    @Override
    public List<String> getTargetActions() {
        if (this.targetActions == null) {
            return new ArrayList<String>(1);
        }
        return new ArrayList<String>(this.targetActions);
    }

    @Override
    public String getTargetDataHandler() {
        return this.targetDataHandler;
    }

    @Override
    public Script getTargetDataScript() {
        return this.targetDataScript;
    }

    @Override
    public Map<String, List<String>> getTargetJudgeFields() {
        return Collections.unmodifiableMap(this.judgeFields);
    }

    @Override
    public List<String> getJudgeFields() {
        return Collections.unmodifiableList(this.judgeFields.get("$"));
    }

    @Override
    public boolean targetToMQ() {
        return this.publisherQueueTopic != null;
    }

    @Override
    public boolean targetIsMQS() {
        return this.publisherQueueTopicList != null;
    }

    @Override
    public DynamicObject getPublisherQueue() {
        return this.publisherQueueTopic;
    }

    @Override
    public List<DynamicObject> getPublisherQueueList() {
        return this.publisherQueueTopicList;
    }

    @Override
    public String getDataProducerDesc() {
        DynamicObject meta = this.getMeta();
        return StringUtil.trim((String)("M:" + meta.getString("number")), (int)50);
    }

    @Override
    public boolean isBatchMode() {
        return this.batchMode;
    }

    @Override
    public boolean isRollbackOnError() {
        return this.rollbackOnError;
    }

    @Override
    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    @Override
    public Map<String, Pair<Table, String>> getTargetEntryTables() {
        return new HashMap<String, Pair<Table, String>>();
    }

    @Override
    public boolean supportsBizBatchAction() {
        if (this.batchSize <= 1) {
            return false;
        }
        if (this.getTargetActions().size() > 1) {
            return false;
        }
        if (this.has_dynamic_proxy_user) {
            return false;
        }
        return this.cn.getFactory().supportsBizBatchAction(this.cn);
    }

    @Override
    public Map<String, Object> getTargetActionParams() {
        return this.targetActionParams;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Pair<String, String> getTaskInfo() {
        DynamicObject meta = this.getMeta();
        return new Pair((Object)meta.getString("name"), (Object)meta.getString("number"));
    }

    @Override
    public Map<String, Object> getFilterParams() {
        return new HashMap<String, Object>(1);
    }

    @Override
    public Counter getCounter() {
        return this.counter;
    }

    public static enum Mode {
        ResumeOnError,
        RequiresTransaction,
        BreakOnError;

    }
}

